/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Component;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.ui.plugin.file.PathPrefixes;

public class FindFile {
    private Vector prefixList = new Vector(5, 5);
    private JFileChooser fileChooser;
    private Component window;

    public FindFile(Component window) {
        this.window = window;
        this.fileChooser = new JFileChooser();
        this.fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
        this.fileChooser.setDialogTitle("Choose current location of: ");
        this.fileChooser.setDialogType(0);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
    }

    public FindFile(Component window, JFileChooser fileChooser) {
        this(window);
        this.fileChooser = fileChooser;
    }

    public String getFileName(String filenamepath) throws Exception {
        File oldFile = new File(filenamepath);
        String oldPath = oldFile.getPath();
        for (PathPrefixes prefix : this.prefixList) {
            if (oldPath.toLowerCase().indexOf(prefix.getOldPrefix().toLowerCase()) <= -1) continue;
            String newFileNamePath = filenamepath.substring(prefix.getOldPrefix().length());
            newFileNamePath = prefix.getNewPrefix() + newFileNamePath;
            File newFile = new File(newFileNamePath);
            if (!newFile.exists()) continue;
            return newFileNamePath;
        }
        this.fileChooser.setDialogTitle("Choose current location of: " + filenamepath);
        GUIUtil.removeChoosableFileFilters((JFileChooser)this.fileChooser);
        this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        String ext = "";
        int k = filenamepath.lastIndexOf(46);
        if (k > 0 && k < filenamepath.length() - 1) {
            ext = filenamepath.substring(k + 1);
            FileFilter fileFilter = GUIUtil.createFileFilter((String)(ext.toUpperCase() + " Files"), (String[])new String[]{ext.toLowerCase()});
            this.fileChooser.addChoosableFileFilter(fileFilter);
            this.fileChooser.setFileFilter(fileFilter);
        }
        if (0 == this.fileChooser.showOpenDialog(this.window)) {
            String newParent = this.fileChooser.getSelectedFile().getParent() + File.separator;
            String oldParent = new File(filenamepath).getParent() + File.separator;
            int i = newParent.length();
            int j = oldParent.length();
            while (newParent.substring(i).equalsIgnoreCase(oldParent.substring(j))) {
                --i;
                --j;
            }
            while (newParent.charAt(i) != File.separatorChar) {
                ++i;
            }
            while (oldParent.charAt(j) != File.separatorChar) {
                ++j;
            }
            String newPrefix = newParent.substring(0, ++i);
            String oldPrefix = oldParent.substring(0, ++j);
            PathPrefixes pathPrefix = new PathPrefixes(oldPrefix, newPrefix);
            this.prefixList.add(pathPrefix);
            return this.fileChooser.getSelectedFile().getPath();
        }
        return "";
    }
}

