/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.attributeoperations;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.List;
import org.math.array.DoubleArray;
import org.math.array.StatisticSample;

public class AttributeOp {
    public static final int MAJORITY = 0;
    public static final int MINORITY = 1;
    public static final int MEAN = 2;
    public static final int MEDIAN = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int STD = 6;
    public static final int SUM = 7;
    public static final int COUNT = 8;

    public static String getName(int attributeOP) {
        String retval = "";
        if (attributeOP == 0) {
            retval = "major";
        } else if (attributeOP == 1) {
            retval = "minor";
        } else if (attributeOP == 2) {
            retval = "mean";
        } else if (attributeOP == 3) {
            retval = "median";
        } else if (attributeOP == 4) {
            retval = "min";
        } else if (attributeOP == 5) {
            retval = "max";
        } else if (attributeOP == 6) {
            retval = "std";
        } else if (attributeOP == 7) {
            retval = "sum";
        } else if (attributeOP == 8) {
            retval = "count";
        }
        return retval;
    }

    public static double evaluateAttributes(int attributeOp, Feature[] features, String attributeName) {
        ArrayList<Feature> featureL = new ArrayList<Feature>();
        for (int i = 0; i < features.length; ++i) {
            featureL.add(features[i]);
        }
        return AttributeOp.evaluateAttributes(attributeOp, featureL, attributeName);
    }

    public static double evaluateAttributes(int attributeOp, List features, String attributeName) {
        double result = Double.NaN;
        if (features.size() > 0) {
            Feature firstF = (Feature)features.get(0);
            FeatureSchema fs = firstF.getSchema();
            if (fs.hasAttribute(attributeName)) {
                boolean doEval = true;
                AttributeType at = fs.getAttributeType(attributeName);
                int n = features.size();
                double[] vals = StatisticSample.fill((int)n, (double)0.0);
                int count = 0;
                for (Feature f : features) {
                    Number val;
                    if (at == AttributeType.DOUBLE) {
                        val = (Double)f.getAttribute(attributeName);
                        vals[count] = (Double)val;
                    } else if (at == AttributeType.INTEGER) {
                        val = (Integer)f.getAttribute(attributeName);
                        vals[count] = ((Integer)val).doubleValue();
                    } else if (at == AttributeType.GEOMETRY) {
                        Geometry geom = (Geometry)f.getAttribute(attributeName);
                        vals[count] = geom != null ? 1.0 : 0.0;
                    } else {
                        System.out.println("AttributeOp: attribute type not supported");
                        doEval = false;
                    }
                    ++count;
                }
                if (doEval) {
                    if (attributeOp == 0) {
                        result = AttributeOp.majorityEval(vals);
                    } else if (attributeOp == 1) {
                        result = AttributeOp.minorityEval(vals);
                    } else if (attributeOp == 5) {
                        result = DoubleArray.max((double[])vals);
                    } else if (attributeOp == 4) {
                        result = DoubleArray.min((double[])vals);
                    } else if (attributeOp == 2) {
                        result = StatisticSample.mean((double[])vals);
                    } else if (attributeOp == 6) {
                        result = StatisticSample.stddeviation((double[])vals);
                    } else if (attributeOp == 3) {
                        double[] sortvals = DoubleArray.sort((double[])vals);
                        int index = (int)Math.ceil((double)vals.length / 2.0);
                        result = vals[index - 1];
                    } else if (attributeOp == 7) {
                        result = DoubleArray.sum((double[])vals);
                    } else if (attributeOp == 8) {
                        result = vals.length;
                    } else {
                        System.out.println("AttributeOp: attribute operation not supported");
                    }
                }
            } else {
                System.out.println("AttributeOp: attribute does not exist");
            }
        } else if (attributeOp == 8) {
            result = 0.0;
        }
        return result;
    }

    private static double majorityEval(double[] values) {
        int i;
        Double d;
        double result = 0.0;
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int i2 = 0; i2 < values.length; ++i2) {
            double val = values[i2];
            if (i2 == 0) {
                vals.add(new Double(val));
                continue;
            }
            boolean stop = false;
            int count = 0;
            boolean found = false;
            while (!stop) {
                d = (Double)vals.get(count);
                if (val == d) {
                    stop = true;
                    found = true;
                }
                if (++count != vals.size()) continue;
                stop = true;
            }
            if (found) continue;
            vals.add(new Double(val));
        }
        int[] countVals = new int[vals.size()];
        for (i = 0; i < countVals.length; ++i) {
            countVals[i] = 0;
        }
        for (i = 0; i < values.length; ++i) {
            double val = values[i];
            boolean stop = false;
            int count = 0;
            while (!stop) {
                d = (Double)vals.get(count);
                if (val == d) {
                    int oldVal = countVals[count];
                    countVals[count] = oldVal + 1;
                    stop = true;
                }
                if (++count != countVals.length) continue;
                stop = true;
            }
        }
        int maxcount = 0;
        int pos = 0;
        for (int i3 = 0; i3 < countVals.length; ++i3) {
            if (countVals[i3] <= maxcount) continue;
            maxcount = countVals[i3];
            pos = i3;
        }
        result = (Double)vals.get(pos);
        return result;
    }

    private static double minorityEval(double[] values) {
        int i;
        Double d;
        double result = 0.0;
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int i2 = 0; i2 < values.length; ++i2) {
            double val = values[i2];
            if (i2 == 0) {
                vals.add(new Double(val));
                continue;
            }
            boolean stop = false;
            int count = 0;
            boolean found = false;
            while (!stop) {
                d = (Double)vals.get(count);
                if (val == d) {
                    stop = true;
                    found = true;
                }
                if (++count != vals.size()) continue;
                stop = true;
            }
            if (found) continue;
            vals.add(new Double(val));
        }
        int[] countVals = new int[vals.size()];
        for (i = 0; i < countVals.length; ++i) {
            countVals[i] = 0;
        }
        for (i = 0; i < values.length; ++i) {
            double val = values[i];
            boolean stop = false;
            int count = 0;
            while (!stop) {
                d = (Double)vals.get(count);
                if (val == d) {
                    int oldVal = countVals[count];
                    countVals[count] = oldVal + 1;
                    stop = true;
                }
                if (++count != countVals.length) continue;
                stop = true;
            }
        }
        int mincount = countVals[0];
        int pos = 0;
        for (int i3 = 1; i3 < countVals.length; ++i3) {
            if (countVals[i3] >= mincount) continue;
            mincount = countVals[i3];
            pos = i3;
        }
        result = (Double)vals.get(pos);
        return result;
    }
}

