/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.workbench.ui.plugin.wms.URLWizardPanel;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.WMService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Capabilities {
    private MapLayer topLayer;
    private String title;
    private ArrayList mapFormats;
    private WMService service;
    private String getMapURL;
    private String getFeatureInfoURL;

    public Capabilities(WMService service, String title, MapLayer topLayer, Collection mapFormats) {
        this.service = service;
        this.title = title;
        this.topLayer = topLayer;
        this.mapFormats = new ArrayList(mapFormats);
        this.getMapURL = service.getServerUrl();
        this.getFeatureInfoURL = service.getServerUrl();
    }

    public Capabilities(WMService service, String title, MapLayer topLayer, Collection mapFormats, String getMapURL, String getFeatureInfoURL) {
        this(service, title, topLayer, mapFormats);
        this.getMapURL = URLWizardPanel.fixUrlForWMService((String)getMapURL);
        this.getFeatureInfoURL = URLWizardPanel.fixUrlForWMService((String)getFeatureInfoURL);
    }

    public WMService getService() {
        return this.service;
    }

    public MapLayer getTopLayer() {
        return this.topLayer;
    }

    public String getTitle() {
        return this.title;
    }

    public String getGetMapURL() {
        return this.getMapURL;
    }

    public String getGetFeatureInfoURL() {
        return this.getFeatureInfoURL;
    }

    public void setGetMapURL(String url) {
        this.getMapURL = url;
    }

    public String[] getMapFormats() {
        String[] formats = new String[this.mapFormats.size()];
        Iterator it = this.mapFormats.iterator();
        int i = 0;
        while (it.hasNext()) {
            formats[i++] = (String)it.next();
        }
        return formats;
    }
}

