/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.qa.diff.DiffGeometryIndex;
import com.vividsolutions.jump.qa.diff.DiffGeometryMatcher;
import com.vividsolutions.jump.qa.diff.ExactGeometryMatcher;
import com.vividsolutions.jump.qa.diff.NormalizedExactGeometryMatcher;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.Collection;
import java.util.Iterator;

public class DiffGeometry {
    private FeatureCollection[] inputFC = new FeatureCollection[2];
    private TaskMonitor monitor;
    private DiffGeometryMatcher diffMatcher = new ExactGeometryMatcher();
    private boolean splitIntoComponents = false;

    public DiffGeometry(FeatureCollection fc0, FeatureCollection fc1, TaskMonitor monitor) {
        this.inputFC[0] = fc0;
        this.inputFC[1] = fc1;
        this.monitor = monitor;
    }

    public void setNormalize(boolean normalizeGeometry) {
        this.diffMatcher = new NormalizedExactGeometryMatcher();
    }

    public void setSplitIntoComponents(boolean splitIntoComponents) {
        this.splitIntoComponents = splitIntoComponents;
    }

    public void setMatcher(DiffGeometryMatcher diffMatcher) {
        this.diffMatcher = diffMatcher;
    }

    public FeatureCollection[] diff() {
        return this.compute(this.inputFC[0], this.inputFC[1]);
    }

    private FeatureCollection[] compute(FeatureCollection fc0, FeatureCollection fc1) {
        DiffGeometryIndex diffIndex = new DiffGeometryIndex(fc1, this.diffMatcher, this.splitIntoComponents);
        this.monitor.report(I18N.get("com.vividsolutions.jump.qa.diff.DiffGeometry.Matching-features"));
        FeatureCollection[] diffFC = new FeatureCollection[]{this.matchFeatures(fc0, diffIndex), new FeatureDataset(fc1.getFeatureSchema())};
        diffFC[1].addAll(diffIndex.getUnmatchedFeatures());
        return diffFC;
    }

    private FeatureCollection matchFeatures(FeatureCollection fc0, DiffGeometryIndex diffIndex) {
        FeatureDataset noMatch = new FeatureDataset(fc0.getFeatureSchema());
        int count = 1;
        int totalItems = fc0.size();
        Iterator i = fc0.iterator();
        while (i.hasNext()) {
            this.monitor.report(count++, totalItems, I18N.get("com.vividsolutions.jump.qa.diff.DiffGeometry.features"));
            Feature f = (Feature)i.next();
            Geometry geom = f.getGeometry();
            Collection list = DiffGeometryIndex.splitGeometry(geom, this.splitIntoComponents);
            for (Geometry g : list) {
                if (diffIndex.hasMatch(g)) continue;
                noMatch.add(f);
            }
        }
        return noMatch;
    }
}

