/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.wizard;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;

public class AbstractWizardPanel
extends JPanel
implements WizardPanel {
    private Set<InputChangedListener> listeners = new LinkedHashSet<InputChangedListener>();
    private String id;
    private String nextId;
    private String instructions;
    private String title;
    private Map data;

    public AbstractWizardPanel() {
        this.id = this.getClass().getName();
        this.title = I18N.get((String)this.id);
        this.instructions = I18N.get((String)(this.id + ".instructions"));
    }

    public AbstractWizardPanel(String id, String title, String instructions) {
        this.id = id;
        this.title = title;
        this.instructions = instructions;
    }

    public AbstractWizardPanel(String id, String nextId, String title, String instructions) {
        this.id = id;
        this.nextId = nextId;
        this.title = title;
        this.instructions = instructions;
    }

    public void add(InputChangedListener listener) {
        this.listeners.add(listener);
    }

    public void remove(InputChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireInputChanged() {
        for (InputChangedListener listener : this.listeners) {
            listener.inputChanged();
        }
    }

    public void enteredFromLeft(Map data) {
        this.data = data;
    }

    public Map getData() {
        return this.data;
    }

    public void exitingToRight() throws Exception {
    }

    public String getID() {
        return this.id;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public String getNextID() {
        return this.nextId;
    }

    protected void setNextID(String nextId) {
        this.nextId = nextId;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isInputValid() {
        return true;
    }
}

