/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.GeometryPredicate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SpatialQueryExecuter {
    private FeatureCollection maskFC;
    private FeatureCollection sourceFC;
    private FeatureCollection queryFC;
    private boolean complementResult = false;
    private boolean allowDuplicatesInResult = false;
    private boolean isExceptionThrown = false;
    private Geometry[] geoms = new Geometry[2];
    private Set resultSet = new HashSet();
    private boolean createNewLayer = true;

    public SpatialQueryExecuter(FeatureCollection maskFC, FeatureCollection sourceFC) {
        this.maskFC = maskFC;
        this.sourceFC = sourceFC;
    }

    public void setAllowDuplicates(boolean isAllowDuplicates) {
        this.allowDuplicatesInResult = isAllowDuplicates;
    }

    public void setComplementResult(boolean complementResult) {
        this.complementResult = complementResult;
    }

    private void createQueryFeatureCollection(GeometryPredicate pred) {
        boolean buildIndex = false;
        if (this.maskFC.size() > 10) {
            buildIndex = true;
        }
        if (this.sourceFC.size() > 100) {
            buildIndex = true;
        }
        if (pred instanceof GeometryPredicate.DisjointPredicate) {
            buildIndex = false;
        }
        this.queryFC = buildIndex ? new IndexedFeatureCollection(this.sourceFC) : this.sourceFC;
    }

    private Iterator query(GeometryPredicate pred, double[] params, Geometry gMask) {
        Envelope queryEnv = gMask.getEnvelopeInternal();
        if (pred instanceof GeometryPredicate.WithinDistancePredicate) {
            queryEnv.expandBy(params[0]);
        }
        boolean useQuery = true;
        if (pred instanceof GeometryPredicate.DisjointPredicate) {
            useQuery = false;
        }
        Iterator queryIt = null;
        if (useQuery) {
            List queryResult = this.queryFC.query(queryEnv);
            queryIt = queryResult.iterator();
        } else {
            queryIt = this.queryFC.iterator();
        }
        return queryIt;
    }

    public boolean isExceptionThrown() {
        return this.isExceptionThrown;
    }

    public FeatureCollection getResultFC() {
        return new FeatureDataset(this.sourceFC.getFeatureSchema());
    }

    private boolean isInResult(Feature f) {
        return this.resultSet.contains(f);
    }

    public void execute(TaskMonitor monitor, GeometryPredicate func, double[] params, FeatureCollection resultFC) {
        this.createQueryFeatureCollection(func);
        int total = this.maskFC.size();
        int count = 0;
        Iterator iMask = this.maskFC.iterator();
        while (iMask.hasNext()) {
            monitor.report(count++, total, GenericNames.FEATURES);
            if (monitor.isCancelRequested()) {
                return;
            }
            Feature fMask = (Feature)iMask.next();
            Geometry gMask = fMask.getGeometry();
            Iterator queryIt = this.query(func, params, gMask);
            while (queryIt.hasNext()) {
                Geometry gSrc;
                Feature fSrc = (Feature)queryIt.next();
                if (this.isInResult(fSrc)) continue;
                this.geoms[0] = gSrc = fSrc.getGeometry();
                this.geoms[1] = gMask;
                boolean isInResult = this.isTrue(func, gSrc, gMask, params);
                if (!isInResult) continue;
                if (this.allowDuplicatesInResult) {
                    this.addToResult(fSrc, resultFC);
                    continue;
                }
                this.resultSet.add(fSrc);
            }
        }
        if (!this.allowDuplicatesInResult) {
            if (this.complementResult) {
                this.loadComplement(resultFC);
            } else {
                this.loadResult(resultFC);
            }
        }
    }

    private void loadComplement(FeatureCollection resultFC) {
        for (Feature f : this.sourceFC) {
            if (this.resultSet.contains(f)) continue;
            this.addToResult(f, resultFC);
        }
    }

    private void loadResult(FeatureCollection resultFC) {
        for (Feature f : this.resultSet) {
            this.addToResult(f, resultFC);
        }
    }

    private void addToResult(Feature f, FeatureCollection resultFC) {
        if (this.createNewLayer) {
            Feature fResult = f.clone(true);
            resultFC.add(fResult);
        } else {
            resultFC.add(f);
        }
    }

    private boolean isTrue(GeometryPredicate func, Geometry geom0, Geometry geom1, double[] params) {
        try {
            return func.isTrue(geom0, geom1, params);
        }
        catch (RuntimeException ex) {
            this.isExceptionThrown = true;
            return false;
        }
    }

    public void setCreateNewLayer(boolean argCreateNewLayer) {
        this.createNewLayer = argCreateNewLayer;
    }

    public boolean getCreateNewLayer() {
        return this.createNewLayer;
    }
}

