/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;

public class CalculateAreasAndLengthsPlugIn
extends AbstractPlugIn {
    private String LAYER_COMBO_BOX = I18N.get((String)"ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.layer");
    private String AREA_COMBO_BOX = I18N.get((String)"ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.area-attribute-name");
    private String LENGTH_COMBO_BOX = I18N.get((String)"ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.length-attribute-name");
    private String LENGTH_CHECK_BOX = I18N.get((String)"ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.calculate-length");
    private String AREA_CHECK_BOX = I18N.get((String)"ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.calculate-area");
    private Map typeToConverterMap = new HashMap(){
        {
            this.put(AttributeType.STRING, new Converter(){

                public Object convert(double d) {
                    return "" + d;
                }
            });
            this.put(AttributeType.INTEGER, new Converter(){

                public Object convert(double d) {
                    return new Integer((int)d);
                }
            });
            this.put(AttributeType.DOUBLE, new Converter(){

                public Object convert(double d) {
                    return new Double(d);
                }
            });
        }
    };

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS, MenuNames.ONELAYER}, this.getName() + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.LAYER_COMBO_BOX = I18N.get((String)"ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.layer");
        this.AREA_COMBO_BOX = I18N.get((String)"ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.area-attribute-name");
        this.LENGTH_COMBO_BOX = I18N.get((String)"ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.length-attribute-name");
        this.LENGTH_CHECK_BOX = I18N.get((String)"ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.calculate-length");
        this.AREA_CHECK_BOX = I18N.get((String)"ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.calculate-area");
        MultiInputDialog dialog = this.prompt(context);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        if (dialog.getBoolean(this.AREA_CHECK_BOX)) {
            this.updateAreas(dialog.getLayer(this.LAYER_COMBO_BOX), dialog.getText(this.AREA_COMBO_BOX));
        }
        if (dialog.getBoolean(this.LENGTH_CHECK_BOX)) {
            this.updateLengths(dialog.getLayer(this.LAYER_COMBO_BOX), dialog.getText(this.LENGTH_COMBO_BOX));
        }
        context.getLayerManager().fireFeaturesChanged(dialog.getLayer(this.LAYER_COMBO_BOX).getFeatureCollectionWrapper().getFeatures(), FeatureEventType.ATTRIBUTES_MODIFIED, dialog.getLayer(this.LAYER_COMBO_BOX));
        return true;
    }

    private MultiInputDialog prompt(PlugInContext context) {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        dialog.addEditableLayerComboBox(this.LAYER_COMBO_BOX, null, null, context.getLayerManager());
        this.initFields(dialog, this.AREA_CHECK_BOX, this.AREA_COMBO_BOX, 0);
        this.initFields(dialog, this.LENGTH_CHECK_BOX, this.LENGTH_COMBO_BOX, 1);
        this.initEnableChecks(dialog);
        this.loadValues(dialog, context);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            this.saveValues(dialog, context);
        }
        return dialog;
    }

    private void saveValues(MultiInputDialog dialog, PlugInContext context) {
        Blackboard blackboard = context.getLayerManager().getBlackboard();
        blackboard.put(this.namespace() + this.LAYER_COMBO_BOX, (Object)dialog.getLayer(this.LAYER_COMBO_BOX));
        blackboard.put(this.namespace() + this.AREA_CHECK_BOX, dialog.getCheckBox(this.AREA_CHECK_BOX).isSelected());
        blackboard.put(this.namespace() + this.LENGTH_CHECK_BOX, dialog.getCheckBox(this.LENGTH_CHECK_BOX).isSelected());
        blackboard.put(this.namespace() + this.AREA_COMBO_BOX, dialog.getComboBox(this.AREA_COMBO_BOX).getSelectedItem());
        blackboard.put(this.namespace() + this.LENGTH_COMBO_BOX, dialog.getComboBox(this.LENGTH_COMBO_BOX).getSelectedItem());
    }

    private void loadValues(MultiInputDialog dialog, PlugInContext context) {
        Blackboard blackboard = context.getLayerManager().getBlackboard();
        dialog.getComboBox(this.LAYER_COMBO_BOX).setSelectedItem(CollectionUtil.ifNotIn((Object)blackboard.get(this.namespace() + this.LAYER_COMBO_BOX), (Collection)GUIUtil.items(dialog.getComboBox(this.LAYER_COMBO_BOX)), (Object)this.candidateLayer(context)));
        GUIUtil.setSelectedWithClick(dialog.getCheckBox(this.AREA_CHECK_BOX), blackboard.get(this.namespace() + this.AREA_CHECK_BOX, true));
        GUIUtil.setSelectedWithClick(dialog.getCheckBox(this.LENGTH_CHECK_BOX), blackboard.get(this.namespace() + this.LENGTH_CHECK_BOX, true));
        dialog.getComboBox(this.AREA_COMBO_BOX).setSelectedItem(CollectionUtil.ifNotIn((Object)blackboard.get(this.namespace() + this.AREA_COMBO_BOX), (Collection)GUIUtil.items(dialog.getComboBox(this.AREA_COMBO_BOX)), (Object)dialog.getComboBox(this.AREA_COMBO_BOX).getSelectedItem()));
        dialog.getComboBox(this.LENGTH_COMBO_BOX).setSelectedItem(CollectionUtil.ifNotIn((Object)blackboard.get(this.namespace() + this.LENGTH_COMBO_BOX), (Collection)GUIUtil.items(dialog.getComboBox(this.LENGTH_COMBO_BOX)), (Object)dialog.getComboBox(this.LENGTH_COMBO_BOX).getSelectedItem()));
    }

    private String namespace() {
        return this.getClass().getName() + " - ";
    }

    private void initEnableChecks(final MultiInputDialog dialog) {
        dialog.addEnableChecks(this.LENGTH_COMBO_BOX, Arrays.asList(new EnableCheck(){

            public String check(JComponent component) {
                return dialog.getBoolean(CalculateAreasAndLengthsPlugIn.this.AREA_CHECK_BOX) && dialog.getBoolean(CalculateAreasAndLengthsPlugIn.this.LENGTH_CHECK_BOX) && dialog.getText(CalculateAreasAndLengthsPlugIn.this.AREA_COMBO_BOX).equals(dialog.getText(CalculateAreasAndLengthsPlugIn.this.LENGTH_COMBO_BOX)) ? I18N.get((String)"ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.area-and-length-attribute-names-must-be-different") : null;
            }
        }));
    }

    private String attributeName(List attributeNames, int preferredIndex) {
        return (String)attributeNames.get(attributeNames.size() > preferredIndex ? preferredIndex : 0);
    }

    private void initFields(final MultiInputDialog dialog, final String checkBoxFieldName, final String comboBoxFieldName, final int preferredCandidateAttributeIndex) {
        dialog.addCheckBox(checkBoxFieldName, true);
        dialog.addComboBox(comboBoxFieldName, null, new ArrayList(), null);
        dialog.getComboBox(this.LAYER_COMBO_BOX).addActionListener(new ActionListener(){
            private Layer lastLayer = null;

            public void actionPerformed(ActionEvent e) {
                Layer newLayer = (Layer)dialog.getComboBox(CalculateAreasAndLengthsPlugIn.this.LAYER_COMBO_BOX).getSelectedItem();
                if (this.lastLayer == newLayer) {
                    return;
                }
                this.lastLayer = newLayer;
                dialog.getComboBox(comboBoxFieldName).setModel(new DefaultComboBoxModel(new Vector(CalculateAreasAndLengthsPlugIn.this.candidateAttributeNames(newLayer))));
                if (!CalculateAreasAndLengthsPlugIn.this.candidateAttributeNames(newLayer).isEmpty()) {
                    dialog.getComboBox(comboBoxFieldName).setSelectedItem(CalculateAreasAndLengthsPlugIn.this.attributeName(CalculateAreasAndLengthsPlugIn.this.candidateAttributeNames(newLayer), preferredCandidateAttributeIndex));
                }
            }
        });
        dialog.getCheckBox(checkBoxFieldName).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.getComboBox(comboBoxFieldName).setEnabled(dialog.getCheckBox(checkBoxFieldName).isSelected());
                dialog.getLabel(comboBoxFieldName).setEnabled(dialog.getCheckBox(checkBoxFieldName).isSelected());
            }
        });
        dialog.addEnableChecks(comboBoxFieldName, Arrays.asList(new EnableCheck(){

            public String check(JComponent component) {
                return dialog.getBoolean(checkBoxFieldName) && dialog.getComboBox(comboBoxFieldName).getItemCount() == 0 ? "Layer has no string, integer, or double attributes" : null;
            }
        }));
        dialog.indentLabel(comboBoxFieldName);
    }

    private Layer candidateLayer(PlugInContext context) {
        if (context.getActiveInternalFrame() instanceof LayerNamePanelProxy) {
            Layer[] selectedLayers = context.getSelectedLayers();
            for (int i = 0; i < selectedLayers.length; ++i) {
                if (!selectedLayers[i].isEditable()) continue;
                return selectedLayers[i];
            }
        }
        return (Layer)context.getLayerManager().getEditableLayers().iterator().next();
    }

    private List candidateAttributeNames(Layer layer) {
        ArrayList<String> candidateAttributeNames = new ArrayList<String>();
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (!this.typeToConverterMap.keySet().contains(schema.getAttributeType(i))) continue;
            candidateAttributeNames.add(schema.getAttributeName(i));
        }
        return candidateAttributeNames;
    }

    private void updateLengths(Layer layer, String attributeName) {
        this.update(layer, attributeName, new Op(){

            public double compute(Geometry g) {
                return g.getLength();
            }
        });
    }

    private void update(Layer layer, String attributeName, Op op) {
        int attributeIndex = layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeIndex(attributeName);
        AttributeType attributeType = layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeType(attributeIndex);
        for (Feature feature : layer.getFeatureCollectionWrapper().getFeatures()) {
            feature.setAttribute(attributeIndex, this.convert(op.compute(feature.getGeometry()), attributeType));
        }
    }

    private Object convert(double d, AttributeType attributeType) {
        return ((Converter)this.typeToConverterMap.get(attributeType)).convert(d);
    }

    private void updateAreas(Layer layer, String attributeName) {
        this.update(layer, attributeName, new Op(){

            public double compute(Geometry g) {
                return g.getArea();
            }
        });
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createAtLeastNLayersMustBeEditableCheck(1));
    }

    private static interface Op {
        public double compute(Geometry var1);
    }

    private static interface Converter {
        public Object convert(double var1);
    }
}

