/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FlexibleDateParser;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AttributePredicate {
    static AttributePredicate[] method = new AttributePredicate[]{new EqualPredicate(), new NotEqualPredicate(), new LessThanPredicate(), new LessThanOrEqualPredicate(), new GreaterThanPredicate(), new GreaterThanOrEqualPredicate(), new ContainsPredicate(), new StartsWithPredicate()};
    private static FlexibleDateParser dateParser = new FlexibleDateParser();
    private String name;
    private String description;
    protected static final int NOT_COMPARABLE = Integer.MIN_VALUE;

    static List getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < method.length; ++i) {
            names.add(AttributePredicate.method[i].name);
        }
        return names;
    }

    static AttributePredicate getPredicate(String name) {
        for (int i = 0; i < method.length; ++i) {
            if (!AttributePredicate.method[i].name.equals(name)) continue;
            return method[i];
        }
        return null;
    }

    public AttributePredicate(String name) {
        this(name, null);
    }

    public AttributePredicate(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isTrue(Object var1, Object var2);

    protected boolean compareObjects(Object arg1, Object arg2) {
        Object o2 = AttributePredicate.coerce((String)arg2, arg1);
        if (o2 == null) {
            return false;
        }
        int comp = AttributePredicate.compareTo(arg1, o2);
        if (comp == Integer.MIN_VALUE) {
            return false;
        }
        return this.testCompareValue(comp);
    }

    protected boolean testCompareValue(int comp) {
        return false;
    }

    public static Object coerce(String constantValue, Object attrVal) {
        try {
            if (attrVal instanceof Boolean) {
                return new Boolean(AttributePredicate.getBooleanLoose(constantValue));
            }
            if (attrVal instanceof Double) {
                return new Double(constantValue);
            }
            if (attrVal instanceof Integer) {
                return new Integer(constantValue);
            }
            if (attrVal instanceof String) {
                return constantValue;
            }
            if (attrVal instanceof Date) {
                return dateParser.parse(constantValue, true);
            }
        }
        catch (ParseException ex) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    protected static int compareTo(Object o1, Object o2) {
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return ((Boolean)o1).equals(o2) ? 0 : 1;
        }
        if (!(o1 instanceof Comparable)) {
            return Integer.MIN_VALUE;
        }
        if (!(o2 instanceof Comparable)) {
            return Integer.MIN_VALUE;
        }
        return ((Comparable)o1).compareTo((Comparable)o2);
    }

    private static boolean getBooleanLoose(String boolStr) {
        return boolStr.equalsIgnoreCase("true") || boolStr.equalsIgnoreCase("yes") || boolStr.equalsIgnoreCase("1") || boolStr.equalsIgnoreCase("y");
    }

    private static class StartsWithPredicate
    extends AttributePredicate {
        public StartsWithPredicate() {
            super(I18N.get((String)"ui.plugin.analysis.AttributePredicate.starts-with"));
        }

        public boolean isTrue(Object arg1, Object arg2) {
            return arg1.toString().startsWith(arg2.toString());
        }
    }

    private static class ContainsPredicate
    extends AttributePredicate {
        public ContainsPredicate() {
            super(GenericNames.CONTAINS);
        }

        public boolean isTrue(Object arg1, Object arg2) {
            return arg1.toString().indexOf(arg2.toString()) >= 0;
        }
    }

    private static class GreaterThanOrEqualPredicate
    extends AttributePredicate {
        public GreaterThanOrEqualPredicate() {
            super(">=");
        }

        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        protected boolean testCompareValue(int comp) {
            return comp >= 0;
        }
    }

    private static class GreaterThanPredicate
    extends AttributePredicate {
        public GreaterThanPredicate() {
            super(">");
        }

        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        protected boolean testCompareValue(int comp) {
            return comp > 0;
        }
    }

    private static class LessThanOrEqualPredicate
    extends AttributePredicate {
        public LessThanOrEqualPredicate() {
            super("<=");
        }

        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        protected boolean testCompareValue(int comp) {
            return comp <= 0;
        }
    }

    private static class LessThanPredicate
    extends AttributePredicate {
        public LessThanPredicate() {
            super("<");
        }

        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        protected boolean testCompareValue(int comp) {
            return comp < 0;
        }
    }

    private static class NotEqualPredicate
    extends AttributePredicate {
        public NotEqualPredicate() {
            super("<>");
        }

        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        protected boolean testCompareValue(int comp) {
            return comp != 0;
        }
    }

    private static class EqualPredicate
    extends AttributePredicate {
        public EqualPredicate() {
            super("=");
        }

        public boolean isTrue(Object arg1, Object arg2) {
            return this.compareObjects(arg1, arg2);
        }

        protected boolean testCompareValue(int comp) {
            return comp == 0;
        }
    }
}

