/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;

public class FeatureStatisticsPlugIn
extends AbstractPlugIn {
    public static final String nPtsAttr = "nPts";
    public static final String nHolesAttr = "nHoles";
    public static final String nCompsAttr = "nComponents";
    public static final String areaAttr = "area";
    public static final String lengthAttr = "length";
    public static final String typeAttr = "type";
    private static final String jtsGeometryClassPackagePrefix = "com.vividsolutions.jts.geom";

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS}, this.getName() + "...", false, null, FeatureStatisticsPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    public static FeatureSchema getStatisticsSchema() {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featureSchema.addAttribute(nPtsAttr, AttributeType.INTEGER);
        featureSchema.addAttribute(nHolesAttr, AttributeType.INTEGER);
        featureSchema.addAttribute(nCompsAttr, AttributeType.INTEGER);
        featureSchema.addAttribute(areaAttr, AttributeType.DOUBLE);
        featureSchema.addAttribute(lengthAttr, AttributeType.DOUBLE);
        featureSchema.addAttribute(typeAttr, AttributeType.STRING);
        return featureSchema;
    }

    public static String removeGeometryPackage(String fullClassName) {
        if (fullClassName.startsWith(jtsGeometryClassPackagePrefix)) {
            return StringUtil.classNameWithoutQualifiers((String)fullClassName);
        }
        return fullClassName;
    }

    public boolean execute(PlugInContext context) throws Exception {
        Layer[] selectedLayers = context.getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            this.featureStatistics(selectedLayers[i], context);
        }
        return true;
    }

    private void featureStatistics(Layer layer, PlugInContext context) {
        FeatureSchema statsSchema = FeatureStatisticsPlugIn.getStatisticsSchema();
        FeatureDataset statsFC = new FeatureDataset(statsSchema);
        for (Feature f : layer.getFeatureCollectionWrapper()) {
            Geometry g = f.getGeometry();
            double area = g.getArea();
            double length = g.getLength();
            int comps = 1;
            if (g instanceof GeometryCollection) {
                comps = ((GeometryCollection)g).getNumGeometries();
            }
            Coordinate[] pts = g.getCoordinates();
            int holes = 0;
            if (g instanceof Polygon) {
                holes = ((Polygon)g).getNumInteriorRing();
            }
            BasicFeature statsf = new BasicFeature(statsSchema);
            statsf.setAttribute("GEOMETRY", (Object)g);
            statsf.setAttribute(nPtsAttr, (Object)new Integer(pts.length));
            statsf.setAttribute(nHolesAttr, (Object)new Integer(holes));
            statsf.setAttribute(nCompsAttr, (Object)new Integer(comps));
            statsf.setAttribute(areaAttr, (Object)new Double(area));
            statsf.setAttribute(lengthAttr, (Object)new Double(length));
            statsf.setAttribute(typeAttr, (Object)FeatureStatisticsPlugIn.removeGeometryPackage(g.getClass().getName()));
            statsFC.add((Feature)statsf);
        }
        Layer statsLayer = context.addLayer(StandardCategoryNames.QA, "Statistics-" + layer.getName(), (FeatureCollection)statsFC);
        statsLayer.setStyles(layer.cloneStyles());
    }
}

