/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import com.vividsolutions.jump.workbench.ui.snap.SnapToFeaturesPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToGridPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToVerticesPolicy;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class AbstractCursorTool
implements CursorTool {
    private static Logger LOG = Logger.getLogger(AbstractCursorTool.class);
    private boolean snappingConfigured = false;
    private boolean configuringSnapping = false;
    private boolean controlPressed;
    private boolean shiftPressed;
    private Color color = Color.red;
    private boolean filling = false;
    private Shape lastShapeDrawn;
    private LayerViewPanelListener layerViewPanelListener = new LayerViewPanelListener(){

        public void cursorPositionChanged(String x, String y) {
        }

        public void selectionChanged() {
        }

        public void fenceChanged() {
        }

        public void painted(Graphics graphics) {
            try {
                if (AbstractCursorTool.this.shapeOnScreen) {
                    AbstractCursorTool.this.setShapeOnScreen(false);
                    AbstractCursorTool.this.redrawShape((Graphics2D)graphics);
                }
            }
            catch (Throwable t) {
                AbstractCursorTool.this.panel.getContext().handleThrowable(t);
            }
        }
    };
    private Color originalColor;
    private Stroke originalStroke;
    private LayerViewPanel panel;
    private boolean shapeOnScreen = false;
    private SnapManager snapManager = new SnapManager();
    private Stroke stroke = new BasicStroke(1.0f);
    private ArrayList listeners = new ArrayList();
    private Cursor cursor;

    public void allowSnapping() {
        this.configuringSnapping = true;
    }

    protected boolean wasShiftPressed() {
        return this.shiftPressed;
    }

    protected boolean wasControlPressed() {
        return this.controlPressed;
    }

    public static Cursor createCursor(Image image) {
        return AbstractCursorTool.createCursor(image, new Point(16, 16));
    }

    public static Cursor createCursor(Image image, Point hotSpot) {
        return GUIUtil.createCursor(image, hotSpot);
    }

    public Cursor getCursor() {
        if (this.cursor == null) {
            this.cursor = this.getIcon() instanceof ImageIcon ? GUIUtil.createCursorFromIcon(((ImageIcon)this.getIcon()).getImage()) : Cursor.getDefaultCursor();
        }
        return this.cursor;
    }

    public boolean isGestureInProgress() {
        return this.isShapeOnScreen();
    }

    public boolean isRightMouseButtonUsed() {
        return false;
    }

    public boolean isShapeOnScreen() {
        return this.shapeOnScreen;
    }

    public void activate(LayerViewPanel layerViewPanel) {
        if (AbstractCursorTool.workbenchFrame(layerViewPanel) != null) {
            AbstractCursorTool.workbenchFrame(layerViewPanel).log(I18N.get((String)"ui.cursortool.AbstractCursorTool.activating") + " " + this.getName());
        }
        if (this.panel != null) {
            this.panel.removeListener(this.layerViewPanelListener);
        }
        this.panel = layerViewPanel;
        this.panel.addListener(this.layerViewPanelListener);
        if (this.configuringSnapping && !this.snappingConfigured) {
            this.getSnapManager().addPolicies(AbstractCursorTool.createStandardSnappingPolicies(PersistentBlackboardPlugIn.get(this.getWorkbench().getContext())));
            this.snappingConfigured = true;
        }
    }

    public static WorkbenchFrame workbenchFrame(LayerViewPanel layerViewPanel) {
        Window window = SwingUtilities.windowForComponent(layerViewPanel);
        return window instanceof WorkbenchFrame ? (WorkbenchFrame)window : null;
    }

    public static List createStandardSnappingPolicies(Blackboard blackboard) {
        return Arrays.asList(new SnapToVerticesPolicy(blackboard), new SnapToFeaturesPolicy(blackboard), new SnapToGridPolicy(blackboard));
    }

    protected boolean isRollingBackInvalidEdits() {
        return this.getWorkbench().getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false);
    }

    public void deactivate() {
        this.cancelGesture();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.controlPressed = e.isControlDown();
        this.shiftPressed = e.isShiftDown();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void setColor(Color color) {
        this.color = color;
    }

    protected void setFilling(boolean filling) {
        this.filling = filling;
    }

    protected void setStrokeWidth(int strokeWidth) {
        this.setStroke(new BasicStroke(strokeWidth));
    }

    protected void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    protected void setup(Graphics2D graphics) {
        this.originalColor = graphics.getColor();
        this.originalStroke = graphics.getStroke();
        graphics.setColor(this.color);
        graphics.setXORMode(Color.white);
        graphics.setStroke(this.stroke);
    }

    protected LayerViewPanel getPanel() {
        return this.panel;
    }

    protected abstract Shape getShape() throws Exception;

    protected void cleanup(Graphics2D graphics) {
        graphics.setPaintMode();
        graphics.setColor(this.originalColor);
        graphics.setStroke(this.originalStroke);
    }

    protected void clearShape() {
        this.clearShape(this.getGraphics2D());
    }

    private Graphics2D getGraphics2D() {
        Graphics2D g = (Graphics2D)this.panel.getGraphics();
        if (g != null) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return g;
    }

    public void cancelGesture() {
        this.clearShape();
    }

    protected void drawShapeXOR(Graphics2D g) throws Exception {
        Shape newShape = this.getShape();
        this.drawShapeXOR(newShape, g);
        this.lastShapeDrawn = newShape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawShapeXOR(Shape shape, Graphics2D graphics) {
        this.setup(graphics);
        try {
            if (shape != null) {
                if (this.filling) {
                    graphics.fill(shape);
                } else {
                    graphics.draw(shape);
                }
            }
        }
        finally {
            this.cleanup(graphics);
        }
    }

    protected void redrawShape() throws Exception {
        this.redrawShape(this.getGraphics2D());
    }

    protected Coordinate snap(Point2D viewPoint) throws NoninvertibleTransformException {
        return this.snap(this.getPanel().getViewport().toModelCoordinate(viewPoint));
    }

    protected Coordinate snap(Coordinate modelCoordinate) {
        return this.snapManager.snap(this.getPanel(), modelCoordinate);
    }

    private void setShapeOnScreen(boolean shapeOnScreen) {
        this.shapeOnScreen = shapeOnScreen;
    }

    private void clearShape(Graphics2D graphics) {
        if (!this.shapeOnScreen) {
            return;
        }
        this.drawShapeXOR(this.lastShapeDrawn, graphics);
        this.setShapeOnScreen(false);
    }

    private void redrawShape(Graphics2D graphics) throws Exception {
        this.clearShape(graphics);
        this.drawShapeXOR(graphics);
        this.setShapeOnScreen(true);
    }

    protected TaskFrame getTaskFrame() {
        return (TaskFrame)SwingUtilities.getAncestorOfClass(TaskFrame.class, this.getPanel());
    }

    public JUMPWorkbench getWorkbench() {
        return AbstractCursorTool.workbench(this.getPanel());
    }

    public static JUMPWorkbench workbench(LayerViewPanel panel) {
        return ((WorkbenchFrame)SwingUtilities.getAncestorOfClass(WorkbenchFrame.class, panel)).getContext().getWorkbench();
    }

    protected abstract void gestureFinished() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireGestureFinished() throws Exception {
        WorkbenchFrame workbenchFrame;
        this.getPanel().getContext().setStatusMessage("");
        if (this.getTaskFrame() != null && (workbenchFrame = (WorkbenchFrame)SwingUtilities.getAncestorOfClass(WorkbenchFrame.class, this.getTaskFrame())) != null) {
            workbenchFrame.log(I18N.get((String)"ui.cursortool.AbstractCursorTool.gesture-finished") + ": " + this.getName());
        }
        this.getPanel().getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            this.gestureFinished();
        }
        finally {
            this.getPanel().getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
        for (Listener listener : this.listeners) {
            listener.gestureFinished();
        }
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    protected void execute(UndoableCommand command) {
        AbstractPlugIn.execute(command, this.getPanel());
    }

    protected void reportNothingToUndoYet() {
        this.getPanel().getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return AbstractCursorTool.name(this);
    }

    public static String name(CursorTool tool) {
        try {
            return I18N.get((String)tool.getClass().getName());
        }
        catch (MissingResourceException e) {
            LOG.error((Object)(e.getMessage() + " " + tool.getClass().getName()));
            return StringUtil.toFriendlyName((String)tool.getClass().getName(), (String)I18N.get((String)"ui.cursortool.AbstractCursorTool.tool"));
        }
    }

    protected boolean check(EnableCheck check) {
        String warning = check.check(null);
        if (warning != null) {
            this.getPanel().getContext().warnUser(warning);
            return false;
        }
        return true;
    }

    public SnapManager getSnapManager() {
        return this.snapManager;
    }

    public Color getColor() {
        return this.color;
    }

    public static interface Listener {
        public void gestureFinished();
    }
}

