/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class GUIUtil {
    public static final String dbf = "dbf";
    public static final String dbfDesc = "DBF";
    public static final String fme = "fme";
    public static final String fmeDesc = "FME GML";
    public static final String gml = "gml";
    public static final String gmlDesc = "GML";
    public static final String jml = "jml";
    public static final String jmlDesc = "JCS GML";
    public static final String shp = "shp";
    public static final String shpDesc = "ESRI Shapefile";
    public static final String shx = "shx";
    public static final String shxDesc = "SHX";
    public static final String wkt = "wkt";
    public static final String wktDesc = "Well Known Text";
    public static final String wktaDesc = "Well Known Text (Show Attribute)";
    public static final String xml = "xml";
    public static final String xmlDesc = "XML";
    public static final FileFilter ALL_FILES_FILTER = new FileFilter(){

        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return "All Files";
        }
    };

    public static final String escapeHTML(String value, boolean escapeSpaces, boolean escapeNewlines) {
        if (value == null) {
            return null;
        }
        char[] content = new char[value.length()];
        value.getChars(0, value.length(), content, 0);
        StringBuffer result = new StringBuffer();
        block36: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case ' ': {
                    result.append(escapeSpaces ? "&#32;" : " ");
                    continue block36;
                }
                case '\n': {
                    result.append(escapeNewlines ? "<BR>" : "\n");
                    continue block36;
                }
                case '!': {
                    result.append("&#33;");
                    continue block36;
                }
                case '\"': {
                    result.append("&#34;");
                    continue block36;
                }
                case '#': {
                    result.append("&#35;");
                    continue block36;
                }
                case '$': {
                    result.append("&#36;");
                    continue block36;
                }
                case '%': {
                    result.append("&#37;");
                    continue block36;
                }
                case '&': {
                    result.append("&#38;");
                    continue block36;
                }
                case '\'': {
                    result.append("&#39;");
                    continue block36;
                }
                case '(': {
                    result.append("&#40;");
                    continue block36;
                }
                case ')': {
                    result.append("&#41;");
                    continue block36;
                }
                case '*': {
                    result.append("&#42;");
                    continue block36;
                }
                case '+': {
                    result.append("&#43;");
                    continue block36;
                }
                case ',': {
                    result.append("&#44;");
                    continue block36;
                }
                case '-': {
                    result.append("&#45;");
                    continue block36;
                }
                case '.': {
                    result.append("&#46;");
                    continue block36;
                }
                case '/': {
                    result.append("&#47;");
                    continue block36;
                }
                case ':': {
                    result.append("&#58;");
                    continue block36;
                }
                case ';': {
                    result.append("&#59;");
                    continue block36;
                }
                case '<': {
                    result.append("&#60;");
                    continue block36;
                }
                case '=': {
                    result.append("&#61;");
                    continue block36;
                }
                case '>': {
                    result.append("&#62;");
                    continue block36;
                }
                case '?': {
                    result.append("&#63;");
                    continue block36;
                }
                case '@': {
                    result.append("&#64;");
                    continue block36;
                }
                case '[': {
                    result.append("&#91;");
                    continue block36;
                }
                case '\\': {
                    result.append("&#92;");
                    continue block36;
                }
                case ']': {
                    result.append("&#93;");
                    continue block36;
                }
                case '^': {
                    result.append("&#94;");
                    continue block36;
                }
                case '_': {
                    result.append("&#95;");
                    continue block36;
                }
                case '`': {
                    result.append("&#96;");
                    continue block36;
                }
                case '{': {
                    result.append("&#123;");
                    continue block36;
                }
                case '|': {
                    result.append("&#124;");
                    continue block36;
                }
                case '}': {
                    result.append("&#125;");
                    continue block36;
                }
                case '~': {
                    result.append("&#126;");
                    continue block36;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String getExtension(File f) {
        return FileUtil.getExtension((File)f);
    }

    public static Color alphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static void centre(Component componentToMove, Component componentToCentreOn) {
        Dimension componentToCentreOnSize = componentToCentreOn.getSize();
        componentToMove.setLocation(componentToCentreOn.getX() + (componentToCentreOnSize.width - componentToMove.getWidth()) / 2, componentToCentreOn.getY() + (componentToCentreOnSize.height - componentToMove.getHeight()) / 2);
    }

    public static void centreOnScreen(Component componentToMove) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        componentToMove.setLocation((screenSize.width - componentToMove.getWidth()) / 2, (screenSize.height - componentToMove.getHeight()) / 2);
    }

    public static void centreOnWindow(Component componentToMove) {
        GUIUtil.centre(componentToMove, SwingUtilities.windowForComponent(componentToMove));
    }

    public static void chooseGoodColumnWidths(JTable table) {
        int PADDING = 5;
        if (table.getModel().getRowCount() == 0) {
            return;
        }
        for (int i = 0; i < table.getModel().getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            double headerWidth = table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, table.getModel().getColumnName(i), false, false, 0, i).getPreferredSize().getWidth() + 5.0;
            double valueWidth = 10.0;
            try {
                valueWidth = table.getCellRenderer(0, i).getTableCellRendererComponent(table, table.getModel().getValueAt(0, i), false, false, 0, i).getPreferredSize().getWidth() + 5.0;
            }
            catch (Exception ex) {
                // empty catch block
            }
            int width = Math.min(200, Math.max((int)headerWidth, (int)valueWidth));
            column.setPreferredWidth(width);
            column.setWidth(width);
        }
    }

    public static JFileChooser createJFileChooserWithExistenceChecking() {
        return new JFileChooser(){

            public void approveSelection() {
                File[] files = GUIUtil.selectedFiles(this);
                if (files.length == 0) {
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].exists() || files[i].isFile()) continue;
                    return;
                }
                super.approveSelection();
            }
        };
    }

    public static JFileChooser createJFileChooserWithOverwritePrompting() {
        return new FileChooserWithOverwritePrompting();
    }

    public static JFileChooser createJFileChooserWithOverwritePrompting(String ext) {
        return new FileChooserWithOverwritePrompting(ext);
    }

    public static void doNotRoundDoubles(JTable table) {
        table.setDefaultRenderer(Double.class, new DefaultTableCellRenderer(){
            {
                this.setHorizontalAlignment(4);
            }

            public void setValue(Object value) {
                this.setText(value == null ? "" : "" + value);
            }
        });
    }

    public static void fixEditableComboBox(JComboBox cb) {
        Assert.isTrue((boolean)cb.isEditable());
        if (!UIManager.getLookAndFeel().getName().equals("Windows")) {
            return;
        }
        cb.setEditor(new BasicComboBoxEditor(){

            public void setItem(Object item) {
                super.setItem(item);
                this.editor.selectAll();
            }
        });
    }

    public static void handleThrowable(final Throwable t, final Component parent) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    t.printStackTrace(System.out);
                    JOptionPane.showMessageDialog(parent, StringUtil.split((String)t.toString(), (int)80), "Exception", 0);
                }
            });
        }
        catch (Throwable t2) {
            t2.printStackTrace(System.out);
        }
    }

    public static void invokeOnEventThread(Runnable r) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeAndWait(r);
        }
    }

    public static String nameWithoutExtension(File file) {
        String name = file.getName();
        int dotPosition = name.indexOf(46);
        return dotPosition < 0 ? name : name.substring(0, dotPosition);
    }

    public static void removeChoosableFileFilters(JFileChooser fc) {
        FileFilter[] filters = fc.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            fc.removeChoosableFileFilter(filters[i]);
        }
    }

    public static FileFilter createFileFilter(final String description, final String[] extensions) {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < extensions.length; ++i) {
                    if (!GUIUtil.getExtension(f).equalsIgnoreCase(extensions[i])) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                ArrayList<String> extensionStrings = new ArrayList<String>();
                for (int i = 0; i < extensions.length; ++i) {
                    extensionStrings.add("*." + extensions[i]);
                }
                return description + " (" + StringUtil.replaceAll((String)StringUtil.toCommaDelimitedString(extensionStrings), (String)",", (String)";") + ")";
            }
        };
    }

    public static Color toSimulatedTransparency(Color color) {
        return new Color(color.getRed() + (int)((double)((255 - color.getRed()) * (255 - color.getAlpha())) / 255.0), color.getGreen() + (int)((double)((255 - color.getGreen()) * (255 - color.getAlpha())) / 255.0), color.getBlue() + (int)((double)((255 - color.getBlue()) * (255 - color.getAlpha())) / 255.0));
    }

    public static String truncateString(String s, int maxLength) {
        if (s.length() < maxLength) {
            return s;
        }
        return s.substring(0, maxLength - 3) + "...";
    }

    public static Point2D subtract(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public static Point2D add(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static Point2D multiply(Point2D v, double x) {
        return new Point2D.Double(v.getX() * x, v.getY() * x);
    }

    public static Transferable getContents(Clipboard clipboard) {
        try {
            return clipboard.getContents(null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static double trueAscent(TextLayout layout) {
        return -layout.getBounds().getY();
    }

    public static ImageIcon resize(ImageIcon icon, int extent) {
        return new ImageIcon(icon.getImage().getScaledInstance(extent, extent, 4));
    }

    public static ImageIcon toSmallIcon(ImageIcon icon) {
        return GUIUtil.resize(icon, 16);
    }

    public static int swingThreadPriority() {
        final Int i = new Int();
        try {
            GUIUtil.invokeOnEventThread(new Runnable(){

                public void run() {
                    i.i = Thread.currentThread().getPriority();
                }
            });
        }
        catch (InvocationTargetException e) {
            Assert.shouldNeverReachHere();
        }
        catch (InterruptedException e) {
            Assert.shouldNeverReachHere();
        }
        return i.i;
    }

    public static void fixClicks(final Component c) {
        c.addMouseListener(new MouseListener(){
            private ArrayList events = new ArrayList();

            public void mousePressed(MouseEvent e) {
                this.add(e);
            }

            public void mouseExited(MouseEvent e) {
                this.add(e);
            }

            public void mouseClicked(MouseEvent e) {
                this.add(e);
            }

            public void mouseEntered(MouseEvent e) {
                this.add(e);
            }

            private MouseEvent event(int i) {
                return (MouseEvent)this.events.get(i);
            }

            public void mouseReleased(MouseEvent e) {
                this.add(e);
                if (this.events.size() == 4 && this.event(0).getID() == 501 && this.event(1).getID() == 505 && this.event(2).getID() == 504) {
                    c.dispatchEvent(new MouseEvent(c, 500, System.currentTimeMillis(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger()));
                }
            }

            private void add(MouseEvent e) {
                if (this.events.size() == 4) {
                    this.events.remove(0);
                }
                this.events.add(e);
            }
        });
    }

    public static void addInternalFrameListener(JDesktopPane pane, final InternalFrameListener listener) {
        JInternalFrame[] frames = pane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            frames[i].addInternalFrameListener(listener);
        }
        pane.addContainerListener(new ContainerAdapter(){

            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof JInternalFrame) {
                    ((JInternalFrame)e.getChild()).removeInternalFrameListener(listener);
                    ((JInternalFrame)e.getChild()).addInternalFrameListener(listener);
                }
            }
        });
    }

    public static DocumentListener toDocumentListener(final ActionListener listener) {
        return new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                listener.actionPerformed(new ActionEvent(e, 0, e.toString()));
            }

            public void removeUpdate(DocumentEvent e) {
                listener.actionPerformed(new ActionEvent(e, 0, e.toString()));
            }

            public void changedUpdate(DocumentEvent e) {
                listener.actionPerformed(new ActionEvent(e, 0, e.toString()));
            }
        };
    }

    public static ListDataListener toListDataListener(final ActionListener listener) {
        return new ListDataListener(){

            public void intervalAdded(ListDataEvent e) {
                listener.actionPerformed(new ActionEvent(e.getSource(), 0, e.toString()));
            }

            public void intervalRemoved(ListDataEvent e) {
                listener.actionPerformed(new ActionEvent(e.getSource(), 0, e.toString()));
            }

            public void contentsChanged(ListDataEvent e) {
                listener.actionPerformed(null);
            }
        };
    }

    public static InternalFrameListener toInternalFrameListener(final ActionListener listener) {
        return new InternalFrameListener(){

            private void fireActionPerformed(InternalFrameEvent e) {
                listener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.toString()));
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            public void internalFrameClosed(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            public void internalFrameClosing(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            public void internalFrameDeiconified(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            public void internalFrameIconified(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            public void internalFrameOpened(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }
        };
    }

    public static Timer createRestartableSingleEventTimer(int delay, ActionListener listener) {
        Timer timer = new Timer(delay, listener);
        timer.setCoalesce(true);
        timer.setInitialDelay(delay);
        timer.setRepeats(false);
        return timer;
    }

    public static ValidatingTextField createSyncdTextField(JSlider s) {
        int columns = (int)Math.ceil(Math.log(s.getMaximum()) / Math.log(10.0));
        return GUIUtil.createSyncdTextField(s, columns);
    }

    public static ValidatingTextField createSyncdTextField(JSlider s, int columns) {
        ValidatingTextField t = new ValidatingTextField(s.getValue() + "", columns, 4, ValidatingTextField.INTEGER_VALIDATOR, new ValidatingTextField.CompositeCleaner(new ValidatingTextField.Cleaner[]{new ValidatingTextField.BlankCleaner("" + s.getMinimum()), new ValidatingTextField.MinIntCleaner(s.getMinimum()), new ValidatingTextField.MaxIntCleaner(s.getMaximum())}));
        GUIUtil.sync(s, t);
        GUIUtil.syncEnabledStates(s, t);
        return t;
    }

    public static void sync(final JSlider s, final ValidatingTextField t) {
        t.setText("" + s.getValue());
        final Boolean[] changing = new Boolean[]{Boolean.FALSE};
        s.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    t.setText("" + s.getValue());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
        t.getDocument().addDocumentListener(new DocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void changed() {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    s.setValue(t.getInteger());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }

            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }
        });
    }

    public static void syncEnabledStates(final JComponent c1, final JComponent c2) {
        c2.setEnabled(c1.isEnabled());
        c1.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (c1.isEnabled() == c2.isEnabled()) {
                    return;
                }
                c2.setEnabled(c1.isEnabled());
            }
        });
        c2.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (c1.isEnabled() == c2.isEnabled()) {
                    return;
                }
                c1.setEnabled(c2.isEnabled());
            }
        });
    }

    public static void sync(final JSlider s1, final JSlider s2) {
        s2.setValue(s1.getValue());
        Assert.isTrue((s1.getMinimum() == s2.getMinimum() ? 1 : 0) != 0);
        Assert.isTrue((s1.getMaximum() == s2.getMaximum() ? 1 : 0) != 0);
        final Boolean[] changing = new Boolean[]{Boolean.FALSE};
        s1.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    s2.setValue(s1.getValue());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
        s2.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    s1.setValue(s2.getValue());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
    }

    public static void sync(final JCheckBox c1, final JCheckBox c2) {
        c2.setSelected(c1.isSelected());
        final Boolean[] changing = new Boolean[]{Boolean.FALSE};
        c1.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    c2.setSelected(c1.isSelected());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
        c2.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    c1.setSelected(c2.isSelected());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
    }

    public static List items(JComboBox comboBox) {
        ArrayList items = new ArrayList();
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            items.add(comboBox.getItemAt(i));
        }
        return items;
    }

    public static void setSelectedWithClick(JCheckBox checkBox, boolean selected) {
        checkBox.setSelected(!selected);
        checkBox.doClick();
    }

    public static void setLocation(Component componentToMove, Location location, Component other) {
        Point p = new Point((int)other.getLocationOnScreen().getX() + (location.fromRight ? other.getWidth() - componentToMove.getWidth() - location.x : location.x), (int)other.getLocationOnScreen().getY() + (location.fromBottom ? other.getHeight() - componentToMove.getHeight() - location.y : location.y));
        if (!(componentToMove instanceof Window)) {
            SwingUtilities.convertPointFromScreen(p, componentToMove.getParent());
        }
        componentToMove.setLocation(p);
    }

    public static void highlightForDebugging(JComponent component, Color color) {
        component.setBackground(color);
        component.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, color));
    }

    public static Component topCard(Container c) {
        Assert.isTrue((boolean)(c.getLayout() instanceof CardLayout));
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].isVisible()) continue;
            return components[i];
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public static File[] selectedFiles(JFileChooser chooser) {
        File[] fileArray;
        if (chooser.getSelectedFiles().length == 0 && chooser.getSelectedFile() != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = chooser.getSelectedFile();
        } else {
            fileArray = chooser.getSelectedFiles();
        }
        return fileArray;
    }

    public static ImageIcon toDisabledIcon(ImageIcon icon) {
        return new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
    }

    public static Component getDescendantOfClass(Class c, Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component descendant;
            if (c.isInstance(container.getComponent(i))) {
                return container.getComponent(i);
            }
            if (!(container.getComponent(i) instanceof Container) || (descendant = GUIUtil.getDescendantOfClass(c, (Container)container.getComponent(i))) == null) continue;
            return descendant;
        }
        return null;
    }

    public static void dispose(JInternalFrame internalFrame, JDesktopPane desktopPane) {
        desktopPane.getDesktopManager().closeFrame(internalFrame);
        internalFrame.dispose();
    }

    public static Cursor createCursorFromIcon(Image iconImage) {
        ImageIcon icon = new ImageIcon(iconImage.getScaledInstance(12, 12, 8));
        ImageIcon basicCursor = IconLoader.icon("basic-cursor.png");
        BufferedImage image = new BufferedImage(basicCursor.getIconWidth(), basicCursor.getIconHeight(), 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage(basicCursor.getImage(), 0, 0, null);
        graphics.drawImage(icon.getImage(), 10, 10, null);
        return GUIUtil.createCursor(image, new Point(0, 15));
    }

    public static Cursor createCursor(Image image, Point hotSpot) {
        if (null == image) {
            return Cursor.getDefaultCursor();
        }
        if (Toolkit.getDefaultToolkit().getBestCursorSize(32, 32).equals(new Dimension(0, 0))) {
            return Cursor.getDefaultCursor();
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(image, hotSpot, I18N.get((String)"ui.GUIUtil.jump-workbench-custom-cursor"));
    }

    public static JTextArea makeTabMoveFocus(JTextArea textArea) {
        textArea.setFocusTraversalKeys(0, new HashSet<Object>(Arrays.asList(KeyStroke.getKeyStroke("TAB"))));
        textArea.setFocusTraversalKeys(1, new HashSet<Object>(Arrays.asList(KeyStroke.getKeyStroke("shift TAB"))));
        return textArea;
    }

    public static void shrinkFont(JComponent component) {
        component.setFont(component.getFont().deriveFont((float)component.getFont().getSize() - 2.0f));
    }

    public static class Location {
        private int x;
        private int y;
        private boolean fromRight;
        private boolean fromBottom;

        public Location(int x, boolean fromRight, int y, boolean fromBottom) {
            this.x = x;
            this.y = y;
            this.fromRight = fromRight;
            this.fromBottom = fromBottom;
        }
    }

    private static class Int {
        public volatile int i;

        private Int() {
        }
    }

    public static class FileChooserWithOverwritePrompting
    extends JFileChooser {
        private String ext;

        public FileChooserWithOverwritePrompting(String ext) {
            this.ext = ext;
        }

        public FileChooserWithOverwritePrompting() {
        }

        public void approveSelection() {
            int response;
            if (GUIUtil.selectedFiles(this).length != 1) {
                return;
            }
            File selectedFile = this.selectedFile();
            if (selectedFile.exists() && !selectedFile.isFile()) {
                return;
            }
            if ((selectedFile.exists() || this.ext != null && !selectedFile.toString().endsWith(this.ext) && new File(selectedFile.toString() + "." + this.ext).exists()) && (response = JOptionPane.showConfirmDialog(this, "The file " + selectedFile.getName() + " already exists. Do you " + "want to replace the existing file?", "JUMP", 0)) != 0) {
                return;
            }
            super.approveSelection();
        }

        protected File selectedFile() {
            return GUIUtil.selectedFiles(this)[0];
        }
    }
}

