/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Task
implements LayerManagerProxy {
    private String name = "";
    private LayerManager layerManager;
    private List<NameListener> nameListeners = new ArrayList<NameListener>();
    private File projectFile = null;
    private Map<QName, Object> properties = new HashMap<QName, Object>();

    public Task() {
        this.layerManager = new LayerManager(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireNameChanged(name);
    }

    public void add(NameListener nameListener) {
        this.nameListeners.add(nameListener);
    }

    private void fireNameChanged(String name) {
        for (NameListener nameListener : this.nameListeners) {
            nameListener.taskNameChanged(name);
        }
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public Collection<Category> getCategories() {
        return this.getLayerManager().getCategories();
    }

    public void addCategory(Category category) {
        this.getLayerManager().addCategory(category.getName());
        Category actual = this.getLayerManager().getCategory(category.getName());
        for (Layerable layerable : category.getLayerables()) {
            actual.addPersistentLayerable(layerable);
        }
    }

    public void setProperty(QName name, Object value) {
        this.properties.put(name, value);
    }

    public <T> T getProperty(QName name) {
        return (T)this.properties.get(name);
    }

    public Map<QName, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<QName, Object> properties) {
        this.properties.putAll(properties);
    }

    public String toString() {
        return this.getName();
    }

    public static interface NameListener {
        public void taskNameChanged(String var1);
    }
}

