/*
 * Copyright 2003 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

import java.util.Date;

/**
 * The AppleEvent class is simply an object to be passed back to a
 * remote objct exported by an applet to verify proper object
 * serialization.
 */
public class AppleEvent implements java.io.Serializable {

    public static final int BUY   = 0;
    public static final int EAT   = 1;
    public static final int THROW = 2;

    private int what;

    private java.util.Date when;

    public AppleEvent(int what)
    {
        this.what = what;
        this.when = new Date();
    }

    public String toString()
    {
        String desc = "[";
        switch (what) {
        case BUY:
            desc += "BUY";
            break;
        case EAT:
            desc += "EAT";
            break;
        case THROW:
            desc += "THROW";
            break;
        }
        desc += " @ " + when + "]";
        return desc;
    }
}
