/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.InternalErrorHandler;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class SIPDate
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8544101899928346909L;
    public static final String GMT = "GMT";
    public static final String MON = "Mon";
    public static final String TUE = "Tue";
    public static final String WED = "Wed";
    public static final String THU = "Thu";
    public static final String FRI = "Fri";
    public static final String SAT = "Sat";
    public static final String SUN = "Sun";
    public static final String JAN = "Jan";
    public static final String FEB = "Feb";
    public static final String MAR = "Mar";
    public static final String APR = "Apr";
    public static final String MAY = "May";
    public static final String JUN = "Jun";
    public static final String JUL = "Jul";
    public static final String AUG = "Aug";
    public static final String SEP = "Sep";
    public static final String OCT = "Oct";
    public static final String NOV = "Nov";
    public static final String DEC = "Dec";
    protected String sipWkDay;
    protected String sipMonth;
    protected int wkday;
    protected int day;
    protected int month;
    protected int year;
    protected int hour;
    protected int minute;
    protected int second;
    private Calendar javaCal;

    public boolean equals(Object object) {
        if (object.getClass() != this.getClass()) {
            return false;
        }
        SIPDate sIPDate = (SIPDate)object;
        return this.wkday == sIPDate.wkday && this.day == sIPDate.day && this.month == sIPDate.month && this.year == sIPDate.year && this.hour == sIPDate.hour && this.minute == sIPDate.minute && this.second == sIPDate.second;
    }

    public SIPDate() {
        this.wkday = -1;
        this.day = -1;
        this.month = -1;
        this.year = -1;
        this.hour = -1;
        this.minute = -1;
        this.second = -1;
        this.javaCal = null;
    }

    public SIPDate(long l) {
        this.javaCal = new GregorianCalendar(TimeZone.getTimeZone("GMT:0"), Locale.getDefault());
        Date date = new Date(l);
        this.javaCal.setTime(date);
        this.wkday = this.javaCal.get(7);
        switch (this.wkday) {
            case 2: {
                this.sipWkDay = MON;
                break;
            }
            case 3: {
                this.sipWkDay = TUE;
                break;
            }
            case 4: {
                this.sipWkDay = WED;
                break;
            }
            case 5: {
                this.sipWkDay = THU;
                break;
            }
            case 6: {
                this.sipWkDay = FRI;
                break;
            }
            case 7: {
                this.sipWkDay = SAT;
                break;
            }
            case 1: {
                this.sipWkDay = SUN;
                break;
            }
            default: {
                InternalErrorHandler.handleException("No date map for wkday " + this.wkday);
            }
        }
        this.day = this.javaCal.get(5);
        this.month = this.javaCal.get(2);
        switch (this.month) {
            case 0: {
                this.sipMonth = JAN;
                break;
            }
            case 1: {
                this.sipMonth = FEB;
                break;
            }
            case 2: {
                this.sipMonth = MAR;
                break;
            }
            case 3: {
                this.sipMonth = APR;
                break;
            }
            case 4: {
                this.sipMonth = MAY;
                break;
            }
            case 5: {
                this.sipMonth = JUN;
                break;
            }
            case 6: {
                this.sipMonth = JUL;
                break;
            }
            case 7: {
                this.sipMonth = AUG;
                break;
            }
            case 8: {
                this.sipMonth = SEP;
                break;
            }
            case 9: {
                this.sipMonth = OCT;
                break;
            }
            case 10: {
                this.sipMonth = NOV;
                break;
            }
            case 11: {
                this.sipMonth = DEC;
                break;
            }
            default: {
                InternalErrorHandler.handleException("No date map for month " + this.month);
            }
        }
        this.year = this.javaCal.get(1);
        this.hour = this.javaCal.get(11);
        this.minute = this.javaCal.get(12);
        this.second = this.javaCal.get(13);
    }

    public String encode() {
        String string = this.day < 10 ? "0" + this.day : "" + this.day;
        String string2 = this.hour < 10 ? "0" + this.hour : "" + this.hour;
        String string3 = this.minute < 10 ? "0" + this.minute : "" + this.minute;
        String string4 = this.second < 10 ? "0" + this.second : "" + this.second;
        String string5 = "";
        if (this.sipWkDay != null) {
            string5 = string5 + this.sipWkDay + "," + " ";
        }
        string5 = string5 + string + " ";
        if (this.sipMonth != null) {
            string5 = string5 + this.sipMonth + " ";
        }
        string5 = string5 + this.year + " " + string2 + ":" + string3 + ":" + string4 + " " + GMT;
        return string5;
    }

    public Calendar getJavaCal() {
        if (this.javaCal == null) {
            this.setJavaCal();
        }
        return this.javaCal;
    }

    public String getWkday() {
        return this.sipWkDay;
    }

    public String getMonth() {
        return this.sipMonth;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    private void setJavaCal() {
        this.javaCal = new GregorianCalendar(TimeZone.getTimeZone("GMT:0"), Locale.getDefault());
        if (this.year != -1) {
            this.javaCal.set(1, this.year);
        }
        if (this.day != -1) {
            this.javaCal.set(5, this.day);
        }
        if (this.month != -1) {
            this.javaCal.set(2, this.month);
        }
        if (this.wkday != -1) {
            this.javaCal.set(7, this.wkday);
        }
        if (this.hour != -1) {
            this.javaCal.set(10, this.hour);
        }
        if (this.minute != -1) {
            this.javaCal.set(12, this.minute);
        }
        if (this.second != -1) {
            this.javaCal.set(13, this.second);
        }
    }

    public void setWkday(String string) throws IllegalArgumentException {
        this.sipWkDay = string;
        if (this.sipWkDay.compareToIgnoreCase(MON) == 0) {
            this.wkday = 2;
        } else if (this.sipWkDay.compareToIgnoreCase(TUE) == 0) {
            this.wkday = 3;
        } else if (this.sipWkDay.compareToIgnoreCase(WED) == 0) {
            this.wkday = 4;
        } else if (this.sipWkDay.compareToIgnoreCase(THU) == 0) {
            this.wkday = 5;
        } else if (this.sipWkDay.compareToIgnoreCase(FRI) == 0) {
            this.wkday = 6;
        } else if (this.sipWkDay.compareToIgnoreCase(SAT) == 0) {
            this.wkday = 7;
        } else if (this.sipWkDay.compareToIgnoreCase(SUN) == 0) {
            this.wkday = 1;
        } else {
            throw new IllegalArgumentException("Illegal Week day :" + string);
        }
    }

    public void setDay(int n) throws IllegalArgumentException {
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException("Illegal Day of the month " + new Integer(n).toString());
        }
        this.day = n;
    }

    public void setMonth(String string) throws IllegalArgumentException {
        this.sipMonth = string;
        if (this.sipMonth.compareToIgnoreCase(JAN) == 0) {
            this.month = 0;
        } else if (this.sipMonth.compareToIgnoreCase(FEB) == 0) {
            this.month = 1;
        } else if (this.sipMonth.compareToIgnoreCase(MAR) == 0) {
            this.month = 2;
        } else if (this.sipMonth.compareToIgnoreCase(APR) == 0) {
            this.month = 3;
        } else if (this.sipMonth.compareToIgnoreCase(MAY) == 0) {
            this.month = 4;
        } else if (this.sipMonth.compareToIgnoreCase(JUN) == 0) {
            this.month = 5;
        } else if (this.sipMonth.compareToIgnoreCase(JUL) == 0) {
            this.month = 6;
        } else if (this.sipMonth.compareToIgnoreCase(AUG) == 0) {
            this.month = 7;
        } else if (this.sipMonth.compareToIgnoreCase(SEP) == 0) {
            this.month = 8;
        } else if (this.sipMonth.compareToIgnoreCase(OCT) == 0) {
            this.month = 9;
        } else if (this.sipMonth.compareToIgnoreCase(NOV) == 0) {
            this.month = 10;
        } else if (this.sipMonth.compareToIgnoreCase(DEC) == 0) {
            this.month = 11;
        } else {
            throw new IllegalArgumentException("Illegal Month :" + string);
        }
    }

    public void setYear(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal year : " + n);
        }
        this.javaCal = null;
        this.year = n;
    }

    public int getYear() {
        return this.year;
    }

    public void setHour(int n) throws IllegalArgumentException {
        if (n < 0 || n > 24) {
            throw new IllegalArgumentException("Illegal hour : " + n);
        }
        this.javaCal = null;
        this.hour = n;
    }

    public void setMinute(int n) throws IllegalArgumentException {
        if (n < 0 || n >= 60) {
            throw new IllegalArgumentException("Illegal minute : " + new Integer(n).toString());
        }
        this.javaCal = null;
        this.minute = n;
    }

    public void setSecond(int n) throws IllegalArgumentException {
        if (n < 0 || n >= 60) {
            throw new IllegalArgumentException("Illegal second : " + new Integer(n).toString());
        }
        this.javaCal = null;
        this.second = n;
    }

    public int getDeltaSeconds() {
        long l = this.getJavaCal().getTime().getTime();
        return (int)(l - System.currentTimeMillis()) / 1000;
    }

    public Object clone() {
        SIPDate sIPDate;
        try {
            sIPDate = (SIPDate)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error");
        }
        if (this.javaCal != null) {
            sIPDate.javaCal = (Calendar)this.javaCal.clone();
        }
        return sIPDate;
    }
}

