/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import socks.Proxy;
import socks.ProxyMessage;
import socks.SocksException;

public class SocksSocket
extends Socket {
    protected Proxy proxy;
    protected String localHost;
    protected String remoteHost;
    protected InetAddress localIP;
    protected InetAddress remoteIP;
    protected int localPort;
    protected int remotePort;
    private Socket directSock = null;

    public SocksSocket(String host, int port) throws SocksException, UnknownHostException {
        this(Proxy.defaultProxy, host, port);
    }

    public SocksSocket(Proxy p, String host, int port) throws SocksException, UnknownHostException {
        if (p == null) {
            throw new SocksException(65536);
        }
        this.proxy = p.copy();
        this.remoteHost = host;
        this.remotePort = port;
        if (this.proxy.isDirect(host)) {
            this.remoteIP = InetAddress.getByName(host);
            this.doDirect();
        } else {
            this.processReply(this.proxy.connect(host, port));
        }
    }

    public SocksSocket(InetAddress ip, int port) throws SocksException {
        this(Proxy.defaultProxy, ip, port);
    }

    public SocksSocket(Proxy p, InetAddress ip, int port) throws SocksException {
        if (p == null) {
            throw new SocksException(65536);
        }
        this.proxy = p.copy();
        this.remoteIP = ip;
        this.remotePort = port;
        this.remoteHost = ip.getHostName();
        if (this.proxy.isDirect(this.remoteIP)) {
            this.doDirect();
        } else {
            this.processReply(this.proxy.connect(ip, port));
        }
    }

    protected SocksSocket(String host, int port, Proxy proxy) {
        this.remotePort = port;
        this.proxy = proxy;
        this.localIP = proxy.proxySocket.getLocalAddress();
        this.localPort = proxy.proxySocket.getLocalPort();
        this.remoteHost = host;
    }

    protected SocksSocket(InetAddress ip, int port, Proxy proxy) {
        this.remoteIP = ip;
        this.remotePort = port;
        this.proxy = proxy;
        this.localIP = proxy.proxySocket.getLocalAddress();
        this.localPort = proxy.proxySocket.getLocalPort();
        this.remoteHost = this.remoteIP.getHostName();
    }

    public SocketChannel getChannel() {
        return this.proxy.proxySocket.getChannel();
    }

    public void close() throws IOException {
        if (this.proxy != null) {
            this.proxy.endSession();
        }
        this.proxy = null;
    }

    public InputStream getInputStream() {
        return this.proxy.in;
    }

    public OutputStream getOutputStream() {
        return this.proxy.out;
    }

    public int getPort() {
        return this.remotePort;
    }

    public String getHost() {
        return this.remoteHost;
    }

    public InetAddress getInetAddress() {
        if (this.remoteIP == null) {
            try {
                this.remoteIP = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return this.remoteIP;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public InetAddress getLocalAddress() {
        if (this.localIP == null) {
            try {
                this.localIP = InetAddress.getByName(this.localHost);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return this.localIP;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setSoLinger(boolean on, int val) throws SocketException {
        this.proxy.proxySocket.setSoLinger(on, val);
    }

    public int getSoLinger(int timeout) throws SocketException {
        return this.proxy.proxySocket.getSoLinger();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.proxy.proxySocket.setSoTimeout(timeout);
    }

    public int getSoTimeout(int timeout) throws SocketException {
        return this.proxy.proxySocket.getSoTimeout();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.proxy.proxySocket.setTcpNoDelay(on);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.proxy.proxySocket.getTcpNoDelay();
    }

    public String toString() {
        if (this.directSock != null) {
            return "Direct connection:" + this.directSock;
        }
        return "Proxy:" + this.proxy + ";" + "addr:" + this.remoteHost + ",port:" + this.remotePort + ",localport:" + this.localPort;
    }

    private void processReply(ProxyMessage reply) throws SocksException {
        this.localPort = reply.port;
        if (reply.host.equals("0.0.0.0")) {
            this.localIP = this.proxy.proxyIP;
            this.localHost = this.localIP.getHostName();
        } else {
            this.localHost = reply.host;
            this.localIP = reply.ip;
        }
    }

    private void doDirect() throws SocksException {
        try {
            SocketChannel chan = SocketChannel.open();
            this.directSock = chan.socket();
            this.directSock.connect(new InetSocketAddress(this.remoteIP, this.remotePort));
            this.proxy.out = this.directSock.getOutputStream();
            this.proxy.in = this.directSock.getInputStream();
            this.proxy.proxySocket = this.directSock;
            this.localIP = this.directSock.getLocalAddress();
            this.localPort = this.directSock.getLocalPort();
        }
        catch (IOException io_ex) {
            throw new SocksException(458752, (Throwable)io_ex);
        }
    }
}

