/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.SubscriptionStateHeader;

public class SubscriptionState
extends ParametersHeader
implements SubscriptionStateHeader {
    private static final long serialVersionUID = -6673833053927258745L;
    protected int expires = -1;
    protected int retryAfter = -1;
    protected String reasonCode;
    protected String state;

    public SubscriptionState() {
        super("Subscription-State");
    }

    public void setExpires(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SubscriptionState, setExpires(), the expires parameter is  < 0");
        }
        this.expires = n;
    }

    public int getExpires() {
        return this.expires;
    }

    public void setRetryAfter(int n) throws InvalidArgumentException {
        if (n <= 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SubscriptionState, setRetryAfter(), the retryAfter parameter is <=0");
        }
        this.retryAfter = n;
    }

    public int getRetryAfter() {
        return this.retryAfter;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, SubscriptionState, setReasonCode(), the reasonCode parameter is null");
        }
        this.reasonCode = string;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, SubscriptionState, setState(), the state parameter is null");
        }
        this.state = string;
    }

    public String encodeBody() {
        return this.encodeBody(new StringBuffer()).toString();
    }

    protected StringBuffer encodeBody(StringBuffer stringBuffer) {
        if (this.state != null) {
            stringBuffer.append(this.state);
        }
        if (this.reasonCode != null) {
            stringBuffer.append(";reason=").append(this.reasonCode);
        }
        if (this.expires != -1) {
            stringBuffer.append(";expires=").append(this.expires);
        }
        if (this.retryAfter != -1) {
            stringBuffer.append(";retry-after=").append(this.retryAfter);
        }
        if (!this.parameters.isEmpty()) {
            stringBuffer.append(";");
            this.parameters.encode(stringBuffer);
        }
        return stringBuffer;
    }
}

