/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.LexerCore;
import gov.nist.core.ParserCore;
import java.text.ParseException;

public class HostNameParser
extends ParserCore {
    private static final char[] VALID_DOMAIN_LABEL_CHAR = new char[]{'\ufffd', '-', '.'};

    public HostNameParser(String string) {
        this.lexer = new LexerCore("charLexer", string);
    }

    public HostNameParser(LexerCore lexerCore) {
        this.lexer = lexerCore;
        lexerCore.selectLexer("charLexer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeDomainLabel() throws ParseException {
        this.lexer.consumeValidChars(VALID_DOMAIN_LABEL_CHAR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String ipv6Reference() throws ParseException {
        char c;
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = new StringBuffer();
            while (this.lexer.hasMoreChars()) {
                c = this.lexer.lookAhead(0);
                if (LexerCore.isHexDigit(c) || c == '.' || c == ':' || c == '[' || c == '%') {
                    this.lexer.consume(1);
                    stringBuffer.append(c);
                    continue;
                }
                break block4;
            }
            throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        }
        if (c != ']') throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        this.lexer.consume(1);
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host host() throws ParseException {
        String string;
        if (this.lexer.lookAhead(0) == '[') {
            string = this.ipv6Reference();
        } else {
            int n = this.lexer.getPtr();
            this.consumeDomainLabel();
            string = this.lexer.getBuffer().substring(n, this.lexer.getPtr());
        }
        if (string.length() == 0) {
            throw new ParseException(this.lexer.getBuffer() + ": Missing host name", this.lexer.getPtr());
        }
        Host host = new Host(string);
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostPort hostPort(boolean bl) throws ParseException {
        Host host = this.host();
        HostPort hostPort = new HostPort();
        hostPort.setHost(host);
        if (bl) {
            this.lexer.SPorHT();
        }
        if (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            switch (c) {
                case ':': {
                    this.lexer.consume(1);
                    if (bl) {
                        this.lexer.SPorHT();
                    }
                    try {
                        String string = this.lexer.number();
                        hostPort.setPort(Integer.parseInt(string));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException(this.lexer.getBuffer() + " :Error parsing port ", this.lexer.getPtr());
                    }
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '%': 
                case '/': 
                case ';': 
                case '>': 
                case '?': {
                    break;
                }
                default: {
                    if (bl) break;
                    throw new ParseException(this.lexer.getBuffer() + " Illegal character in hostname:" + this.lexer.lookAhead(0), this.lexer.getPtr());
                }
            }
        }
        HostPort hostPort2 = hostPort;
        return hostPort2;
    }

    public static void main(String[] stringArray) throws ParseException {
        String[] stringArray2 = new String[]{"foo.bar.com:1234", "proxima.chaplin.bt.co.uk", "129.6.55.181:2345", ":1234", "foo.bar.com:         1234", "foo.bar.com     :      1234   ", "MIK_S:1234"};
        for (int i = 0; i < stringArray2.length; ++i) {
            try {
                HostNameParser hostNameParser = new HostNameParser(stringArray2[i]);
                HostPort hostPort = hostNameParser.hostPort(true);
                System.out.println("[" + hostPort.encode() + "]");
                continue;
            }
            catch (ParseException parseException) {
                System.out.println("exception text = " + parseException.getMessage());
            }
        }
    }
}

