/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.base.SystemLogRecord;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.nio.Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class GetLogsRequest
implements ConsoleRequest {
    public int getType() {
        return 11;
    }

    public Object readResponse(DataInput in) throws IOException {
        LinkedList<SystemLogRecord> list = new LinkedList<SystemLogRecord>();
        String node = in.readUTF();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            SystemLogRecord systemLogRecord = new SystemLogRecord();
            systemLogRecord.readData(in);
            systemLogRecord.setNode(node);
            list.add(systemLogRecord);
        }
        return list;
    }

    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        List<SystemLogRecord> logBundle = mcs.getHazelcastInstance().node.getSystemLogService().getLogBundle();
        Address address = mcs.getHazelcastInstance().node.getThisAddress();
        dos.writeUTF(address.getHost() + ":" + address.getPort());
        dos.writeInt(logBundle.size());
        for (SystemLogRecord systemLogRecord : logBundle) {
            systemLogRecord.writeData(dos);
        }
    }

    public void writeData(DataOutput out) throws IOException {
    }

    public void readData(DataInput in) throws IOException {
    }
}

