/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import pl.mn.communicator.IGGConfiguration;
import pl.mn.communicator.packet.http.AbstractTokenRequest;
import pl.mn.communicator.packet.http.HttpResponse;

public class SendAndRemindPasswordRequest
extends AbstractTokenRequest {
    private int m_uin = -1;
    private String m_email = null;

    public SendAndRemindPasswordRequest(IGGConfiguration configuration, int uin, String email, String tokenID, String tokenVal) throws IOException {
        super(configuration, tokenID, tokenVal);
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (email == null) {
            throw new NullPointerException("email cannot be null");
        }
        this.m_uin = uin;
        this.m_email = email;
    }

    public HttpResponse getResponse() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_huc.getInputStream(), "windows-1250"));
        String line = reader.readLine();
        return new SendAndRemindPasswordResponse(line);
    }

    protected String getURL() {
        return this.m_ggconfiguration.getSendPasswordURL();
    }

    protected String getRequestBody() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("userid=");
        buffer.append(this.m_uin);
        buffer.append('&');
        buffer.append("email=");
        buffer.append(this.m_email);
        buffer.append('&');
        buffer.append("tokenid=");
        buffer.append(this.getTokenID());
        buffer.append('&');
        buffer.append("tokenval=");
        buffer.append(this.getTokenVal());
        buffer.append('&');
        buffer.append("code=");
        buffer.append(this.getHashCode(String.valueOf(this.m_uin)));
        return buffer.toString();
    }

    protected boolean wannaWrite() {
        return true;
    }

    private int getHashCode(String uin) {
        if (uin == null) {
            throw new NullPointerException("uin cannot be null");
        }
        int b = -1;
        for (int i = 0; i < uin.length(); ++i) {
            char c = uin.charAt(i);
            int a = (c ^ b) + (c << 8);
            b = a >>> 24 | a << 8;
        }
        return b < 0 ? -b : b;
    }

    public static class SendAndRemindPasswordResponse
    extends HttpResponse {
        private String m_responseString;

        public SendAndRemindPasswordResponse(String responseString) {
            this.m_responseString = responseString;
        }

        public boolean isOKResponse() {
            return this.m_responseString.equals("pwdsend_success");
        }

        public String getResponseMessage() {
            return this.m_responseString;
        }
    }
}

