#include "DcpMakerPanel.h"
#include <wx/filename.h>
#include <wx/file.h>

BEGIN_EVENT_TABLE(DcpMakerPanel, MainPanel)
	EVT_RADIOBUTTON(ID_RAD2D, DcpMakerPanel::On2D3DSelected)
	EVT_RADIOBUTTON(ID_RAD3D, DcpMakerPanel::On2D3DSelected)

    EVT_BUTTON(ID_BTNTIFFLEFT, DcpMakerPanel::OnBtnFolder)
	EVT_BUTTON(ID_BTNTIFFRIGHT, DcpMakerPanel::OnBtnFolder)

	EVT_BUTTON(ID_BTNLCHANNEL, DcpMakerPanel::OnBtnSoundFile)
	EVT_BUTTON(ID_BTNRCHANNEL, DcpMakerPanel::OnBtnSoundFile)
	EVT_BUTTON(ID_BTNCCHANNEL, DcpMakerPanel::OnBtnSoundFile)
	EVT_BUTTON(ID_BTNLFECHANNEL, DcpMakerPanel::OnBtnSoundFile)
	EVT_BUTTON(ID_BTNLSCHANNEL, DcpMakerPanel::OnBtnSoundFile)
	EVT_BUTTON(ID_BTNRSCHANNEL, DcpMakerPanel::OnBtnSoundFile)

	EVT_BUTTON(ID_BTNJ2KLEFT, DcpMakerPanel::OnBtnFolder)
	EVT_BUTTON(ID_BTNJ2KRIGHT, DcpMakerPanel::OnBtnFolder)

	EVT_BUTTON(ID_BTNVIDEOMXF, DcpMakerPanel::OnBtnMxfFile)
	EVT_BUTTON(ID_BTNSOUNDMXF, DcpMakerPanel::OnBtnMxfFile)

	EVT_BUTTON(ID_BTNMAKEDCP, DcpMakerPanel::OnMakeDcp)

	EVT_TIMER(wxID_ANY, DcpMakerPanel::OnTimer)
END_EVENT_TABLE()

DcpMakerPanel::DcpMakerPanel( wxWindow* parent )
	: MainPanel( parent ),  m_timer(this)
{
	m_processing = false;
#ifdef _DEBUG
	m_edtTiffLeft->SetValue(wxT("C:\\assets\\BigBuckBunny\\smalltiff"));
#endif
}

DcpMakerPanel::~DcpMakerPanel()
{
}

void DcpMakerPanel::On2D3DSelected( wxCommandEvent& event )
{
	bool is3d = false;
	if (event.GetId() == ID_RAD3D) is3d = true;
	m_lblTiffRight->Enable(is3d);
	m_edtTiffRight->Enable(is3d);
	m_btnTiffRight->Enable(is3d);
	m_lblJ2kRight->Enable(is3d);
	m_edtJ2kRight->Enable(is3d);
	m_btnJ2kRight->Enable(is3d);
}

void DcpMakerPanel::OnBtnSoundFile( wxCommandEvent& event )
{
	wxString path = wxEmptyString;
	wxString part;
	wxTextCtrl *txt;
	wxFileName newpath;
	wxString lastdir;

	switch(event.GetId()) {
		case ID_BTNLCHANNEL:
			if (m_edtLChannel->IsEmpty() && !m_edtTiffLeft->IsEmpty()) {
				newpath.AssignDir(m_edtTiffLeft->GetValue());
				newpath.RemoveLastDir();
				path = newpath.GetFullPath();
			}
			txt = m_edtLChannel;
			break;
		case ID_BTNRCHANNEL:
			txt = m_edtRChannel;
			break;
		case ID_BTNCCHANNEL:
			txt = m_edtCChannel;
			break;
		case ID_BTNLFECHANNEL:
			txt = m_edtLFEChannel;
			break;
		case ID_BTNLSCHANNEL:
			txt = m_edtLSChannel;
			break;
		case ID_BTNRSCHANNEL:
			txt = m_edtRSChannel;
			break;

	};

	if (!txt->IsEmpty()) path = txt->GetValue();
	wxFileDialog dlg(this, wxT("Select Sound File"), path, wxT(""), wxT("Wav Files (*.wav)|*.wav"), wxFD_OPEN);  

	if (dlg.ShowModal() == wxID_OK) {
		path = dlg.GetPath();
		txt->SetValue(path);
		if (event.GetId() == ID_BTNLCHANNEL) {
			part = path.Left(path.Len() - 5);
			m_edtRChannel->SetValue(part + wxT("R.wav"));
			m_edtCChannel->SetValue(part + wxT("C.wav"));
			m_edtLFEChannel->SetValue(part + wxT("LFE.wav"));
			m_edtLSChannel->SetValue(part + wxT("LS.wav"));
			m_edtRSChannel->SetValue(part + wxT("RS.wav"));

			if (!m_edtTiffLeft->IsEmpty()) {
				newpath.AssignDir(m_edtTiffLeft->GetValue());
				newpath.RemoveLastDir();
				lastdir = newpath.GetDirs().Last();
				newpath.AppendDir(wxT("dcp"));
				newpath.SetFullName(lastdir + wxT(".sound.mxf"));
				m_edtSoundMxf->SetValue(newpath.GetFullPath());
			}
		}
	}
}

void DcpMakerPanel::OnBtnFolder( wxCommandEvent& event )
{
	wxString originalpath = wxEmptyString;
	wxString path;
	wxString msg;
	wxDirDialog dlg(this, wxT(""), originalpath, wxDEFAULT_DIALOG_STYLE | wxRESIZE_BORDER | wxDD_DIR_MUST_EXIST);  
	wxTextCtrl *txt;
	wxFileName newpath;
	wxString lastdir;
	
	switch(event.GetId()) {
		case ID_BTNTIFFLEFT:
			msg = wxT("Select the directory containing the uncompressed files");
			if (m_rad3d->GetValue()) msg += wxT(" for the left eye");
			txt = m_edtTiffLeft;
			break;
		case ID_BTNTIFFRIGHT:
			msg = wxT("Select the directory containing the uncompressed files for the right eye");
			txt = m_edtTiffRight;
			if (txt->IsEmpty()) path = m_edtTiffLeft->GetValue();
			break;
		case ID_BTNJ2KLEFT:
			msg = wxT("Select the directory containing the JPEG 2000 files");
			if (m_rad3d->GetValue()) msg += wxT(" for the left eye");
			txt = m_edtJ2kLeft;
			break;
		case ID_BTNJ2KRIGHT:
			msg = wxT("Select the directory containing the JPEG 2000 files for the right eye");
			txt = m_edtJ2kRight;
			if (txt->IsEmpty()) path = m_edtTiffLeft->GetValue();
			break;
	};
	
	
	dlg.SetMessage(msg);
	if (!txt->IsEmpty()) path = txt->GetValue();
	dlg.SetPath(path);
	
	if (dlg.ShowModal() == wxID_OK) {
		path = dlg.GetPath();
		txt->SetValue(path);
	} else {
		return;
	}
	switch(event.GetId()) {
		case ID_BTNTIFFLEFT:
			newpath.AssignDir(m_edtTiffLeft->GetValue());
			newpath.RemoveLastDir();
			lastdir = newpath.GetDirs().Last();
			if (m_rad3d->GetValue()) {
				newpath.AppendDir(wxT("j2c_left"));
			} else {
				newpath.AppendDir(wxT("j2c"));
			}
			m_edtJ2kLeft->SetValue(newpath.GetFullPath());
			newpath.RemoveLastDir();
			newpath.AppendDir(wxT("dcp"));
			newpath.SetFullName(lastdir + wxT(".video.mxf"));
			m_edtVideoMxf->SetValue(newpath.GetFullPath());
			m_edtCpoTitle->SetValue(lastdir);
			m_edtCpoAnnotation->SetValue(lastdir);
			m_edtPklAnnotation->SetValue(lastdir);
			m_edtMapAnnotation->SetValue(lastdir);
			break;
		case ID_BTNTIFFRIGHT:
			newpath.AssignDir(m_edtTiffRight->GetValue());
			newpath.RemoveLastDir();
			newpath.AppendDir(wxT("j2c_right"));
			m_edtJ2kRight->SetValue(newpath.GetFullPath());
			break;
	};
	
}

void DcpMakerPanel::OnBtnMxfFile( wxCommandEvent& event )
{
	wxString path = wxEmptyString;
	wxString part;
	wxTextCtrl *txt;
	wxFileName newpath;
	wxString lastdir;

	switch(event.GetId()) {
		case ID_BTNVIDEOMXF:
			if (m_edtVideoMxf->IsEmpty() && !m_edtTiffLeft->IsEmpty()) {
				newpath.AssignDir(m_edtTiffLeft->GetValue());
				newpath.RemoveLastDir();
				path = newpath.GetFullPath();
			}
			txt = m_edtVideoMxf;
			break;
		case ID_BTNSOUNDMXF:
			txt = m_edtSoundMxf;
			break;


	};

	if (!txt->IsEmpty()) path = txt->GetValue();
	wxFileDialog dlg(this, wxT("Select Mxf File"), path, wxT(""), wxT("MXF Files (*.mxf)|*.mxf"), wxFD_OPEN);  

	if (dlg.ShowModal() == wxID_OK) {
		path = dlg.GetPath();
		txt->SetValue(path);
	}
}

void DcpMakerPanel::OnMakeDcp( wxCommandEvent& event )
{
	wxFile f;
	wxDir dir, dir2;
	wxString filename, cpo, pkl;
	wxString cmd, cwd;
	wxFileName tmp;
	bool cont;

	if (m_edtVideoMxf->IsEmpty() || m_edtCpoTitle->IsEmpty()) {
		wxMessageBox(wxT("At least a video MXF file and a composition playlist are required.\nNothing will be processed."), wxT("Can't process..."),
                     wxOK | wxICON_EXCLAMATION);

		return;
	}

	f.Open(wxT("_makedcp.bat"), wxFile::write);
	if (!m_edtTiffLeft->IsEmpty() && !m_edtJ2kLeft->IsEmpty()) {
		cmd.Printf(wxT("mkdir \"%s\"\n"), m_edtJ2kLeft->GetValue().c_str());
		f.Write(cmd);
		dir.Open(m_edtTiffLeft->GetValue());
		cont = dir.GetFirst(&filename, wxT("*.tif"), wxDIR_FILES);
		
		while (cont) {
			cmd.Printf(wxT("image_to_j2k -cinema2K 24 -i \"%s\" -o \"%s\" -OutFor j2c\n"), 
						(m_edtTiffLeft->GetValue() + wxT("\\") + filename).c_str(), 
						(m_edtJ2kLeft->GetValue()  + wxT("\\") + filename.Left(filename.Len()-4) + wxT(".j2c")).c_str());
			f.Write(cmd);
			cont = dir.GetNext(&filename);
		}

	}
	//-----------------
	if (m_rad3d->GetValue() && !m_edtTiffRight->IsEmpty() && !m_edtJ2kRight->IsEmpty()) {
		cmd.Printf(wxT("mkdir \"%s\"\n"), m_edtJ2kRight->GetValue().c_str());
		f.Write(cmd);
		dir.Open(m_edtTiffRight->GetValue());
		cont = dir.GetFirst(&filename, wxT("*.tif"), wxDIR_FILES);
		
		while (cont) {
			cmd.Printf(wxT("image_to_j2k -cinema2K 24 -i \"%s\" -o \"%s\" -OutFor j2c\n"), 
						(m_edtTiffRight->GetValue() + wxT("\\") + filename).c_str(), 
						(m_edtJ2kRight->GetValue()  + wxT("\\") + filename.Left(filename.Len()-4) + wxT(".j2c")).c_str());
			f.Write(cmd);
			cont = dir.GetNext(&filename);
		}

	}
	//-----------------
	if (m_rad3d->GetValue()) {
		if (!m_edtJ2kLeft->IsEmpty() && !m_edtJ2kRight->IsEmpty() && !m_edtVideoMxf->IsEmpty()) {
			tmp.Assign(m_edtVideoMxf->GetValue());
			cmd.Printf(wxT("mkdir \"%s\"\n"), tmp.GetPath());
			f.Write(cmd);
			dir.Open(m_edtJ2kLeft->GetValue());
			dir2.Open(m_edtJ2kRight->GetValue());
			cmd.Printf(wxT("asdcp-test -L -3 -c \"%s\" \"%s\" \"%s\"\n"), 
						m_edtVideoMxf->GetValue().c_str(), 
						dir.GetName().c_str(),
						dir2.GetName().c_str());
			f.Write(cmd);
		}
	} else {
		if (!m_edtJ2kLeft->IsEmpty() && !m_edtVideoMxf->IsEmpty()) {
			tmp.Assign(m_edtVideoMxf->GetValue());
			cmd.Printf(wxT("mkdir \"%s\"\n"), tmp.GetPath());
			f.Write(cmd);
			dir.Open(m_edtJ2kLeft->GetValue());
			cmd.Printf(wxT("asdcp-test -L -c \"%s\" \"%s\"\n"), 
						m_edtVideoMxf->GetValue().c_str(), 
						dir.GetName().c_str());
			f.Write(cmd);
		}
	}
	//-----------------
	if (!m_edtLChannel->IsEmpty() && !m_edtRChannel->IsEmpty() && !m_edtCChannel->IsEmpty() && 
		!m_edtLFEChannel->IsEmpty() && !m_edtLSChannel->IsEmpty() && !m_edtRSChannel->IsEmpty() && 
		!m_edtSoundMxf->IsEmpty()) {
		tmp.Assign(m_edtSoundMxf->GetValue());
		cmd.Printf(wxT("mkdir \"%s\"\n"), tmp.GetPath());
		f.Write(cmd);
		cmd.Printf(wxT("asdcp-test -L -c \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\"\n"), 
					m_edtSoundMxf->GetValue().c_str(), 
					m_edtLChannel->GetValue().c_str(), m_edtRChannel->GetValue().c_str(), m_edtCChannel->GetValue().c_str(), 
					m_edtLFEChannel->GetValue().c_str(), m_edtLSChannel->GetValue().c_str(), m_edtRSChannel->GetValue().c_str());
		f.Write(cmd);
	}
	if (!m_edtCpoTitle->IsEmpty() && !m_edtVideoMxf->IsEmpty()) {
		cmd.Printf(wxT("mkcpl --kind %s --title \"%s\""), 
					m_choCpoKind->GetStringSelection(),
					m_edtCpoTitle->GetValue().c_str());
		
		if (!m_edtCpoAnnotation->IsEmpty()) {
			cmd += wxT(" --annotation \"");
			cmd += m_edtCpoAnnotation->GetValue();
			cmd += wxT("\"");
		}
		if (!m_edtCpoIssuer->IsEmpty()) {
			cmd += wxT(" --issuer \"");
			cmd += m_edtCpoIssuer->GetValue();
			cmd += wxT("\"");
		}
		if (!m_edtCpoAgency->IsEmpty() && !m_edtCpoRating->IsEmpty()) {
			cmd += wxT(" --rating \"");
			cmd += m_edtCpoAgency->GetValue();
			cmd += wxT("\"");
			cmd += wxT(" \"");
			cmd += m_edtCpoRating->GetValue();
			cmd += wxT("\"");
		} else {
			cmd += wxT("--norating");
		}
		cmd += wxT(" \"");
		cmd += m_edtVideoMxf->GetValue();
		cmd += wxT("\"");

		if (!m_edtSoundMxf->IsEmpty()) {
			cmd += wxT(" \"");
			cmd += m_edtSoundMxf->GetValue();
			cmd += wxT("\"");
		}
		cmd += wxT(" > \"");
		cpo = m_edtVideoMxf->GetValue();
		cpo = cpo.Left(cpo.Len()-10) + wxT(".cpl.xml");
		cmd += cpo;
		cmd += wxT("\"\n");
		f.Write(cmd);
	}
	//-----------------
	cmd = wxT("mkpkl --annotation \"");		
	if (!m_edtPklAnnotation->IsEmpty()) {
		cmd += m_edtPklAnnotation->GetValue();
	} else if (!m_edtCpoAnnotation->IsEmpty()) {
		cmd += m_edtCpoAnnotation->GetValue();
	} else {
		cmd += m_edtCpoTitle->GetValue();
	}
	cmd += wxT("\"");
	if (!m_edtPklIssuer->IsEmpty()) {
		cmd += wxT(" --issuer \"");
		cmd += m_edtPklIssuer->GetValue();
		cmd += wxT("\"");
	}
	
	cmd += wxT(" \"");
	cmd += m_edtVideoMxf->GetValue();
	cmd += wxT("\"");

	if (!m_edtSoundMxf->IsEmpty()) {
		cmd += wxT(" \"");
		cmd += m_edtSoundMxf->GetValue();
		cmd += wxT("\"");
	}

	cmd += wxT(" \"");
	cmd += cpo;

	cmd += wxT("\" > \"");
	pkl = m_edtVideoMxf->GetValue();
	pkl = pkl.Left(pkl.Len()-10) + wxT(".pkl.xml");
	cmd += pkl;
	cmd += wxT("\"\n");
	f.Write(cmd);
	
	//-----------------
	tmp.Assign(m_edtVideoMxf->GetValue());
	
	cmd.Printf(wxT("%s:\n"), tmp.GetVolume());
	f.Write(cmd);
	cmd.Printf(wxT("cd \"%s\"\n"), tmp.GetPath());
	f.Write(cmd);
	cwd = ::wxGetCwd();
	cmd.Printf(wxT("\"%s\\mkmap\""), cwd);		
	if (!m_edtMapAnnotation->IsEmpty()) {
		cmd += wxT(" --annotation \"");
		cmd += m_edtMapAnnotation->GetValue();
		cmd += wxT("\"");
	}
	if (!m_edtMapIssuer->IsEmpty()) {
		cmd += wxT(" --issuer \"");
		cmd += m_edtMapIssuer->GetValue();
		cmd += wxT("\"");
	}
	
	cmd += wxT(" \"");
	tmp = m_edtVideoMxf->GetValue();;
	cmd += tmp.GetFullName();
	cmd += wxT("\"");

	if (!m_edtSoundMxf->IsEmpty()) {
		cmd += wxT(" \"");
		tmp = m_edtSoundMxf->GetValue();
		cmd += tmp.GetFullName();
		cmd += wxT("\"");
	}

	cmd += wxT(" \"");
	tmp = cpo;
	cmd += tmp.GetFullName();

	cmd += wxT("\" \"");
	tmp = pkl;
	cmd += tmp.GetFullName();
	cmd += wxT("\"\n");
	f.Write(cmd);
	
	tmp = cwd;
	cmd.Printf(wxT("%s:\n"), tmp.GetVolume());
	f.Write(cmd);
	cmd.Printf(wxT("cd \"%s\"\n"), cwd);
	f.Write(cmd);

	cmd = wxT("pause");
	f.Write(cmd);
	f.Close();

	::wxShell(wxT("_makedcp.bat"));
}

void DcpMakerPanel::OnTimer(wxTimerEvent& WXUNUSED(event))
{
    
}