#!/bin/tcsh

#####################
# opencinematools

echo "################### building opencinematools ######################"

# asdcp, openssh, expat also installed in PREFIX
setenv PREFIX ${HOME}/etc

set compileCmd="g++ -O2 -c"
set linkCmd="g++"

$compileCmd -o ../../bin/mkcpl.o ../../src/mkcpl.cpp -I${PREFIX}/include
$compileCmd -o ../../bin/mkpkl.o ../../src/mkpkl.cpp -I${PREFIX}/include
$compileCmd -o ../../bin/mkmap.o  ../../src/mkmap.cpp -I${PREFIX}/include

# Link with static libraries
$linkCmd  -o ../../bin/mkcpl \
             ../../bin/mkcpl.o \
             ${PREFIX}/lib/libkumu.a \
             ${PREFIX}/lib/libasdcp.a \
             ${PREFIX}/lib/libcrypto.a \
             ${PREFIX}/lib/libexpat.a

$linkCmd -o ../../bin/mkpkl \
             ../../bin/mkpkl.o \
             ${PREFIX}/lib/libkumu.a \
             ${PREFIX}/lib/libasdcp.a \
             ${PREFIX}/lib/libcrypto.a \
             ${PREFIX}/lib/libexpat.a
$linkCmd -o ../../bin/mkmap \
             ../../bin/mkmap.o \
             ${PREFIX}/lib/libkumu.a \
             ${PREFIX}/lib/libasdcp.a \
             ${PREFIX}/lib/libcrypto.a \
             ${PREFIX}/lib/libexpat.a

# Install the executables
echo "################### Installing OpenCinemaTools ######################"

install -d ${PREFIX}/bin
install -v -p -s ../../bin/mkcpl $PREFIX/bin
install -v -p -s ../../bin/mkpkl $PREFIX/bin
install -v -p -s ../../bin/mkmap $PREFIX/bin
echo "################### Cleaning OpenCinemaTools ######################"

# Clean up
rm -f ../../bin/mkcpl ../../bin/mkpkl ../../bin/mkmap
rm -f ../../bin/*.o
echo "################### Done OpenCinemaTools ######################"

