<?php 
class ControllerPaymentPPDirectUK extends Controller {
	private $error = array(); 

	public function index() {
		$this->load->language('payment/pp_direct_uk');

		$this->document->title = $this->language->get('heading_title');
		
		$this->load->model('setting/setting');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->load->model('setting/setting');
			
			$this->model_setting_setting->editSetting('pp_direct_uk', $this->request->post);				
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->https('extension/payment'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_authorization'] = $this->language->get('text_authorization');
		$this->data['text_sale'] = $this->language->get('text_sale');
		
		$this->data['entry_vendor'] = $this->language->get('entry_vendor');
		$this->data['entry_user'] = $this->language->get('entry_user');
		$this->data['entry_password'] = $this->language->get('entry_password');
		$this->data['entry_partner'] = $this->language->get('entry_partner');
		$this->data['entry_test'] = $this->language->get('entry_test');
		$this->data['entry_transaction'] = $this->language->get('entry_transaction');
		$this->data['entry_order_status'] = $this->language->get('entry_order_status');		
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

		$this->data['error_warning'] = @$this->error['warning'];
		$this->data['error_vendor'] = @$this->error['vendor'];
		$this->data['error_user'] = @$this->error['user'];
		$this->data['error_password'] = @$this->error['password'];
		$this->data['error_partner'] = @$this->error['partner'];

		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('common/home'),
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('extension/payment'),
       		'text'      => $this->language->get('text_payment'),
      		'separator' => ' :: '
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('payment/pp_direct_uk'),
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);
				
		$this->data['action'] = $this->url->https('payment/pp_direct_uk');
		
		$this->data['cancel'] = $this->url->https('extension/payment');

		if (isset($this->request->post['pp_direct_uk_vendor'])) {
			$this->data['pp_direct_uk_vendor'] = $this->request->post['pp_direct_uk_vendor'];
		} else {
			$this->data['pp_direct_uk_vendor'] = $this->config->get('pp_direct_uk_vendor');
		}
		
		if (isset($this->request->post['pp_direct_uk_user'])) {
			$this->data['pp_direct_uk_user'] = $this->request->post['pp_direct_uk_user'];
		} else {
			$this->data['pp_direct_uk_user'] = $this->config->get('pp_direct_uk_user');
		}
		
		if (isset($this->request->post['pp_direct_uk_password'])) {
			$this->data['pp_direct_uk_password'] = $this->request->post['pp_direct_uk_password'];
		} else {
			$this->data['pp_direct_uk_password'] = $this->config->get('pp_direct_uk_password');
		}
		
		if (isset($this->request->post['pp_direct_uk_partner'])) {
			$this->data['pp_direct_uk_partner'] = $this->request->post['pp_direct_uk_partner'];
		} else {
			$this->data['pp_direct_uk_partner'] = $this->config->get('pp_direct_uk_partner');
		}
		
		if (isset($this->request->post['pp_direct_uk_test'])) {
			$this->data['pp_direct_uk_test'] = $this->request->post['pp_direct_uk_test'];
		} else {
			$this->data['pp_direct_uk_test'] = $this->config->get('pp_direct_uk_test');
		}
		
		if (isset($this->request->post['pp_direct_uk_method'])) {
			$this->data['pp_direct_uk_transaction'] = $this->request->post['pp_direct_uk_transaction'];
		} else {
			$this->data['pp_direct_uk_transaction'] = $this->config->get('pp_direct_uk_transaction');
		}
		
		if (isset($this->request->post['pp_direct_uk_order_status_id'])) {
			$this->data['pp_direct_uk_order_status_id'] = $this->request->post['pp_direct_uk_order_status_id'];
		} else {
			$this->data['pp_direct_uk_order_status_id'] = $this->config->get('pp_direct_uk_order_status_id'); 
		} 

		$this->load->model('localisation/order_status');
		
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		if (isset($this->request->post['pp_direct_uk_geo_zone_id'])) {
			$this->data['pp_direct_uk_geo_zone_id'] = $this->request->post['pp_direct_uk_geo_zone_id'];
		} else {
			$this->data['pp_direct_uk_geo_zone_id'] = $this->config->get('pp_direct_uk_geo_zone_id'); 
		} 
		
		$this->load->model('localisation/geo_zone');
										
		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
		
		if (isset($this->request->post['pp_direct_uk_status'])) {
			$this->data['pp_direct_uk_status'] = $this->request->post['pp_direct_uk_status'];
		} else {
			$this->data['pp_direct_uk_status'] = $this->config->get('pp_direct_uk_status');
		}
		
		if (isset($this->request->post['pp_direct_uk_sort_order'])) {
			$this->data['pp_direct_uk_sort_order'] = $this->request->post['pp_direct_uk_sort_order'];
		} else {
			$this->data['pp_direct_uk_sort_order'] = $this->config->get('pp_direct_uk_sort_order');
		}
		
		$this->id       = 'content';
		$this->template = 'payment/pp_direct_uk.tpl';
		$this->layout   = 'common/layout';
		
 		$this->render();
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/pp_direct_uk')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!@$this->request->post['pp_direct_uk_vendor']) {
			$this->error['vendor'] = $this->language->get('error_vendor');
		}
		
		if (!@$this->request->post['pp_direct_uk_user']) {
			$this->error['user'] = $this->language->get('error_user');
		}

		if (!@$this->request->post['pp_direct_uk_password']) {
			$this->error['password'] = $this->language->get('error_password');
		}

		if (!@$this->request->post['pp_direct_uk_partner']) {
			$this->error['partner'] = $this->language->get('error_partner');
		}
		
		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}	
	}
}
?>