/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNUpdateEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnExternalUpdateEditor
implements ISVNUpdateEditor {
    private long targetRevision;
    private String name;
    private long originalRevision;
    private File localAbsPath;
    private SVNWCContext context;
    private SvnChecksum originalChecksum;
    private File wriAbsPath;
    private SVNDeltaProcessor deltaProcessor = new SVNDeltaProcessor();
    private SVNWCContext.WritableBaseInfo currentBase;
    private SVNProperties davPropChanges;
    private SVNProperties entryPropChanges;
    private SVNProperties regularPropChanges;
    private SVNURL url;
    private SVNURL reposRootUrl;
    private long changedRev;
    private String changedAuthor;
    private SVNDate changedDate;
    private String[] extPatterns;
    private boolean useCommitTimes;
    private String reposUuid;
    private File recordAncestorAbspath;
    private File recordedReposRelPath;
    private long recordedPegRevision;
    private long recordedRevision;
    private SvnChecksum newMd5Checksum;
    private SvnChecksum newSha1Checksum;
    private boolean fileClosed;

    public static ISVNUpdateEditor createEditor(SVNWCContext context, File localAbsPath, File wriAbsPath, SVNURL url, SVNURL reposRootUrl, String reposUuid, boolean useCommitTimes, String[] preservedExts, File recordAncestorAbsPath, SVNURL recordedUrl, SVNRevision recordedPegRev, SVNRevision recordedRev) {
        SvnExternalUpdateEditor editor = new SvnExternalUpdateEditor();
        editor.context = context;
        editor.localAbsPath = localAbsPath;
        editor.wriAbsPath = wriAbsPath != null ? wriAbsPath : SVNFileUtil.getParentFile(localAbsPath);
        editor.url = url;
        editor.reposRootUrl = reposRootUrl;
        editor.reposUuid = reposUuid;
        editor.name = SVNFileUtil.getFileName(localAbsPath);
        editor.useCommitTimes = useCommitTimes;
        editor.extPatterns = preservedExts;
        editor.recordAncestorAbspath = recordAncestorAbsPath;
        editor.recordedReposRelPath = SVNFileUtil.createFilePath(SVNURLUtil.getRelativeURL(reposRootUrl, recordedUrl, false));
        editor.recordedPegRevision = recordedPegRev != null ? recordedPegRev.getNumber() : -1L;
        editor.recordedRevision = recordedRev != null ? recordedRev.getNumber() : -1L;
        return (ISVNUpdateEditor)SVNCancellableEditor.newInstance(editor, context.getEventHandler(), null);
    }

    public void targetRevision(long revision) throws SVNException {
        this.targetRevision = revision;
    }

    public void openRoot(long revision) throws SVNException {
    }

    public void deleteEntry(String path, long revision) throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
    }

    public void openDir(String path, long revision) throws SVNException {
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
    }

    public void closeDir() throws SVNException {
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        if (!name.equals(this.name)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "This editor can only update ''{0}''", (Object)this.localAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.originalRevision = -1L;
    }

    public void openFile(String path, long revision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        if (!name.equals(this.name)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "This editor can only update ''{0}''", (Object)this.localAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        ISVNWCDb.WCDbBaseInfo baseInfo = this.context.getDb().getBaseInfo(this.localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum);
        this.originalRevision = baseInfo.revision;
        this.changedRev = baseInfo.changedRev;
        this.changedDate = baseInfo.changedDate;
        this.changedAuthor = baseInfo.changedAuthor;
        this.originalChecksum = baseInfo.checksum;
        if (baseInfo.kind != ISVNWCDb.SVNWCDbKind.File) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Node ''{0}'' is not existing file external", (Object)this.localAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if (SVNProperty.isRegularProperty(propertyName)) {
            if (this.regularPropChanges == null) {
                this.regularPropChanges = new SVNProperties();
            }
            this.regularPropChanges.put(propertyName, propertyValue);
        } else if (SVNProperty.isEntryProperty(propertyName)) {
            if (this.entryPropChanges == null) {
                this.entryPropChanges = new SVNProperties();
            }
            this.entryPropChanges.put(propertyName, propertyValue);
        } else if (SVNProperty.isWorkingCopyProperty(propertyName)) {
            if (this.davPropChanges == null) {
                this.davPropChanges = new SVNProperties();
            }
            this.davPropChanges.put(propertyName, propertyValue);
        }
    }

    public void closeFile(String path, String expectedMd5Digest) throws SVNException {
        SVNProperties newPristineProperties;
        SVNProperties newActualProperties;
        this.fileClosed = true;
        if (expectedMd5Digest != null) {
            SvnChecksum expectedMd5Checksum = new SvnChecksum(SvnChecksum.Kind.md5, expectedMd5Digest);
            SvnChecksum actualMd5Checksum = this.newMd5Checksum;
            if (actualMd5Checksum == null && (actualMd5Checksum = this.originalChecksum) != null && actualMd5Checksum.getKind() != SvnChecksum.Kind.md5) {
                actualMd5Checksum = this.context.getDb().getPristineMD5(this.wriAbsPath, actualMd5Checksum);
            }
            if (!expectedMd5Checksum.equals(actualMd5Checksum)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}'':\n   expected: ''{1}''\n     actual: ''{2}''\n", this.localAbsPath, expectedMd5Checksum, actualMd5Checksum);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (this.newSha1Checksum != null) {
            this.context.getDb().installPristine(this.currentBase.tempBaseAbspath, this.currentBase.getSHA1Checksum(), this.currentBase.getMD5Checksum());
            SVNFileUtil.deleteFile(this.currentBase.tempBaseAbspath);
        }
        boolean added = this.originalRevision == -1L;
        File reposRelPath = SVNFileUtil.createFilePath(SVNURLUtil.getRelativeURL(this.reposRootUrl, this.url, false));
        SvnChecksum newChecksum = null;
        SVNProperties actualProperties = null;
        SVNProperties baseProperties = new SVNProperties();
        SVNSkel allWorkItems = null;
        if (!added) {
            newChecksum = this.originalChecksum;
            actualProperties = this.context.getDb().getBaseProps(this.localAbsPath);
        }
        if (actualProperties == null) {
            actualProperties = new SVNProperties();
        }
        if (this.newSha1Checksum != null) {
            newChecksum = this.newSha1Checksum;
        }
        for (String propName : this.entryPropChanges.nameSet()) {
            SVNPropertyValue value = this.entryPropChanges.getSVNPropertyValue(propName);
            if (value == null) continue;
            if ("svn:entry:committed-date".equals(propName)) {
                this.changedDate = SVNDate.parseDate(value.getString());
                continue;
            }
            if ("svn:entry:last-author".equals(propName)) {
                this.changedAuthor = value.getString();
                continue;
            }
            if (!"svn:entry:committed-rev".equals(propName)) continue;
            try {
                this.changedRev = Long.parseLong(value.getString());
            }
            catch (NumberFormatException nfe) {}
        }
        SVNStatusType contentState = SVNStatusType.UNKNOWN;
        SVNStatusType propState = SVNStatusType.UNKNOWN;
        if (this.regularPropChanges != null) {
            SVNWCContext.MergePropertiesInfo mergeInfo = new SVNWCContext.MergePropertiesInfo();
            mergeInfo.newActualProperties = new SVNProperties();
            mergeInfo.newBaseProperties = new SVNProperties();
            mergeInfo = this.context.mergeProperties2(mergeInfo, this.localAbsPath, ISVNWCDb.SVNWCDbKind.File, null, null, null, baseProperties, actualProperties, this.regularPropChanges, true, false);
            if (mergeInfo.workItems != null) {
                allWorkItems = this.context.wqMerge(allWorkItems, mergeInfo.workItems);
            }
            propState = mergeInfo.mergeOutcome;
            newActualProperties = mergeInfo.newActualProperties;
            newPristineProperties = mergeInfo.newBaseProperties;
        } else {
            newActualProperties = baseProperties;
            newPristineProperties = actualProperties;
        }
        boolean installPristine = false;
        boolean obstructed = false;
        if (this.newSha1Checksum != null) {
            SVNFileType fileType = SVNFileType.getType(this.localAbsPath);
            SVNNodeKind kind = SVNFileType.getNodeKind(fileType);
            if (kind == SVNNodeKind.NONE) {
                installPristine = true;
                contentState = SVNStatusType.CHANGED;
            } else if (kind != SVNNodeKind.FILE) {
                obstructed = true;
                contentState = SVNStatusType.UNCHANGED;
            } else {
                boolean isModified = this.context.isTextModified(this.localAbsPath, false);
                if (!isModified) {
                    installPristine = true;
                    contentState = SVNStatusType.CHANGED;
                } else {
                    SVNProperties propChanges = new SVNProperties();
                    if (this.regularPropChanges != null) {
                        propChanges.putAll(this.regularPropChanges);
                    }
                    if (this.entryPropChanges != null) {
                        propChanges.putAll(this.entryPropChanges);
                    }
                    if (this.davPropChanges != null) {
                        propChanges.putAll(this.davPropChanges);
                    }
                    SVNWCContext.MergeInfo outcome = SVNUpdateEditor17.performFileMerge(this.context, this.localAbsPath, this.wriAbsPath, newChecksum, this.originalChecksum, actualProperties, this.extPatterns, this.originalRevision, this.targetRevision, propChanges);
                    if (outcome.workItems != null) {
                        allWorkItems = this.context.wqMerge(allWorkItems, outcome.workItems);
                    }
                    contentState = outcome.mergeOutcome;
                }
            }
            if (installPristine) {
                SVNSkel workItem = this.context.wqBuildFileInstall(this.localAbsPath, null, this.useCommitTimes, true);
                allWorkItems = this.context.wqMerge(allWorkItems, workItem);
            }
        } else {
            contentState = SVNStatusType.UNCHANGED;
        }
        if (this.davPropChanges != null) {
            this.davPropChanges.removeNullValues();
        }
        SvnWcDbExternals.addExternalFile(this.context, this.localAbsPath, this.wriAbsPath, reposRelPath, this.reposRootUrl, this.reposUuid, this.targetRevision, newPristineProperties, this.changedRev, this.changedDate, this.changedAuthor, newChecksum, this.davPropChanges, this.recordAncestorAbspath, this.recordedReposRelPath, this.recordedPegRevision, this.recordedRevision, true, newActualProperties, false, allWorkItems);
        this.context.wqRun(this.wriAbsPath);
        if (this.context.getEventHandler() != null) {
            SVNEventAction action = null;
            action = this.originalRevision != -1L ? (obstructed ? SVNEventAction.UPDATE_SHADOWED_UPDATE : SVNEventAction.UPDATE_UPDATE) : (obstructed ? SVNEventAction.UPDATE_SHADOWED_ADD : SVNEventAction.UPDATE_ADD);
            String mimeType = this.context.getProperty(this.localAbsPath, "svn:mime-type");
            SVNEvent event = SVNEventFactory.createSVNEvent(this.localAbsPath, SVNNodeKind.FILE, mimeType, this.targetRevision, contentState, propState, null, action, null, null, null);
            event.setPreviousRevision(this.originalRevision);
            this.context.getEventHandler().handleEvent(event, -1.0);
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (!this.fileClosed) {
            this.context.getDb().opBumpRevisionPostUpdate(this.localAbsPath, SVNDepth.INFINITY, null, null, null, this.targetRevision, null);
        }
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void applyTextDelta(String path, String baseChecksumDigest) throws SVNException {
        InputStream source = SVNFileUtil.DUMMY_IN;
        if (this.originalChecksum != null) {
            SvnChecksum originalMd5;
            SvnChecksum expectedChecksum;
            if (baseChecksumDigest != null && !(expectedChecksum = new SvnChecksum(SvnChecksum.Kind.md5, baseChecksumDigest)).equals(originalMd5 = this.originalChecksum.getKind() != SvnChecksum.Kind.md5 ? this.context.getDb().getPristineMD5(this.wriAbsPath, this.originalChecksum) : this.originalChecksum)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Base checksum mismatch for ''{0}'':\n   expected: ''{1}''\n     actual: ''{2}''\n", this.localAbsPath, expectedChecksum, originalMd5);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            source = this.context.getDb().readPristine(this.wriAbsPath, this.originalChecksum);
        }
        this.currentBase = this.context.openWritableBase(this.wriAbsPath, true, true);
        this.deltaProcessor.applyTextDelta(source, this.currentBase.stream, true);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (this.currentBase == null) {
            return SVNFileUtil.DUMMY_OUT;
        }
        try {
            this.deltaProcessor.textDeltaChunk(diffWindow);
        }
        catch (SVNException svne) {
            this.deltaProcessor.textDeltaEnd();
            SVNFileUtil.deleteFile(this.currentBase.tempBaseAbspath);
            this.currentBase.tempBaseAbspath = null;
            throw svne;
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    public void textDeltaEnd(String path) throws SVNException {
        if (this.currentBase == null) {
            return;
        }
        this.deltaProcessor.textDeltaEnd();
        this.newSha1Checksum = this.currentBase.getSHA1Checksum();
        this.newMd5Checksum = this.currentBase.getMD5Checksum();
    }

    public long getTargetRevision() {
        return this.targetRevision;
    }
}

