/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.toolbars;

import com.vlsolutions.swing.toolbars.BackgroundPainter;
import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarPanelLayout;
import com.vlsolutions.swing.toolbars.VLToolBar;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ToolBarPanel
extends JPanel {
    private int orientation = 0;
    private BackgroundPainter painter;

    public ToolBarPanel() {
        this(3);
    }

    public ToolBarPanel(int align) {
        this(align, null);
    }

    public ToolBarPanel(int align, BackgroundPainter painter) {
        this.setLayout(new ToolBarPanelLayout(this, align));
        this.painter = painter;
    }

    public void add(JToolBar toolbar) {
        this.add(toolbar, 0);
        this.setVisible(true);
    }

    public void add(JToolBar toolbar, int major) {
        toolbar.setOrientation(this.orientation);
        VLToolBar[] bars = this.getVLToolBarsFromJToolBar(toolbar);
        for (int i = 0; i < bars.length; ++i) {
            ToolBarConstraints toolBarConstraints = new ToolBarConstraints(major, i);
            this.add(bars[i], toolBarConstraints);
        }
    }

    private VLToolBar[] getVLToolBarsFromJToolBar(JToolBar bar) {
        ArrayList<VLToolBar> vlBars = new ArrayList<VLToolBar>();
        Component[] components = bar.getComponents();
        VLToolBar current = new VLToolBar();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JButton) {
                JButton button = (JButton)components[i];
                if (button.getIcon() != null) {
                    button.setText(null);
                }
                current.add(button);
                continue;
            }
            if (components[i] instanceof JToolBar.Separator) {
                vlBars.add(current);
                current = new VLToolBar();
                continue;
            }
            System.err.println("Don't know how to handle this component " + components[i].getClass());
        }
        vlBars.add(current);
        return vlBars.toArray(new VLToolBar[vlBars.size()]);
    }

    public void add(VLToolBar toolbar, ToolBarConstraints constraints) {
        toolbar.setOrientation(this.orientation);
        super.add((Component)toolbar, constraints);
        this.setVisible(true);
    }

    public void remove(Component comp) {
        super.remove(comp);
        if (this.getComponentCount() == 0) {
            this.setVisible(false);
        }
    }

    public void setOrientation(int orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.updateOrientation();
            this.revalidate();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    private void updateOrientation() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            VLToolBar tb = (VLToolBar)this.getComponent(i);
            tb.setOrientation(this.orientation);
        }
    }

    public void paintComponent(Graphics g) {
        if (this.painter != null) {
            this.painter.paintBackground(this, g);
        }
        super.paintComponent(g);
    }

    public BackgroundPainter getBackgroundPainter() {
        return this.painter;
    }

    public void setPainter(BackgroundPainter painter) {
        this.painter = painter;
    }
}

