/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;

public class FileTreeIterator
extends WorkingTreeIterator {
    protected final File directory;
    protected final FS fs;

    public FileTreeIterator(Repository repo) {
        this(repo.getWorkTree(), repo.getFS(), repo.getConfig().get(WorkingTreeOptions.KEY));
        this.initRootIterator(repo);
    }

    public FileTreeIterator(File root, FS fs, WorkingTreeOptions options) {
        super(options);
        this.directory = root;
        this.fs = fs;
        this.init(this.entries());
    }

    protected FileTreeIterator(FileTreeIterator p, File root, FS fs) {
        super(p);
        this.directory = root;
        this.fs = fs;
        this.init(this.entries());
    }

    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        return new FileTreeIterator(this, ((FileEntry)this.current()).file, this.fs);
    }

    private WorkingTreeIterator.Entry[] entries() {
        File[] all = this.directory.listFiles();
        if (all == null) {
            return EOF;
        }
        WorkingTreeIterator.Entry[] r = new WorkingTreeIterator.Entry[all.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new FileEntry(all[i], this.fs);
        }
        return r;
    }

    public File getDirectory() {
        return this.directory;
    }

    public File getEntryFile() {
        return ((FileEntry)this.current()).getFile();
    }

    protected byte[] idSubmodule(WorkingTreeIterator.Entry e) {
        if (this.repository == null) {
            return this.idSubmodule(this.getDirectory(), e);
        }
        return super.idSubmodule(e);
    }

    public static class FileEntry
    extends WorkingTreeIterator.Entry {
        final File file;
        private final FileMode mode;
        private long length = -1L;
        private long lastModified;

        FileEntry(File f, FS fs) {
            this.file = f;
            this.mode = f.isDirectory() ? (new File(f, ".git").exists() ? FileMode.GITLINK : FileMode.TREE) : (fs.canExecute(this.file) ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE);
        }

        public FileMode getMode() {
            return this.mode;
        }

        public String getName() {
            return this.file.getName();
        }

        public long getLength() {
            if (this.length < 0L) {
                this.length = this.file.length();
            }
            return this.length;
        }

        public long getLastModified() {
            if (this.lastModified == 0L) {
                this.lastModified = this.file.lastModified();
            }
            return this.lastModified;
        }

        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public File getFile() {
            return this.file;
        }
    }
}

