/**************************************************************************
 OmegaT Addon - Import of legacy translations of Java(TM) Resource Bundles
 Copyright (C) 2004-05  Maxym Mykhalchuk
                        mihmax@gmail.com

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
**************************************************************************/


package org.omegat.tools.align.bundles;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.filechooser.FileFilter;

import org.omegat.util.gui.LanguageComboBoxRenderer;
import org.omegat.util.Language;


/**
 * ImportBundles frame of importer
 *
 * @author Maxym Mykhalchuk
 */
public class ImportBundles extends JFrame implements UndoableEditListener
{
    
    /**
     * Creates new form ImportBundles
     */
    public ImportBundles()
    {
        initComponents();
        jEditFolder.getDocument().addUndoableEditListener(this);
        jEditLecacyFile.getDocument().addUndoableEditListener(this);
        getRootPane().setDefaultButton(jBtnImport);
    }
    
    /** Captures edit events from folder and TMX file edit fields */
    public void undoableEditHappened(UndoableEditEvent e)
    {
        jBtnImport.setEnabled( jEditFolder.getText().length()>0 
                && jEditLecacyFile.getText().length()>0 );
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        java.awt.GridBagConstraints gridBagConstraints;

        jBtnImport = new javax.swing.JButton();
        jLabelStatus = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jLabelFolder = new javax.swing.JLabel();
        jEditFolder = new javax.swing.JTextField();
        jBtnBrowseFolder = new javax.swing.JButton();
        jLabelNote = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        jLabelLegacyFile = new javax.swing.JLabel();
        jEditLecacyFile = new javax.swing.JTextField();
        jBtnBrowseLegacyFile = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jLabelSrcLang = new javax.swing.JLabel();
        jLabelLocLang = new javax.swing.JLabel();
        sourceLanguageCombo = new javax.swing.JComboBox();
        targetLanguageCombo = new javax.swing.JComboBox();
        hintTextArea = new javax.swing.JTextArea();
        buttonClose = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle(getString("IB_TITLE"));
        org.openide.awt.Mnemonics.setLocalizedText(jBtnImport, getString("IB_BUTTON_IMPORT"));
        jBtnImport.setEnabled(false);
        jBtnImport.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                jBtnImportActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 3, 2);
        getContentPane().add(jBtnImport, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 1, 5);
        getContentPane().add(jLabelStatus, gridBagConstraints);

        jPanel2.setLayout(new java.awt.BorderLayout(3, 3));

        org.openide.awt.Mnemonics.setLocalizedText(jLabelFolder, getString("IB_RESOURCES_LABEL"));
        jPanel2.add(jLabelFolder, java.awt.BorderLayout.NORTH);

        jEditFolder.setMaximumSize(new java.awt.Dimension(200, 2147483647));
        jPanel2.add(jEditFolder, java.awt.BorderLayout.CENTER);

        org.openide.awt.Mnemonics.setLocalizedText(jBtnBrowseFolder, getString("IB_LEGACYFOLDER_BROWSE_BUTTON"));
        jBtnBrowseFolder.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                jBtnBrowseFolderActionPerformed(evt);
            }
        });

        jPanel2.add(jBtnBrowseFolder, java.awt.BorderLayout.EAST);

        org.openide.awt.Mnemonics.setLocalizedText(jLabelNote, getString("IB_NOTE_RECURSIVE"));
        jPanel2.add(jLabelNote, java.awt.BorderLayout.SOUTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jPanel2, gridBagConstraints);

        jPanel4.setLayout(new java.awt.BorderLayout(3, 3));

        org.openide.awt.Mnemonics.setLocalizedText(jLabelLegacyFile, getString("IB_LEGACYTMX_LABEL"));
        jPanel4.add(jLabelLegacyFile, java.awt.BorderLayout.NORTH);

        jEditLecacyFile.setMaximumSize(new java.awt.Dimension(200, 2147483647));
        jPanel4.add(jEditLecacyFile, java.awt.BorderLayout.CENTER);

        org.openide.awt.Mnemonics.setLocalizedText(jBtnBrowseLegacyFile, getString("IB_LEGACYTMX_BROWSE_BUTTON"));
        jBtnBrowseLegacyFile.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                jBtnBrowseLegacyFileActionPerformed(evt);
            }
        });

        jPanel4.add(jBtnBrowseLegacyFile, java.awt.BorderLayout.EAST);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jPanel4, gridBagConstraints);

        jPanel5.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabelSrcLang, getString("IB_SOURCE_LANGUAGE_LABEL"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel5.add(jLabelSrcLang, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabelLocLang, getString("IB_TARGET_LANGUAGE_LABEL"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel5.add(jLabelLocLang, gridBagConstraints);

        sourceLanguageCombo.setEditable(true);
        sourceLanguageCombo.setModel(new DefaultComboBoxModel(Language.LANGUAGES));
        sourceLanguageCombo.setSelectedItem(new Language(getString("IB_DEFAULT_SRC_LANG")));
        sourceLanguageCombo.setRenderer(new LanguageComboBoxRenderer());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel5.add(sourceLanguageCombo, gridBagConstraints);

        targetLanguageCombo.setEditable(true);
        targetLanguageCombo.setModel(new DefaultComboBoxModel(Language.LANGUAGES));
        targetLanguageCombo.setSelectedItem(new Language(getString("IB_DEFAULT_TAR_LANG")));
        targetLanguageCombo.setRenderer(new LanguageComboBoxRenderer());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel5.add(targetLanguageCombo, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jPanel5, gridBagConstraints);

        hintTextArea.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
        hintTextArea.setColumns(20);
        hintTextArea.setEditable(false);
        hintTextArea.setFont(new JLabel().getFont());
        hintTextArea.setLineWrap(true);
        hintTextArea.setRows(5);
        hintTextArea.setText(getString("IB_DESCRIPTION"));
        hintTextArea.setWrapStyleWord(true);
        hintTextArea.setFocusable(false);
        hintTextArea.setRequestFocusEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(hintTextArea, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(buttonClose, getString("IB_BUTTON_CLOSE"));
        buttonClose.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                buttonCloseActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(15, 2, 3, 5);
        getContentPane().add(buttonClose, gridBagConstraints);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Dimension dialogSize = getSize();
        setLocation((screenSize.width-dialogSize.width)/2,(screenSize.height-dialogSize.height)/2);
    }
    // </editor-fold>//GEN-END:initComponents

    private void buttonCloseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_buttonCloseActionPerformed
    {//GEN-HEADEREND:event_buttonCloseActionPerformed
        setVisible(false);
        System.exit(0);
    }//GEN-LAST:event_buttonCloseActionPerformed
    
	private void jBtnBrowseLegacyFileActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jBtnBrowseLegacyFileActionPerformed
	{//GEN-HEADEREND:event_jBtnBrowseLegacyFileActionPerformed
            JFileChooser fch = new JFileChooser(new File(jEditLecacyFile.getText()).getParent());
            fch.addChoosableFileFilter(new FileFilter()
            {
                public boolean accept(File f)
                {
                    return f.isDirectory() || f.getName().endsWith(".tmx");     
                }
                public String getDescription()
                {
                    return getString("IB_TMX_FILES");
                }
            }
            );
            if( JFileChooser.APPROVE_OPTION == fch.showSaveDialog(this) )
            {
                String file = fch.getSelectedFile().getAbsolutePath();
                if( !file.endsWith(".tmx") )                                    
                    file = file + ".tmx";                                       
                jEditLecacyFile.setText(file);
            }
	}//GEN-LAST:event_jBtnBrowseLegacyFileActionPerformed
        
	private void jBtnBrowseFolderActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jBtnBrowseFolderActionPerformed
	{//GEN-HEADEREND:event_jBtnBrowseFolderActionPerformed
            JFileChooser fch = new JFileChooser(jEditFolder.getText());
            fch.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            if( JFileChooser.APPROVE_OPTION == fch.showOpenDialog(this) )
                jEditFolder.setText(fch.getSelectedFile().getAbsolutePath());
	}//GEN-LAST:event_jBtnBrowseFolderActionPerformed
        
	private void jBtnImportActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jBtnImportActionPerformed
	{//GEN-HEADEREND:event_jBtnImportActionPerformed
            jLabelStatus.setText( getString("IB_STATUS_IMPORTING"));
            
            try
            {
                BundleImportCore.doImport(
                        sourceLanguageCombo.getSelectedItem().toString(),
                        targetLanguageCombo.getSelectedItem().toString(),
                        jEditFolder.getText(),
                        jEditLecacyFile.getText());
                jLabelStatus.setText( getString("IB_STATUS_COMPLETE"));
            }
            catch( Exception e )
            {
                jLabelStatus.setText( getString("IB_STATUS_ERROR"));
            }
            
	}//GEN-LAST:event_jBtnImportActionPerformed
        
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JButton buttonClose;
    public javax.swing.JTextArea hintTextArea;
    public javax.swing.JButton jBtnBrowseFolder;
    public javax.swing.JButton jBtnBrowseLegacyFile;
    public javax.swing.JButton jBtnImport;
    public javax.swing.JTextField jEditFolder;
    public javax.swing.JTextField jEditLecacyFile;
    public javax.swing.JLabel jLabelFolder;
    public javax.swing.JLabel jLabelLegacyFile;
    public javax.swing.JLabel jLabelLocLang;
    public javax.swing.JLabel jLabelNote;
    public javax.swing.JLabel jLabelSrcLang;
    public javax.swing.JLabel jLabelStatus;
    public javax.swing.JPanel jPanel2;
    public javax.swing.JPanel jPanel4;
    public javax.swing.JPanel jPanel5;
    public javax.swing.JComboBox sourceLanguageCombo;
    public javax.swing.JComboBox targetLanguageCombo;
    // End of variables declaration//GEN-END:variables

    public static void main(String args[])
    {
        try
        {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("apple.laf.useScreenMenuBar", "true");           
        }
        catch (Exception e)
        {
            // do nothing
            System.out.println(getString("IB_CANNOT_INIT_LF"));
        }
        
        new ImportBundles().setVisible(true);
    }

    /** Resource bundle that contains all the strings */
    private static ResourceBundle bundle = ResourceBundle.getBundle("org/omegat/tools/align/bundles/Bundle");
    
    /** Returns a localized String for a key */
    public static String getString(String key)
    {
        return bundle.getString(key);
    }
    
}
