/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit.examples;

import org.custommonkey.xmlunit.ElementNameAndTextQualifier;
import org.custommonkey.xmlunit.ElementNameQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultiLevelElementNameAndTextQualifier
implements ElementQualifier {
    private final int levels;
    private static final ElementNameQualifier NAME_QUALIFIER = new ElementNameQualifier();
    private static final ElementNameAndTextQualifier NAME_AND_TEXT_QUALIFIER = new ElementNameAndTextQualifier();

    public MultiLevelElementNameAndTextQualifier(int levels) {
        if (levels < 1) {
            throw new IllegalArgumentException("levels must be equal or greater than one");
        }
        this.levels = levels;
    }

    public boolean qualifyForComparison(Element control, Element test) {
        boolean stillSimilar = true;
        Element currentControl = control;
        Element currentTest = test;
        for (int currentLevel = 0; stillSimilar && currentLevel <= this.levels - 2; ++currentLevel) {
            stillSimilar = NAME_QUALIFIER.qualifyForComparison(currentControl, currentTest);
            if (!stillSimilar) continue;
            if (currentControl.hasChildNodes() && currentTest.hasChildNodes()) {
                Node n1 = currentControl.getFirstChild();
                Node n2 = currentTest.getFirstChild();
                if (n1.getNodeType() == 1 && n2.getNodeType() == 1) {
                    currentControl = (Element)n1;
                    currentTest = (Element)n2;
                    continue;
                }
                stillSimilar = false;
                continue;
            }
            stillSimilar = false;
        }
        if (stillSimilar) {
            stillSimilar = NAME_AND_TEXT_QUALIFIER.qualifyForComparison(currentControl, currentTest);
        }
        return stillSimilar;
    }
}

