/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.toolbars;

import com.vlsolutions.swing.docking.animation.AnimationEvent;
import com.vlsolutions.swing.docking.animation.AnimationListener;
import com.vlsolutions.swing.docking.animation.ComponentAnimator;
import com.vlsolutions.swing.toolbars.ToolBarButtonBorder;
import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarContainer;
import com.vlsolutions.swing.toolbars.ToolBarGripper;
import com.vlsolutions.swing.toolbars.ToolBarPanel;
import com.vlsolutions.swing.toolbars.ToolBarPanelLayout;
import com.vlsolutions.swing.toolbars.VLButtonUI;
import com.vlsolutions.swing.toolbars.VLToolBarLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class VLToolBar
extends JPanel {
    private ToolBarGripper gripper = new ToolBarGripper();
    private boolean rolloverBorderPainted = true;
    private boolean rolloverContentAreaFilled = false;
    private boolean useCustomUI = true;
    private int orientation = 0;
    private MouseListener buttonMouseHandler = new MouseAdapter(){

        public void mouseEntered(MouseEvent e) {
            AbstractButton btn = (AbstractButton)e.getSource();
            if ((e.getModifiersEx() & 0x400) == 0) {
                if (VLToolBar.this.rolloverBorderPainted) {
                    btn.setBorderPainted(true);
                }
                if (VLToolBar.this.rolloverContentAreaFilled) {
                    btn.setContentAreaFilled(true);
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            AbstractButton btn = (AbstractButton)e.getSource();
            btn.setBorderPainted(false);
        }
    };
    private GripperHandler gripperListener = new GripperHandler();
    private Border draggedBorder = new ToolBarButtonBorder();
    private VLToolBarLayout horizontalLayout = new VLToolBarLayout(true, 0);
    private VLToolBarLayout verticalLayout = new VLToolBarLayout(false, 0);
    boolean isInAnimationCycle = false;

    public VLToolBar() {
        this((String)null);
    }

    public VLToolBar(String name) {
        this.setName(name);
        this.setLayout(this.horizontalLayout);
        this.gripper.addMouseMotionListener(this.gripperListener);
        this.gripper.addMouseListener(this.gripperListener);
        this.gripper.setPreferredSize(new Dimension(4, 20));
        this.add(this.gripper);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.gripper.setToolTipText(name);
    }

    public void addSeparator() {
        Dimension size = (Dimension)UIManager.get("ToolBar.separatorSize");
        JToolBar.Separator sep = new JToolBar.Separator();
        sep.setOrientation(this.orientation);
        if (this.orientation == 0) {
            sep.setOrientation(1);
            sep.setPreferredSize(size);
            this.add(sep);
        } else {
            sep.setOrientation(0);
            sep.setPreferredSize(size);
            this.add(sep);
        }
    }

    public Component add(Component comp) {
        if (comp instanceof AbstractButton) {
            return this.add((AbstractButton)comp);
        }
        if (!(comp instanceof ToolBarGripper)) {
            comp.setVisible(!this.gripper.isCollapsed());
        }
        return super.add(comp);
    }

    public Component add(AbstractButton button) {
        if (this.useCustomUI) {
            this.installButtonUI(button);
        }
        button.setVisible(!this.gripper.isCollapsed());
        super.add(button);
        this.configureButton(button);
        this.installMouseHandler(button);
        return button;
    }

    public Component add(JButton button) {
        return this.add((AbstractButton)button);
    }

    public void installButtonUI(AbstractButton button) {
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setUI(new VLButtonUI());
        button.setBorder(new ToolBarButtonBorder());
    }

    public void installMouseHandler(AbstractButton button) {
        button.addMouseListener(this.buttonMouseHandler);
    }

    public void configureButton(AbstractButton button) {
        button.setRolloverEnabled(true);
        button.setContentAreaFilled(false);
        button.setOpaque(false);
        button.setBorderPainted(false);
    }

    public void setRolloverBorderPainted(boolean painted) {
        this.rolloverBorderPainted = painted;
    }

    public boolean isRolloverBorderPainter() {
        return this.rolloverBorderPainted;
    }

    public void setRolloverContentAreaFilled(boolean filled) {
        this.rolloverContentAreaFilled = filled;
    }

    public boolean isRolloverContentAreaFilled() {
        return this.rolloverContentAreaFilled;
    }

    public void setUseCustomUI(boolean useCustomUI) {
        this.useCustomUI = useCustomUI;
    }

    public boolean isUseCustomUI() {
        return this.useCustomUI;
    }

    public void setDraggedBorder(Border border) {
        this.draggedBorder = border;
    }

    public Border getDraggedBorder() {
        return this.draggedBorder;
    }

    private void gripperDragged(MouseEvent e) {
        Component gripper = e.getComponent();
        ToolBarPanel panel = (ToolBarPanel)this.getParent();
        if (!(panel.getParent() instanceof ToolBarContainer)) {
            return;
        }
        ToolBarContainer container = (ToolBarContainer)panel.getParent();
        Point tbPanelPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), panel);
        if (panel.contains(tbPanelPoint)) {
            ToolBarPanelLayout layout = (ToolBarPanelLayout)panel.getLayout();
            ToolBarConstraints constraints = layout.getInsertionContraintsAt(this, tbPanelPoint);
            if (constraints != null) {
                panel.remove(this);
                panel.add(this, constraints);
                panel.revalidate();
            }
        } else {
            Rectangle containerBounds = container.getBounds();
            Rectangle invisiblePanelBounds = new Rectangle(containerBounds);
            ToolBarPanel topPanel = (ToolBarPanel)container.getComponentAt("North");
            invisiblePanelBounds.height = 10;
            if (this.checkGripperOnOtherPanel(topPanel, e, invisiblePanelBounds)) {
                return;
            }
            invisiblePanelBounds.y = containerBounds.y + containerBounds.height - 10;
            ToolBarPanel bottomPanel = (ToolBarPanel)container.getComponentAt("South");
            if (this.checkGripperOnOtherPanel(bottomPanel, e, invisiblePanelBounds)) {
                return;
            }
            invisiblePanelBounds.y = containerBounds.y;
            invisiblePanelBounds.height = containerBounds.height;
            invisiblePanelBounds.width = 10;
            ToolBarPanel leftPanel = (ToolBarPanel)container.getComponentAt("West");
            if (this.checkGripperOnOtherPanel(leftPanel, e, invisiblePanelBounds)) {
                return;
            }
            invisiblePanelBounds.x = containerBounds.x + containerBounds.width - 10;
            ToolBarPanel rightPanel = (ToolBarPanel)container.getComponentAt("East");
            if (this.checkGripperOnOtherPanel(rightPanel, e, invisiblePanelBounds)) {
                return;
            }
        }
    }

    private boolean checkGripperOnOtherPanel(ToolBarPanel panel, MouseEvent e, Rectangle invisibleBounds) {
        if (panel != null && panel != this.getParent()) {
            if (panel.isVisible()) {
                Point panelPoint = SwingUtilities.convertPoint(this, e.getPoint(), panel);
                if (panel.contains(panelPoint)) {
                    this.gripperDraggedOnOtherVisiblePanel(panel, panelPoint);
                    return true;
                }
            } else {
                Point containerPoint = SwingUtilities.convertPoint(this, e.getPoint(), panel.getParent());
                if (invisibleBounds.contains(containerPoint)) {
                    ToolBarPanel parent = (ToolBarPanel)this.getParent();
                    parent.remove(this);
                    panel.add(this, new ToolBarConstraints(0, 0));
                    panel.revalidate();
                    if (parent.getComponentCount() == 0) {
                        parent.setVisible(false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void gripperDraggedOnOtherVisiblePanel(ToolBarPanel panel, Point point) {
        ToolBarPanelLayout layout = (ToolBarPanelLayout)panel.getLayout();
        ToolBarConstraints constraints = layout.getInsertionContraintsAt(this, point);
        if (constraints != null) {
            ToolBarPanel parent = (ToolBarPanel)this.getParent();
            parent.remove(this);
            panel.add(this, constraints);
            panel.revalidate();
        }
    }

    public String toString() {
        return "VLToolBar " + this.getName();
    }

    public void setOrientation(int orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.gripper.setOrientation(orientation);
            Component[] comps = this.getComponents();
            this.removeAll();
            if (orientation == 0) {
                this.gripper.setPreferredSize(new Dimension(4, 20));
                this.setLayout(this.horizontalLayout);
                for (int i = 0; i < comps.length; ++i) {
                    if (comps[i] instanceof JToolBar.Separator) {
                        JToolBar.Separator sep = (JToolBar.Separator)comps[i];
                        sep.setOrientation(1);
                    }
                    this.add(comps[i]);
                }
            } else {
                this.gripper.setPreferredSize(new Dimension(20, 4));
                this.setLayout(this.verticalLayout);
                for (int i = 0; i < comps.length; ++i) {
                    if (comps[i] instanceof JSeparator) {
                        JSeparator sep = (JSeparator)comps[i];
                        sep.setOrientation(0);
                    }
                    this.add(comps[i]);
                }
            }
            this.revalidate();
        }
    }

    public void setToolTipText(String tooltip) {
        super.setToolTipText(tooltip);
        this.gripper.setToolTipText(tooltip);
    }

    private void gripperClicked(MouseEvent e) {
        if (this.isCollapsible() && !this.isInAnimationCycle) {
            this.setCollapsed(!this.gripper.isCollapsed());
        }
    }

    public void setCollapsed(final boolean collapsed) {
        if (collapsed) {
            float animSpeed;
            Rectangle newBounds;
            Rectangle bounds = this.getBounds();
            if (this.orientation == 0) {
                newBounds = new Rectangle(bounds.x, bounds.y, 20, this.getHeight());
                animSpeed = (float)this.getWidth() / 800.0f;
            } else {
                newBounds = new Rectangle(bounds.x, bounds.y, this.getWidth(), 20);
                animSpeed = (float)this.getHeight() / 800.0f;
            }
            ComponentAnimator canim = new ComponentAnimator(this, bounds, newBounds, animSpeed);
            canim.addAnimationListener(new AnimationListener(){

                public void animation(AnimationEvent e) {
                    if (e.getState() == 2) {
                        VLToolBar.this.gripperListener.resetBorder();
                        VLToolBar.this.finishAnimation(collapsed);
                    }
                }
            });
            this.gripperListener.installDragBorder();
            canim.start();
        } else {
            this.finishAnimation(collapsed);
        }
    }

    private void finishAnimation(boolean collapsed) {
        this.gripper.setCollapsed(collapsed);
        int maxSize = 20;
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof ToolBarGripper) continue;
            maxSize = this.orientation == 0 ? Math.max(maxSize, comps[i].getHeight()) : Math.max(maxSize, comps[i].getWidth());
            comps[i].setVisible(!collapsed);
        }
        if (collapsed) {
            if (this.orientation == 0) {
                this.gripper.setPreferredSize(new Dimension(6, maxSize));
            } else {
                this.gripper.setPreferredSize(new Dimension(maxSize, 6));
            }
        }
        this.revalidate();
    }

    public boolean isCollapsed() {
        return this.gripper.isCollapsed();
    }

    public boolean isCollapsible() {
        return this.gripper.isCollapsible();
    }

    public void setCollapsible(boolean collapsible) {
        this.gripper.setCollapsible(collapsible);
    }

    private class GripperHandler
    implements MouseListener,
    MouseMotionListener {
        Border oldBorder;

        private GripperHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            VLToolBar.this.gripperDragged(e);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.resetBorder();
        }

        public void resetBorder() {
            VLToolBar.this.setBorder(this.oldBorder);
        }

        public void installDragBorder() {
            this.oldBorder = VLToolBar.this.getBorder();
            VLToolBar.this.setBorder(VLToolBar.this.draggedBorder);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.installDragBorder();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            VLToolBar.this.gripperClicked(mouseEvent);
        }
    }
}

