/*******************************************************************************

	$Id: JD2AppleEventHandlerThunk.java,v 1.7 2004/08/11 03:16:52 steve Exp $
	
	File:		JD2AppleEventHandlerThunk.java
	Author:		Steve Roy
	Copyright:	Copyright (c) 2003-2004 Steve Roy <sroy@roydesign.net>
				
	Part of MRJ Adapter, a unified API for easy integration of Mac OS specific
	functionality within your cross-platform Java application.
	
	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published
	by the Free Software Foundation; either version 2.1 of the License, or
	(at your option) any later version.
	
	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
	or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
	License for more details.
	
	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation, Inc.,
	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	Change History:
	08/31/03	Created this file - Steve

*******************************************************************************/

package net.roydesign.mac;

import com.apple.mrj.jdirect.MethodClosureUPP;

/**
 * This class is a necessary wrapper used internally for event handling with
 * MRJ 2.x. It creates an object that can be used as a callback in the context
 * of JDirect 2.
 * 
 * @version MRJ Adapter 1.0.8
 */
class JD2AppleEventHandlerThunk extends MethodClosureUPP
{
	/**
	 * Construct an Apple event handler thunk.
	 * @param handle the Apple event handler to be wrapped
	 */
	public JD2AppleEventHandlerThunk(AppleEventHandler handler)
	{
		super(handler, "handleEvent", "(III)S", 0x00000FE0);
	}
}
