/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.tokenizer;

import java.text.BreakIterator;
import org.dts.spell.finder.Word;
import org.dts.spell.tokenizer.AbstractWordTokenizer;
import org.dts.spell.tokenizer.CharIteratorAdapter;

public class DefaultWordTokenizer
extends AbstractWordTokenizer {
    private BreakIterator wordIterator;
    private CharIteratorAdapter wordSequence = new CharIteratorAdapter();
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$org$dts$spell$tokenizer$DefaultWordTokenizer;

    static {
        Class<?> clazz = class$org$dts$spell$tokenizer$DefaultWordTokenizer;
        if (clazz == null) {
            clazz = class$org$dts$spell$tokenizer$DefaultWordTokenizer = new DefaultWordTokenizer[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DefaultWordTokenizer() {
        this(BreakIterator.getWordInstance());
    }

    public DefaultWordTokenizer(BreakIterator wordIterator) {
        this.wordIterator = wordIterator;
    }

    protected Word scanBefore(CharSequence sequence, int index) {
        String text;
        int start = this.wordIterator.preceding(index);
        int end = this.wordIterator.next();
        if (start == -1) {
            start = 0;
        }
        if (!(text = sequence.subSequence(start, end).toString().trim()).equals("")) {
            return new Word(text, start, this.isStartOfSentence(sequence, start));
        }
        return null;
    }

    protected Word scanAfter(CharSequence sequence, int index) {
        String text;
        int end = this.wordIterator.following(index);
        int start = this.wordIterator.previous();
        if (end == -1) {
            end = sequence.length() - 1;
        }
        if (!(text = sequence.subSequence(start, end).toString().trim()).equals("")) {
            return new Word(text, start, this.isStartOfSentence(sequence, start));
        }
        return null;
    }

    public Word currentWord(int index) {
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError();
        }
        CharSequence sequence = this.getCharSequence();
        int length = sequence.length();
        Word result = null;
        if (length > 0 && length >= index) {
            result = index == length ? this.scanBefore(sequence, index - 1) : (this.wordIterator.isBoundary(index) && Character.isWhitespace(sequence.charAt(index)) ? this.scanBefore(sequence, index) : this.scanAfter(sequence, index));
        }
        return result;
    }

    private void onChangeSequence() {
        CharSequence sequence = this.getCharSequence();
        this.wordSequence.setCharSequence(sequence);
        this.wordIterator.setText(this.wordSequence);
    }

    private void onInsertChars(int start, int end) {
        this.onChangeSequence();
    }

    private void onDeleteChars(int start, int end) {
        this.onChangeSequence();
    }

    public void updateCharSequence(int start, int end, int cause) {
        switch (cause) {
            case 2: {
                this.onChangeSequence();
                break;
            }
            case 0: {
                this.onInsertChars(start, end);
                break;
            }
            case 1: {
                this.onDeleteChars(start, end);
            }
        }
    }
}

