/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.finder;

import net.sourceforge.retroweaver.runtime.java.lang.StringBuffer_;

public class Word
implements CharSequence {
    private int start;
    private String text;
    private boolean isStart;

    public Word(String text, int start, boolean isStart) {
        this.text = text;
        this.start = start;
        this.isStart = isStart;
    }

    public Word(String text, int start) {
        this(text, start, false);
    }

    public void moveTo(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.getStart() + this.length();
    }

    public int getStart() {
        return this.start;
    }

    public String getText() {
        return this.text;
    }

    public int length() {
        return this.text.length();
    }

    public String toString() {
        return this.text;
    }

    public boolean isStartOfSentence() {
        return this.isStart;
    }

    public void setStartStartOfSentence(boolean isStart) {
        this.isStart = isStart;
    }

    public boolean isCorrectFirstChar() {
        char c = this.text.charAt(0);
        if (Character.isLetter(c)) {
            if (this.isStartOfSentence()) {
                return Character.isUpperCase(c);
            }
            return true;
        }
        return true;
    }

    public boolean isUpperCase() {
        return this.text.toUpperCase().equals(this.text);
    }

    public boolean hasLetters() {
        int i = 0;
        while (i < this.length()) {
            if (Character.isLetter(this.text.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Word) {
            Word ow = (Word)o;
            return ow.getStart() == this.getStart() && ow.getText().equals(this.getText());
        }
        return false;
    }

    public boolean equalText(Word word) {
        return this.equalText(word.getText());
    }

    public boolean equalText(String text) {
        return this.getText().equals(text);
    }

    public boolean equalIgnoreCaseText(Word word) {
        return this.equalIgnoreCase(word.getText());
    }

    public boolean equalIgnoreCase(String text) {
        return this.getText().equalsIgnoreCase(text);
    }

    public char charAt(int index) {
        return this.text.charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
        return this.text.subSequence(start, end);
    }

    public String getStartSentenceWordCase() {
        return Word.getStartSentenceWordCase(this);
    }

    public static String getStartSentenceWordCase(CharSequence word) {
        StringBuffer str = StringBuffer_.StringBuffer((CharSequence)word);
        str.setCharAt(0, Character.toUpperCase(word.charAt(0)));
        return str.toString();
    }
}

