/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import java.io.IOException;
import org.dts.spell.dictionary.myspell.AffEntry;
import org.dts.spell.dictionary.myspell.AffixHeader;
import org.dts.spell.dictionary.myspell.AffixMgr;
import org.dts.spell.dictionary.myspell.Conditions;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.PfxEntry;
import org.dts.spell.dictionary.myspell.Utils;

public class SfxEntry
extends AffEntry {
    String rappnd;

    public SfxEntry(AffixMgr pmyMgr, AffixHeader header, String line) throws IOException {
        super(pmyMgr, header, line);
    }

    protected Conditions createConditions(String cs) {
        if (!(cs = cs.trim()).equals(".")) {
            cs = ".*" + cs;
        }
        return Conditions.createFrom(cs);
    }

    public void readFrom(String line, char type) throws IOException {
        super.readFrom(line, type);
        this.rappnd = Utils.myRevStrDup(this.appnd);
    }

    public HEntry check(String word, int optflags, PfxEntry ppfx) {
        if ((optflags & Utils.XPRODUCT) != 0 && (this.xpflg & Utils.XPRODUCT) == 0) {
            return null;
        }
        if (!word.endsWith(this.appnd)) {
            return null;
        }
        String firstWord = String.valueOf(word.substring(0, word.length() - this.appnd.length())) + this.strip;
        if (!this.conds.match(firstWord)) {
            return null;
        }
        HEntry he = this.pmyMgr.lookup(firstWord);
        if (he != null && he.astr != null && Utils.TestAff(he.astr, this.achar, he.astr.length()) && ((optflags & Utils.XPRODUCT) == 0 || Utils.TestAff(he.astr, ppfx.getName(), he.astr.length()))) {
            return he;
        }
        return null;
    }

    public boolean allowCross() {
        return (this.xpflg & Utils.XPRODUCT) != 0;
    }

    public String add(String word) {
        if (!this.conds.match(word)) {
            return null;
        }
        if (!word.endsWith(this.strip)) {
            return null;
        }
        return String.valueOf(word.substring(0, word.length() - this.strip.length())) + this.appnd;
    }

    protected void build_list() {
        this.pmyMgr.build_sfxlist(this);
    }
}

