/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DetachedDockView;
import com.vlsolutions.swing.docking.DockTabbedPane;
import com.vlsolutions.swing.docking.DockView;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.FloatingDialog;
import com.vlsolutions.swing.docking.FloatingDockableContainer;
import com.vlsolutions.swing.docking.MaximizedDockView;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import com.vlsolutions.swing.docking.TabbedDockView;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;

public class DefaultDockableContainerFactory
extends DockableContainerFactory {
    public SingleDockableContainer createDockableContainer(Dockable dockable, int parentType) {
        switch (parentType) {
            case 1: {
                return new TabbedDockView(dockable);
            }
            case 0: {
                new MaximizedDockView(dockable);
            }
            case 2: {
                return new DockView(dockable);
            }
            case 3: {
                return new DetachedDockView(dockable);
            }
        }
        throw new RuntimeException("Wrong dockable container type");
    }

    public TabbedDockableContainer createTabbedDockableContainer() {
        return new DockTabbedPane();
    }

    public FloatingDockableContainer createFloatingDockableContainer(Window owner) {
        if (owner instanceof Dialog) {
            return new FloatingDialog((Dialog)owner);
        }
        return new FloatingDialog((Frame)owner);
    }
}

