<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/

/*
==========================================================
	ABSOLUTE FILES AND PATH FOR SYSTEM
==========================================================
*/

	// Absolute path
	$path_name = basename(getcwd());
	if( $path_name == 'admin' )
	{
		$DIR_TO_BLOG = '../';
		$DIR_TO_ADMIN = './';
	}
	elseif( $path_name == 'ajax' )
	{
		$DIR_TO_BLOG = '../../';
		$DIR_TO_ADMIN = './../';
	}

	// Paths
	define('PATH_PLUGINS',				$DIR_TO_BLOG . 'plugins/');
	define('PATH_LANG',					$DIR_TO_BLOG . 'lang/');
	define('PATH_TEMPLATES',			$DIR_TO_BLOG . 'templates/');
	define('PATH_PUBLIC',				$DIR_TO_BLOG . 'content/public/');
	define('PATH_PRIVATE',				$DIR_TO_BLOG . 'content/private/');
	define('PATH_TMP',					$DIR_TO_BLOG . 'content/tmp/');
	
	define('PATH_POSTS',					PATH_PUBLIC . 'posts/');
	define('PATH_COMMENTS',				PATH_PUBLIC . 'comments/');
	define('PATH_RSS',					PATH_PUBLIC . 'rss/');
	define('PATH_PROFILES_PICTURES',	PATH_PUBLIC . 'profiles/');
	
	define('PATH_UPLOAD',				PATH_PUBLIC . 'upload/');
	define('PATH_UPLOAD_PICTURES',	PATH_UPLOAD . 'pictures/');
	define('PATH_UPLOAD_VIDEOS',		PATH_UPLOAD . 'videos/');
	define('PATH_UPLOAD_TEXT',			PATH_UPLOAD . 'text/');
	define('PATH_UPLOAD_OTHERS',		PATH_UPLOAD . 'others/');

	define('PATH_KERNEL',				$DIR_TO_ADMIN. 'kernel/');
	define('PATH_ADMIN_THEMES',		$DIR_TO_ADMIN. 'themes/');

	// XML files
	define('FILE_XML_CONFIG',			PATH_PRIVATE . 'config.xml');
	define('FILE_XML_POST',				PATH_PRIVATE . 'post.xml');
	define('FILE_XML_COMMENTS',		PATH_PRIVATE . 'comments.xml');
	define('FILE_XML_CATEGORIES',		PATH_PRIVATE . 'categories.xml');
	define('FILE_XML_LINKS',			PATH_PRIVATE . 'links.xml');
	define('FILE_XML_PROFILES',		PATH_PRIVATE . 'profiles.xml');
	define('FILE_XML_TAGS',				PATH_PRIVATE . 'tags.xml');
	define('FILE_XML_SYSLOG',			PATH_PRIVATE . 'syslog.xml');
	define('FILE_XML_RSS',				PATH_RSS . 'rss.xml');
	
	// :P
	define('FILE_SHADOW', 				PATH_PRIVATE . 'shadow.php');
	define('FILE_KEYS', 					PATH_PRIVATE . 'keys.php');
		
	// Javascript files
	define('FILE_JS_JQUERY',			'js/jquery/jquery.js');
	define('FILE_JS_JCROP',				'js/jcrop/jcrop.js');
	define('FILE_JS_JQUERYUI',			'js/jquery-ui/jquery-ui.js');
	define('FILE_JS_ELRTE',				'js/elrte/elrte.js');
	define('FILE_JS_ELFINDER',			'js/elrte/elfinder.js');
	define('FILE_JS_FUNCTIONS',		'js/nb/functions.js');
	
/*
=============================
	CLASS
=============================
*/
	require_once( PATH_KERNEL . 'class.login.php' );

	require( PATH_KERNEL . 'class.nbxml.php' );
	require( PATH_KERNEL . 'class.config_dbxml.php' );
	require( PATH_KERNEL . 'class.categories_dbxml.php' );
	require( PATH_KERNEL . 'class.comments_dbxml.php' );
	require( PATH_KERNEL . 'class.post_dbxml.php' );
	require( PATH_KERNEL . 'class.links_dbxml.php' );
	require( PATH_KERNEL . 'class.profiles_dbxml.php' );
	require( PATH_KERNEL . 'class.rss_dbxml.php' );
	require( PATH_KERNEL . 'class.syslog_dbxml.php' );
	require( PATH_KERNEL . 'class.framework_html.php' );
	require( PATH_KERNEL . 'class.tags_dbxml.php' );
	require( PATH_KERNEL . 'class.email.php' );
	
/*
=============================
	OBJECTS
=============================
*/
	$dbxml_config		= new CONFIG_DBXML( FILE_XML_CONFIG );
	$dbxml_post			= new POST_DBXML( FILE_XML_POST );
	$dbxml_categories	= new CATEGORIES_DBXML( FILE_XML_CATEGORIES );
	$dbxml_comments	= new COMMENTS_DBXML( FILE_XML_COMMENTS );
	$dbxml_links		= new LINKS_DBXML( FILE_XML_LINKS );
	$dbxml_profiles 	= new PROFILES_DBXML( FILE_XML_PROFILES );
	$dbxml_rss			= new RSS_DBXML( FILE_XML_RSS );
	$dbxml_syslog		= new SYSLOG_DBXML( FILE_XML_SYSLOG );
	$dbxml_tags			= new TAGS_DBXML( FILE_XML_TAGS );
	$nbfunctions		= new NBFUNCTIONS();
	$html					= new HTML();
	$nbmail				= new EMAIL();

/*
=============================
	GLOBALS VARIABLES
=============================
*/
	define('SYSTEM_NAME', 'Nibbleblog');
	define('SYSTEM_VERSION', '3.0.2');
	define('SYSTEM_DATE', '19/12/10');

	define('POSTPPAGE', '10');
	define('COMMENTPPAGE', '20');
	define('LOGINSLEEP', '2');
	define('BOOLEAN_DEBUG', true);

	// Variables de error
	$_FLAG['success'] = false;
	$_FLAG['error'] = false;
	$_FLAG['msj'] = '';

	// Variables de formularios
	$_URL = array();
	
	// Variables URL
	$_URL = array();
	$_URL['exe']			= (string) $_POST['exe'];
	$_URL['gexe']			= (string) $_GET['gexe'];
	$_URL['view']			= (string) $_GET['view'];
	$_URL['idpost']		= (int) $_GET['idpost'];
	$_URL['idcat']			= (int) $_GET['idcat'];
	$_URL['idcomment']	= (int) $_GET['idcomment'];

	// Number of page
	$nbfunctions->valid_int( $_GET['page'] ) ? $_URL['page'] = $_GET['page'] : $_URL['page'] = 0;

/*
=============================
	FIX MAGIC QUOTES
=============================
*/
	if( $_SERVER['REQUEST_METHOD'] == 'POST' )
	{
		// Magic quotes is ON ?
		if( get_magic_quotes_gpc() != 0 )
			$_POST = $nbfunctions->clean_magic_quotes($_POST);
	}

/*
=============================
	LANGUAGE
=============================
*/
	if( !@include( PATH_LANG.$dbxml_config->get_language().'.php' ) )
		require( PATH_LANG.'english.php' );

/*
=============================
	DEBUG
=============================
*/
	if( !BOOLEAN_DEBUG )
		error_reporting(0);
		
?>
