<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/

class NBINSTALL {

	private $php_modules;
	private $apache_modules;
	
	function NBINSTALL()
	{		
		if(function_exists('get_loaded_extensions'))
			$this->php_modules = get_loaded_extensions();
		else
			$this->php_modules = array();
		
		if(function_exists('apache_get_modules'))
			$this->apache_modules = apache_get_modules();
		else
			$this->apache_modules = array();
	}
	
	function verify_phpversion($version = '5.2')
	{
		return( version_compare(phpversion(), $version, ">") );
	}
	
	function get_phpversion()
	{
		return( phpversion() );
	}
	
	// $module = gd
	// $module = SimpleXML
	function verify_php_module($module)
	{
		return ( in_array($module, $this->php_modules) );
	}
	
	// $module = mod_rewrite
	function verify_apache_module($module)
	{
		return ( in_arrayi($module,$this->apache_modules) );
	}
	
	function verify_perms($directory, $perms = 777)
	{
		return( (substr(decoct(@fileperms($directory)),2) ) == $perms);
	}
	
	function verify_write($directory)
	{
		$status = @mkdir($directory);

		@rmdir($directory);
		
		return ( $status );
	}
	
}

?>
