<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/

class CONFIG_DBXML extends NBFUNCTIONS {

/*
======================================================================================
	VARIABLES
======================================================================================
*/
		public $file_xml; 			// Contains the link to the blog_config.xml file
		public $obj_xml; 				// Contains the object of the blog_config.xml file
		public $flag_error;			// Error Flag
		public $flag_i18n;			// Menssage Error

/*
======================================================================================
	CONSTRUCTORS
======================================================================================
*/
		function CONFIG_DBXML($file)
		{			
			$this->flag_error = false;
			$this->flag_i18n = "";
	
			$this->file_xml = $file;
	
			if (file_exists($this->file_xml))
			{
				$this->obj_xml = new NBXML($this->file_xml, 0, TRUE, '', FALSE);
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_OPENED';
			}
		}

/*
======================================================================================
	METHODS
======================================================================================
*/
		public function flag_error()
		{
			return($this->flag_error);
		}

		public function flag_i18n()
		{
			return($this->flag_i18n);
		}

		public function savetofile()
		{
			if( !($this->obj_xml->asXML($this->file_xml)) )
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
			}
		}

		public function set($ARGS)
		{		
			$tmp_node = $this->obj_xml;
	
			$tmp_node->name			= utf8_encode($this->html2text($ARGS['name']));
			$tmp_node->description	= utf8_encode($this->html2text($ARGS['description']));
			$tmp_node->language		= utf8_encode($this->html2text($ARGS['language']));
			$tmp_node->timezone		= utf8_encode($this->html2text($ARGS['timezone']));
			$tmp_node->template		= utf8_encode($this->html2text($ARGS['template']));
			$tmp_node->footer			= utf8_encode($this->html2text($ARGS['footer']));
			$tmp_node->about			= utf8_encode($this->html2text($ARGS['about']));
			$tmp_node->url				= utf8_encode($this->html2text($ARGS['url']));
			$tmp_node->path			= utf8_encode($this->html2text($ARGS['path']));
			$tmp_node->rewriteurl	= utf8_encode($this->html2text($ARGS['rewriteurl']));
			$tmp_node->mail_notification = utf8_encode($this->html2text($ARGS['mail_notification']));
			$tmp_node->items_rss		= utf8_encode($this->html2text($ARGS['items_rss']));
			$tmp_node->items_page	= utf8_encode($this->html2text($ARGS['items_page']));
		}

		public function get_name()
		{
			return( (string) utf8_decode( $this->obj_xml->name ) );
		}

		public function get_description()
		{
			return( (string) utf8_decode( $this->obj_xml->description ) );
		}

		public function get_language()
		{
			return( (string) utf8_decode( $this->obj_xml->language ) );
		}

		public function get_timezone()
		{
			return( (string) utf8_decode( $this->obj_xml->timezone ) );
		}

		public function get_template()
		{
			return( (string) utf8_decode( $this->obj_xml->template ) );
		}

		public function get_footer()
		{
			return( (string) utf8_decode( $this->obj_xml->footer ) );
		}

		public function get_about()
		{
			return( (string) utf8_decode( $this->obj_xml->about ) );
		}

		public function get_url()
		{
			return( (string) utf8_decode( $this->obj_xml->url ) );
		}

		public function get_path()
		{
			return( (string) utf8_decode( $this->obj_xml->path ) );
		}

		public function get_rewriteurl()
		{
			return( (int) utf8_decode( $this->obj_xml->rewriteurl ) );
		}

		public function get_mail_notification()
		{
			return( (int) utf8_decode( $this->obj_xml->mail_notification ) );
		}

		public function get_items_rss()
		{
			return( (int) utf8_decode( $this->obj_xml->items_rss ) );
		}

		public function get_items_page()
		{
			return( (int) utf8_decode( $this->obj_xml->items_page ) );
		}

/*
======================================================================================
	METHODS - PLUGINS
======================================================================================
*/
		public function plugins_bigban()
		{
			unset($this->obj_xml->plugins);
	
			$this->obj_xml->ADD_Element('plugins','');
		}

		public function plugins_add($plugin)
		{			
			$this->obj_xml->plugins->ADD_Element('plugin',$plugin);
		}

		public function plugins_get_all()
		{
			$tmp_array = array();
	
			foreach( $this->obj_xml->plugins->plugin as $node)
				array_push($tmp_array, (string)$node);

			return( $tmp_array );
		}

} // END Class

?>
