<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/

class COMMENTS_DBXML extends NBFUNCTIONS {

/*
======================================================================================
	VARIABLES
======================================================================================
*/
		public $file_xml; 			// Contains the link to the blog_config.xml file
		public $obj_xml; 				// Contains the object of the blog_config.xml file
		public $flag_error;			// Error Flag
		public $flag_i18n;			// Menssage Error

		private $files;
		private $files_count;

/*
======================================================================================
	CONSTRUCTORS
======================================================================================
*/
		function COMMENTS_DBXML($file)
		{			
			$this->flag_error = false;
			$this->flag_i18n = "";
	
			$this->file_xml = $file;
	
			if (file_exists($this->file_xml))
			{
				$this->obj_xml = new NBXML($this->file_xml, 0, TRUE, '', FALSE);
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_OPENED';
			}
		}

/*
======================================================================================
	METHODS
======================================================================================
*/
		public function flag_error()
		{
			return($this->flag_error);
		}

		public function flag_i18n()
		{
			return($this->flag_i18n);
		}

		public function savetofile()
		{
			if( !($this->obj_xml->asXML($this->file_xml)) )
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
			}
		}

		public function get_autoinc()
		{
			return( (int) $this->obj_xml['autoinc'] );
		}

		private function set_autoinc($value = 0)
		{
			$this->obj_xml['autoinc'] = $value + $this->get_autoinc();
		}

		// return boolean
		// TRUE		- exist ip
		// FALSE		- not exist ip
		public function spam_exist($ip)
		{		
			return( $this->obj_xml->xpath('/comments/spam//ip[.="'.$ip.'"]') != array() );
		}
		
		public function spam_add($ip)
		{
			if( !$this->spam_exist($ip) )
				$this->obj_xml->spam->ADD_Element('ip', $ip);
		}
		
		public function spam_get_all()
		{
			$tmp_array = array();
			foreach( $this->obj_xml->spam->children() as $children )
			{
				array_push($tmp_array, (string) utf8_decode($children));
			}
			return( $tmp_array );
		}
		
		public function spam_remove($ip)
		{
			$tmp_node = $this->obj_xml->xpath('/comments/spam/ip[.="'.$ip.'"]');

			if( $tmp_node != array() )
			{
				$dom = dom_import_simplexml($tmp_node[0]);
				$dom->parentNode->removeChild($dom);
			}
		}

		public function add($ARGS)
		{
			include( FILE_KEYS );
			
			$time_unix = $this->unixstamp();
			$time = $this->unixstamp_to_date(0, $time_unix);
			
			$xml = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
			$xml .= '<comment>';
			$xml .= '</comment>';
		
			$obj = new NBXML($xml, 0, FALSE, '', FALSE);
		
			$obj->ADD_Element('author_name',		$this->html2text($ARGS['author_name']) );
			$obj->ADD_Element('author_email',	$this->encrypt( $this->html2text($ARGS['author_email']), $_KEYS['comment']) );
			$obj->ADD_Element('author_ip',		$this->encrypt( $ARGS['author_ip'], $_KEYS['comment']) );
			$obj->ADD_Element('author_web',		$this->html2text($ARGS['author_web']) );
			$obj->ADD_Element('content',			strip_tags($ARGS['content'], '<br><br/><b>') );
			$obj->ADD_Element('pub_date', 		$time_unix);
			$obj->ADD_Element('highlight',		'0');
			
			// New ID for comment
			$id = $this->get_autoinc();
		
			// Filename for new comment
			// File name: IDComment.IDPost.IDUser.IDOther.YYYY.MM.DD.HH.mm.ss.xml
			$time_tmp = $time['Y'] . '.' . $time['m'] . '.' . $time['d'] . '.' . $time['H'] . '.' . $time['i'] . '.' . $time['s'];
			$filename = $id . '.' . $ARGS['idpost'] . '.' . $ARGS['iduser'] . '.NULL.' . $time_tmp . '.xml';
			
			// Save to file
			if( $obj->asXml( PATH_COMMENTS . $filename ) )
			{
				// Autoinc
				$this->set_autoinc(1);
				
				// Save post.xml
				$this->savetofile();
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
			}

		}


		// Setea los comentarios de un post en particular
		// File name: CommentID.PostID.UserID.OtherID.YYYY.MM.DD.HH.mm.ss.xml
		private function set_file($id)
		{
			$this->files = $this->ls(PATH_COMMENTS, $id.'.*.*.*.*.*.*.*.*.*', 'xml', false, false, false);
			$this->files_count = count( $this->files );
		}

		// Setea todos los comentarios que hay
		// File name: CommentID.PostID.UserID.OtherID.YYYY.MM.DD.HH.mm.ss.xml
		private function set_files()
		{
			$this->files = $this->ls(PATH_COMMENTS, '*', 'xml', false, false, true);
			$this->files_count = count( $this->files );
		}

		// Setea los comentarios de un post en particular
		// File name: IDComment.IDPost.IDUser.IDOther.YYYY.MM.DD.HH.mm.ss.xml
		private function set_files_by_post($idpost)
		{
			$this->files = $this->ls(PATH_COMMENTS, '*.'.$idpost.'.*.*.*.*.*.*.*.*', 'xml', false, true, false);
			$this->files_count = count( $this->files );
		}
		
		private function get_items($file)
		{
			include( FILE_KEYS );
					
			$obj_xml = new NBXML(PATH_COMMENTS . $file, 0, TRUE, '', FALSE);
		
			$file_info = explode('.', $file);

			$tmp_array = array();
		
			$tmp_array['idcomment']			= $file_info[0];
			$tmp_array['idpost']				= $file_info[1];
			$tmp_array['iduser']				= $file_info[2];
			$tmp_array['idother']			= $file_info[3];
			$tmp_array['author_name']		= (string) utf8_decode($obj_xml->author_name);
			$tmp_array['author_web']		= (string) utf8_decode($obj_xml->author_web);
			$tmp_array['author_email']		= (string) utf8_decode($this->desencrypt( $obj_xml->author_email, $_KEYS['comment'] ));
			$tmp_array['author_ip']			= (string) utf8_decode($this->desencrypt( $obj_xml->author_ip, $_KEYS['comment'] ));
			$tmp_array['content']			= (string) utf8_decode($obj_xml->content);
			$tmp_array['pub_date']			= (string) utf8_decode($obj_xml->pub_date);
			$tmp_array['highlight']			= (int) utf8_decode($obj_xml->highlight);
			
			return( $tmp_array );
		}
		
		public function get_all_by_post($idpost)
		{
			$this->set_files_by_post($idpost);
			
			$tmp_array = array();
			foreach($this->files as $file)
				array_push( $tmp_array, $this->get_items( $file ) );
			return( $tmp_array );
		}

		public function get_last($total)
		{
			$this->set_files();

			$tmp_array = array();

			$total = min($total, $this->files_count);

			for($i = 0; $i < $total; $i++)
				array_push( $tmp_array, $this->get_items( $this->files[$i] ) );

			return( $tmp_array );
		}
		
		public function get_list_by_page($page_number, $amount)
		{
			// Set the list of post
			$this->set_files();
			
			$init = (int) $amount * $page_number;
			$end  = (int) min( ($init + $amount - 1), $this->files_count - 1 );
			$outrange = $init > $end;
			
			$tmp_array = array();
			
			if( !$outrange )
			{
				for($init; $init <= $end; $init++)
				{
					array_push( $tmp_array, $this->get_items( $this->files[$init] ) );
				}
			}
			
			return( $tmp_array );
		}

		public function delete_all_by_post($idpost)
		{
			$this->set_files_by_post($idpost);

			foreach($this->files as $file)
				unlink( PATH_COMMENTS . $file );
		}

		public function delete($id)
		{
			$this->set_file($id);
			
			if($this->files_count > 0)
			{
				if( !unlink(PATH_COMMENTS . $this->files[0]) )
				{
					$this->flag_error = true;
					$this->flag_i18n = 'FILE_COULDNT_BE_DELETED';
				}
			}
		}

		public function get_count()
		{
			return( $this->files_count );
		}

} // END Class

?>
