<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/

class CATEGORIES_DBXML extends NBFUNCTIONS {

/*
======================================================================================
	VARIABLES
======================================================================================
*/
		public $file_xml; 			// Contains the link to the blog_config.xml file
		public $obj_xml; 				// Contains the object of the blog_config.xml file
		public $flag_error;			// Error Flag
		public $flag_i18n;			// Menssage Error

/*
======================================================================================
	CONSTRUCTORS
======================================================================================
*/
		function CATEGORIES_DBXML($file)
		{			
			$this->flag_error = false;
			$this->flag_i18n = "";

			$this->file_xml = $file;

			if (file_exists($this->file_xml))
			{
				$this->obj_xml = new NBXML($this->file_xml, 0, TRUE, '', FALSE);
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_OPENED';
			}
		}

/*
======================================================================================
	METHODS
======================================================================================
*/
		public function flag_error()
		{
			return($this->flag_error);
		}

		public function flag_i18n()
		{
			return($this->flag_i18n);
		}

		public function savetofile()
		{
			if( !($this->obj_xml->asXML($this->file_xml)) )
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
			}
		}

		public function get_autoinc()
		{
			return( (int) $this->obj_xml['autoinc'] );
		}

		private function set_autoinc($value = 0)
		{
			$this->obj_xml['autoinc'] = $value + $this->get_autoinc();
		}

		// return boolean
		// TRUE		- exist
		// FALSE		- not exist
		public function exist($id)
		{
			return( $this->obj_xml->xpath('/categories/category[@id='.$id.']') != array() );
		}

		public function add($name, $description)
		{
			$tmp_node = $this->obj_xml->xpath('/categories/category[@name="'.$name.'"]');

			if( $tmp_node == array() )
			{
				$new_node = $this->obj_xml->ADD_Element('category','');
				$new_node->addAttribute('id', $this->get_autoinc());
				$new_node->addAttribute('name', $this->html2text($name) );
				$new_node->ADD_Element('description', $this->html2text($description) );
				$this->set_autoinc(1);
			}
		}

		public function get_all()
		{
			$tmp_array = array();
			foreach( $this->obj_xml->children() as $children )
			{
				$row						= array();
				$row['id']				= (int) $children->attributes()->id;
				$row['name']			= (string) utf8_decode($children->attributes()->name);
				$row['description']	= (string) utf8_decode($children->description);

				array_push($tmp_array, $row);
			}
			return( $tmp_array );
		}

		public function get($id)
		{
			$tmp_node = $this->obj_xml->xpath('/categories/category[@id="'.$id.'"]');
			$tmp_array = array();			

			if( $tmp_node != array() )
			{
				$tmp_array['id'] 				= $id;
				$tmp_array['name'] 			= (string) utf8_decode($tmp_node[0]->attributes()->name);
				$tmp_array['description']	= (string) utf8_decode($tmp_node[0]->description);
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'CATEGORY_NOT_FOUND';
			}
			
			return( $tmp_array );
		}

		public function get_id($name)
		{	
			$tmp_node = $this->obj_xml->xpath('/categories/category[@name="'.utf8_encode($name).'"]');

			if( $tmp_node != array() )
			{
				return( (int) $tmp_node[0]->attributes()->id );
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'CATEGORY_NOT_FOUND';
				return(-1);
			}
		}

		public function set($id, $name, $description)
		{
			$tmp_node = $this->obj_xml->xpath('/categories/category[@id="'.$id.'"]');
					
			if( $tmp_node != array() )
			{
				$tmp_node[0]->attributes()->name	= utf8_encode($this->html2text($name));
				$tmp_node[0]->description			= utf8_encode($this->html2text($description));
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'CATEGORY_NOT_FOUND';
			}
		}
			
		public function get_count()
		{
			return( count( $this->obj_xml ) );
		}
			
		public function get_post_count($id)
		{
			return( count($this->ls(PATH_POSTS, '*.'.$id.'.*.*.*.*.*.*.*.*', 'xml', false, false, false)) );
		}
				
		function delete($id)
		{
			$tmp_node = $this->obj_xml->xpath('/categories/category[@id="'.$id.'"]');
			
			if( $tmp_node != array() )
			{
				// Need at least 1 category
				if( $this->get_count() > 0 )
				{
					// Don't have any post linked
					if( $this->get_post_count($id) == 0)
					{
						$dom = dom_import_simplexml($tmp_node[0]);
						$dom->parentNode->removeChild($dom);
					}
					else
					{
						$this->flag_error = true;
						$this->flag_i18n = 'CATEGORY_HAS_ONE_OR_MORE_POST';
					}
				}
				else
				{
					$this->flag_error = true;
					$this->flag_i18n = 'AT_LEAST_ONE_CATEGORY';					
				}
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'CATEGORY_NOT_FOUND';
			}
		}

} // END Class

?>
