/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.DataSourceReferencePanel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.ServiceLocatorStrategyPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SelectDatabasePanel
extends JPanel {
    public static final String IS_VALID = "SelectDatabasePanel_isValid";
    protected static final String PROTOTYPE_VALUE = "jdbc:pointbase://localhost/sample [pbpublic on PBPUBLIC] ";
    private final ServiceLocatorStrategyPanel slPanel;
    private final J2eeModuleProvider provider;
    private final Map<String, Datasource> references;
    private final Set<Datasource> moduleDatasources;
    private final Set<Datasource> serverDatasources;
    private boolean copyDataSourceToProject = false;
    private JButton buttonAdd;
    private JComboBox dsRefCombo;
    private JLabel dsRefLabel;
    private JLabel errorLabel;
    private JPanel serviceLocatorPanel;

    public SelectDatabasePanel(J2eeModuleProvider provider, String lastLocator, Map<String, Datasource> references, Set<Datasource> moduleDatasources, Set<Datasource> serverDatasources, ClasspathInfo cpInfo) {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectDatabasePanel.class, (String)"ACSD_ChooseDatabase"));
        this.provider = provider;
        this.references = references;
        this.moduleDatasources = moduleDatasources;
        this.serverDatasources = serverDatasources;
        this.dsRefCombo.setRenderer(new ReferenceListCellRenderer());
        this.dsRefCombo.setPrototypeDisplayValue(PROTOTYPE_VALUE);
        this.populateReferences();
        this.dsRefCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectDatabasePanel.this.checkDatasourceReference();
            }
        });
        this.slPanel = new ServiceLocatorStrategyPanel(lastLocator, cpInfo);
        this.serviceLocatorPanel.add((Component)this.slPanel, "Center");
        this.slPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("ServiceLocatorStrategyPanel_isValid") && (newvalue = evt.getNewValue()) instanceof Boolean) {
                    boolean isServiceLocatorOk = (Boolean)newvalue;
                    if (isServiceLocatorOk) {
                        SelectDatabasePanel.this.checkDatasourceReference();
                    } else {
                        SelectDatabasePanel.this.firePropertyChange(SelectDatabasePanel.IS_VALID, true, false);
                    }
                }
            }
        });
        if (Util.isValidServerInstance((J2eeModuleProvider)provider)) {
            this.errorLabel.setVisible(false);
        } else {
            this.errorLabel.setVisible(true);
            this.errorLabel.setText(NbBundle.getMessage(SelectDatabasePanel.class, (String)"ERR_MissingServer"));
        }
    }

    public String getDatasourceReference() {
        return (String)this.dsRefCombo.getSelectedItem();
    }

    public String getServiceLocator() {
        return this.slPanel.classSelected();
    }

    public boolean createServerResources() {
        return this.copyDataSourceToProject;
    }

    public Datasource getDatasource() {
        return this.references.get(this.getDatasourceReference());
    }

    private void initComponents() {
        this.dsRefLabel = new JLabel();
        this.serviceLocatorPanel = new JPanel();
        this.dsRefCombo = new JComboBox();
        this.buttonAdd = new JButton();
        this.errorLabel = new JLabel();
        this.dsRefLabel.setDisplayedMnemonic(NbBundle.getMessage(SelectDatabasePanel.class, (String)"LBL_ConnectionMnemonic").charAt(0));
        this.dsRefLabel.setLabelFor(this.dsRefCombo);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.dsRefLabel, (String)bundle.getString("LBL_DsReference"));
        this.serviceLocatorPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.buttonAdd, (String)NbBundle.getMessage(SelectDatabasePanel.class, (String)"LBL_Add"));
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectDatabasePanel.this.buttonAddActionPerformed(evt);
            }
        });
        this.errorLabel.setForeground(new Color(255, 0, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.dsRefLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dsRefCombo, 0, 393, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAdd)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.serviceLocatorPanel, -1, 522, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.errorLabel, -1, 522, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dsRefLabel).addComponent(this.dsRefCombo, -2, -1, -2).addComponent(this.buttonAdd)).addGap(26, 26, 26).addComponent(this.serviceLocatorPanel, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel, -1, 24, Short.MAX_VALUE).addContainerGap()));
        this.dsRefLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectDatabasePanel.class, (String)"LBL_DsReference"));
        this.dsRefLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectDatabasePanel.class, (String)"ACSD_DsReference"));
        this.dsRefCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectDatabasePanel.class, (String)"LBL_DsReference"));
        this.dsRefCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectDatabasePanel.class, (String)"ACSD_DsRefCombo"));
        this.buttonAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectDatabasePanel.class, (String)"ACSD_AddDataSourceRef"));
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        DataSourceReferencePanel referencePanel = new DataSourceReferencePanel(this.provider, this.references.keySet(), this.moduleDatasources, this.serverDatasources);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)referencePanel, NbBundle.getMessage(SelectDatabasePanel.class, (String)"LBL_AddDataSourceReference"), true, 2, DialogDescriptor.OK_OPTION, 0, HelpCtx.DEFAULT_HELP, null);
        NotificationLineSupport statusLine = dialogDescriptor.createNotificationLineSupport();
        referencePanel.setNotificationLine(statusLine);
        referencePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (DataSourceReferencePanel.IS_VALID.equals(evt.getPropertyName()) && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    dialogDescriptor.setValid(((Boolean)newvalue).booleanValue());
                }
            }
        });
        dialogDescriptor.setValid(false);
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (option == NotifyDescriptor.OK_OPTION) {
            final String refName = referencePanel.getReferenceName();
            this.references.put(refName, referencePanel.getDataSource());
            if (referencePanel.copyDataSourceToProject()) {
                // empty if block
            }
            this.copyDataSourceToProject = referencePanel.copyDataSourceToProject();
            this.populateReferences();
            this.dsRefCombo.setSelectedItem(refName);
            boolean selectItemLater = false;
            if (selectItemLater) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectDatabasePanel.this.dsRefCombo.setSelectedItem(refName);
                    }
                });
            }
        }
    }

    protected void checkDatasourceReference() {
        if (this.dsRefCombo.getSelectedItem() instanceof String) {
            this.firePropertyChange(IS_VALID, false, true);
        } else {
            this.firePropertyChange(IS_VALID, true, false);
        }
    }

    private void populateReferences() {
        TreeSet<String> refNames = new TreeSet<String>(this.references.keySet());
        this.dsRefCombo.removeAllItems();
        for (String s : refNames) {
            this.dsRefCombo.addItem(s);
        }
    }

    private class ReferenceListCellRenderer
    extends DefaultListCellRenderer {
        private ReferenceListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof String) {
                String refName = (String)value;
                Datasource ds = (Datasource)SelectDatabasePanel.this.references.get(refName);
                StringBuilder sb = new StringBuilder(refName);
                if (ds != null) {
                    sb.append(" [");
                    sb.append(ds.getUrl());
                    sb.append("] ");
                }
                this.setText(sb.toString());
            } else {
                this.setText(value != null ? value.toString() : "");
            }
            this.setToolTipText("");
            return this;
        }
    }
}

