/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodPermission;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public final class EjbViewController {
    private final String ejbClass;
    private final EjbJar ejbModule;
    private String displayName;
    private ClasspathInfo cpInfo;

    public EjbViewController(String ejbClass, EjbJar ejbModule) {
        this.ejbClass = ejbClass;
        this.ejbModule = ejbModule;
        FileObject[] javaSources = ejbModule.getJavaSources();
        if (javaSources.length > 0) {
            this.cpInfo = ClasspathInfo.create((ClassPath)ClassPath.getClassPath((FileObject)javaSources[0], (String)"classpath/boot"), (ClassPath)ClassPath.getClassPath((FileObject)javaSources[0], (String)"classpath/compile"), (ClassPath)ClassPath.getClassPath((FileObject)javaSources[0], (String)"classpath/source"));
        }
    }

    public String getDisplayName() {
        try {
            this.displayName = (String)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata metadata) throws IOException {
                    Ejb ejb = metadata.findByEjbClass(EjbViewController.this.ejbClass);
                    if (ejb == null) {
                        return null;
                    }
                    String name = ejb.getDefaultDisplayName();
                    if (name == null) {
                        name = ejb.getEjbName();
                    }
                    return name;
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return this.displayName;
    }

    public void delete(boolean deleteClasses) throws IOException {
        boolean isEE5orEE6;
        Profile profile = this.ejbModule.getJ2eeProfile();
        boolean bl = isEE5orEE6 = Profile.JAVA_EE_5.equals(profile) || Profile.JAVA_EE_6_FULL.equals(profile) || Profile.JAVA_EE_6_WEB.equals(profile);
        if (!isEE5orEE6) {
            this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                public Void run(EjbJarMetadata metadata) throws Exception {
                    org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = metadata.getRoot();
                    EnterpriseBeans beans = ejbJar.getEnterpriseBeans();
                    return null;
                }
            });
            this.writeDD();
            if (deleteClasses) {
                this.deleteClasses();
            }
        } else {
            this.deleteClasses();
        }
    }

    public EjbReference createEjbReference() throws IOException {
        Map ejbInfo = (Map)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Map<String, String>>(){

            public Map<String, String> run(EjbJarMetadata metadata) throws Exception {
                EntityAndSession ejb = (EntityAndSession)metadata.findByEjbClass(EjbViewController.this.ejbClass);
                HashMap<String, String> result = new HashMap<String, String>();
                if (ejb != null) {
                    result.put("EjbName", ejb.getEjbName());
                    result.put("EjbRefType", ejb instanceof Entity ? "Entity" : "Session");
                    result.put("Local", ejb.getLocal());
                    result.put("LocalHome", ejb.getLocalHome());
                    result.put("Remote", ejb.getRemote());
                    result.put("Home", ejb.getHome());
                }
                return result;
            }
        });
        return EjbReference.create((String)this.ejbClass, (String)((String)ejbInfo.get("EjbRefType")), (String)((String)ejbInfo.get("Local")), (String)((String)ejbInfo.get("LocalHome")), (String)((String)ejbInfo.get("Remote")), (String)((String)ejbInfo.get("Home")), (EjbJar)this.ejbModule);
    }

    public String getEjbClass() {
        return this.ejbClass;
    }

    public EjbJar getEjbModule() {
        return this.ejbModule;
    }

    public ClasspathInfo getClasspathInfo() {
        return this.cpInfo;
    }

    public DataObject getBeanDo() {
        return this.getDataObject(this.ejbClass);
    }

    public FileObject getBeanFo() {
        return this.findFileObject(this.ejbClass);
    }

    public DataObject getDataObject(String className) {
        FileObject src = this.findFileObject(className);
        try {
            if (src != null) {
                return DataObject.find((FileObject)src);
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public ElementHandle<TypeElement> getBeanClass() {
        return this.getBeanClass(this.ejbClass);
    }

    public ElementHandle<TypeElement> getBeanClass(String qualifiedClassName) {
        Set elementHandles = this.cpInfo.getClassIndex().getDeclaredTypes(this.getSimpleName(qualifiedClassName), ClassIndex.NameKind.SIMPLE_NAME, Collections.singleton(ClassIndex.SearchScope.SOURCE));
        for (ElementHandle elementHandle : elementHandles) {
            if (!qualifiedClassName.equals(elementHandle.getQualifiedName())) continue;
            return elementHandle;
        }
        return null;
    }

    public String getRemoteStringRepresentation(final String ejbType) {
        String result = null;
        try {
            result = (String)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata metadata) throws IOException {
                    Ejb ejb = metadata.findByEjbClass(EjbViewController.this.ejbClass);
                    if (ejb == null) {
                        return null;
                    }
                    assert (ejb instanceof EntityAndSession);
                    EntityAndSession refModel = (EntityAndSession)ejb;
                    return "\t<ejb-ref>\n\t\t<ejb-ref-name>ejb/" + ejb.getEjbName() + "</ejb-ref-name>\n" + "\t\t<ejb-ref-type>" + ejbType + "</ejb-ref-type>\n" + "\t\t<home>" + refModel.getHome() + "</home>\n" + "\t\t<remote>" + refModel.getRemote() + "</remote>\n" + "\t</ejb-ref>\n";
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result;
    }

    public String getLocalStringRepresentation(final String ejbType) {
        String result = null;
        try {
            result = (String)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata metadata) throws IOException {
                    Ejb ejb = metadata.findByEjbClass(EjbViewController.this.ejbClass);
                    if (ejb == null) {
                        return null;
                    }
                    assert (ejb instanceof EntityAndSession);
                    EntityAndSession refModel = (EntityAndSession)ejb;
                    return "\t<ejb-local-ref>\n\t\t<ejb-ref-name>ejb/" + ejb.getEjbName() + "</ejb-ref-name>\n" + "\t\t<ejb-ref-type>" + ejbType + "</ejb-ref-type>\n" + "\t\t<local-home>" + refModel.getLocalHome() + "</local-home>\n" + "\t\t<local>" + refModel.getLocal() + "</local>\n" + "\t</ejb-local-ref>\n";
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result;
    }

    private String getSimpleName(String qualifiedClassName) {
        int beginIndex = qualifiedClassName.lastIndexOf(46) + 1;
        return qualifiedClassName.substring(beginIndex);
    }

    private void writeDD() throws IOException {
        FileObject ddFile = this.ejbModule.getDeploymentDescriptor();
        DDProvider.getDefault().getDDRoot(ddFile).write(ddFile);
    }

    private boolean isEjbUsed(EjbRelationshipRole role, String ejbName) {
        return role != null && role.getRelationshipRoleSource() != null && ejbName.equals(role.getRelationshipRoleSource().getEjbName());
    }

    private void deleteRelationships(String ejbName, org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar) {
        EjbRelation[] relations;
        Relationships relationships = ejbJar.getSingleRelationships();
        if (relationships != null && (relations = relationships.getEjbRelation()) != null) {
            for (EjbRelation ejbRelation : relations) {
                if (!this.isEjbUsed(ejbRelation.getEjbRelationshipRole(), ejbName) && !this.isEjbUsed(ejbRelation.getEjbRelationshipRole2(), ejbName)) continue;
                relationships.removeEjbRelation(ejbRelation);
            }
            if (relationships.sizeEjbRelation() == 0) {
                ejbJar.setRelationships(null);
            }
        }
    }

    private void deleteTraces(Ejb ejb, org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar) {
        String ejbName = ejb.getEjbName();
        String ejbNameCompare = ejbName + "";
        this.deleteRelationships(ejbName, ejbJar);
        AssemblyDescriptor assemblyDescriptor = ejbJar.getSingleAssemblyDescriptor();
        if (assemblyDescriptor != null) {
            ContainerTransaction[] containerTransactions;
            for (ContainerTransaction containerTransaction : containerTransactions = assemblyDescriptor.getContainerTransaction()) {
                Method[] methods = containerTransaction.getMethod();
                for (Method method : methods = methods == null ? new Method[]{} : methods) {
                    if (!ejbNameCompare.equals(method.getEjbName())) continue;
                    containerTransaction.removeMethod(method);
                    if (containerTransaction.sizeMethod() != 0) continue;
                    assemblyDescriptor.removeContainerTransaction(containerTransaction);
                }
            }
            MethodPermission[] permissions = assemblyDescriptor.getMethodPermission();
            for (int i = 0; i < permissions.length; ++i) {
                Method[] methods = permissions[i].getMethod();
                methods = methods == null ? new Method[]{} : methods;
                for (int method = 0; method < methods.length; ++method) {
                    if (!ejbNameCompare.equals(methods[method].getEjbName())) continue;
                    permissions[i].removeMethod(methods[method]);
                    if (permissions[i].sizeMethod() != 0) continue;
                    assemblyDescriptor.removeMethodPermission(permissions[i]);
                }
            }
        }
    }

    private FileObject findFileObject(String className) {
        ElementHandle<TypeElement> beanEH = this.getBeanClass(className);
        if (beanEH != null) {
            return SourceUtils.getFile(beanEH, (ClasspathInfo)this.cpInfo);
        }
        return null;
    }

    private void deleteClasses() {
        final ArrayList classFileObjects = new ArrayList();
        try {
            this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                public Void run(EjbJarMetadata metadata) throws Exception {
                    classFileObjects.add(metadata.findResource(EjbViewController.this.ejbClass));
                    Ejb ejb = metadata.findByEjbClass(EjbViewController.this.ejbClass);
                    if (ejb instanceof EntityAndSession) {
                        EntityAndSession entityAndSessionfModel = (EntityAndSession)ejb;
                        if (entityAndSessionfModel.getLocalHome() != null) {
                            classFileObjects.add(metadata.findResource(entityAndSessionfModel.getLocalHome()));
                            classFileObjects.add(metadata.findResource(entityAndSessionfModel.getLocal()));
                            classFileObjects.add(metadata.findResource(entityAndSessionfModel.getLocal() + "Business"));
                        }
                        if (entityAndSessionfModel.getHome() != null) {
                            classFileObjects.add(metadata.findResource(entityAndSessionfModel.getHome()));
                            classFileObjects.add(metadata.findResource(entityAndSessionfModel.getRemote()));
                            classFileObjects.add(metadata.findResource(entityAndSessionfModel.getRemote() + "Business"));
                        }
                    }
                    return null;
                }
            });
            for (FileObject fileObject : classFileObjects) {
                if (fileObject == null) continue;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                assert (dataObject != null) : "cannot find DataObject for " + fileObject.getPath();
                if (dataObject == null) continue;
                dataObject.delete();
            }
        }
        catch (IOException ioe) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)ioe));
        }
    }
}

