/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.NbBundle;

public final class TimerOptions {
    private Map<String, String> timerOptions = new HashMap<String, String>();
    private static Set<String> scheduleAttributes = new HashSet<String>(Arrays.asList("second", "minute", "hour", "dayOfMonth", "month", "dayOfWeek", "year", "info", "persistent", "timezone"));

    public Map<String, String> getTimerOptionsAsMap() {
        return this.timerOptions;
    }

    public void setTimerOptions(String scheduleString) {
        if (TimerOptions.validate(scheduleString) == null) {
            String[] sections = TimerOptions.splitScheduleSections(TimerOptions.omitNewLines(scheduleString));
            TimerOptions.parseSectionsIntoMap(sections, this.timerOptions);
        }
    }

    public static String validate(String scheduleString) {
        HashMap<String, String> actualSchedule;
        String[] sections = TimerOptions.splitScheduleSections(TimerOptions.omitNewLines(scheduleString));
        if (!TimerOptions.parseSectionsIntoMap(sections, actualSchedule = new HashMap<String, String>())) {
            return NbBundle.getMessage(TimerOptions.class, (String)"ERR_TO_UnparsableSchedule");
        }
        if (actualSchedule.isEmpty()) {
            return NbBundle.getMessage(TimerOptions.class, (String)"ERR_TO_NotEnoughAttributes");
        }
        if (actualSchedule.size() > 10) {
            return NbBundle.getMessage(TimerOptions.class, (String)"ERR_TO_ToMuchAttributes");
        }
        String invalidAttributesString = TimerOptions.invalidAttributes(actualSchedule.keySet());
        if (invalidAttributesString != null) {
            return NbBundle.getMessage(TimerOptions.class, (String)"ERR_TO_InvalidAtributes", (Object)invalidAttributesString);
        }
        return null;
    }

    private static String omitNewLines(String string) {
        return string.replaceAll("\n", "");
    }

    private static String[] splitScheduleSections(String scheduleValue) {
        String[] sections = scheduleValue.split(",");
        ArrayList<String> finalSections = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sections.length; ++i) {
            sb.append(sections[i]);
            if (TimerOptions.getCountOfQuotes(sb.toString()) < 2) {
                sb.append(",");
                continue;
            }
            finalSections.add(sb.toString());
            sb = new StringBuilder();
        }
        if (!"".equals(sb.toString())) {
            finalSections.add(sb.toString());
        }
        return finalSections.toArray(new String[finalSections.size()]);
    }

    private static int getCountOfQuotes(String string) {
        int count = string.split("\"").length - 1;
        if (string.endsWith("\"") || string.startsWith("\"")) {
            return count + 1;
        }
        return count;
    }

    private static boolean parseSectionsIntoMap(String[] sections, Map<String, String> map) {
        for (String section : sections) {
            String[] row = section.split("=");
            if (row.length != 2) {
                return false;
            }
            map.put(row[0].trim(), row[1].trim().replaceAll("\"", ""));
        }
        return true;
    }

    private static String invalidAttributes(Set<String> actualAttributes) {
        HashSet<String> copy = new HashSet<String>(actualAttributes);
        copy.removeAll(scheduleAttributes);
        if (copy.isEmpty()) {
            return null;
        }
        StringBuilder invalidAttributes = new StringBuilder();
        for (String attribute : copy) {
            invalidAttributes.append(attribute).append(", ");
        }
        return invalidAttributes.substring(0, invalidAttributes.length() - 2);
    }
}

