/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.core.browser.api.EmbeddedBrowserFactory;
import org.netbeans.core.browser.api.WebBrowser;
import org.netbeans.modules.css.visual.api.CssPreviewComponent;
import org.netbeans.modules.css.visual.api.CssPreviewComponentFactory;
import org.netbeans.modules.css.visual.api.CssPreviewComponentListener;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.xml.sax.InputSource;

public class CssWebPreviewPanel
extends JPanel
implements CssPreviewComponent {
    private WebBrowser browser;
    private FileFilter filter = new HTMLFileFilter();
    private Map<String, File> urlToFile = new HashMap<String, File>();
    private String currentUrl;
    private boolean browserDisposed = false;
    private JButton browseButton;
    private JLabel filenameLabel;
    private JPanel jPanel1;

    public CssWebPreviewPanel() {
        this.initComponents();
        if (EmbeddedBrowserFactory.getDefault().isEnabled()) {
            this.browser = EmbeddedBrowserFactory.getDefault().createEmbeddedBrowser();
            this.add(this.browser.getComponent(), "Center");
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.browseButton = new JButton();
        this.filenameLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.browseButton.setText(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"CssWebPreviewPanel.browseButton.text"));
        this.browseButton.setToolTipText(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"DifferentPreviewFile_Tooltip"));
        this.browseButton.setMargin(new Insets(2, 4, 2, 4));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CssWebPreviewPanel.this.browseButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.browseButton, gridBagConstraints);
        this.filenameLabel.setText(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"CssWebPreviewPanel.filenameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.filenameLabel, gridBagConstraints);
        this.add((Component)this.jPanel1, "North");
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"WebPreviewChooserTitle"));
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(this.filter);
        if (0 == chooser.showOpenDialog(this)) {
            File previewFile = chooser.getSelectedFile();
            try {
                if (previewFile.exists() && previewFile.isFile()) {
                    this.urlToFile.put(this.currentUrl, previewFile);
                    String urlString = previewFile.toURI().toURL().toExternalForm();
                    this.browser.setURL(urlString);
                    this.filenameLabel.setText(previewFile.getName());
                    this.filenameLabel.setToolTipText(urlString);
                }
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public void setDocument(InputSource is, String url) throws Exception {
        this.currentUrl = url;
        if (this.browser == null) {
            return;
        }
        File file = this.urlToFile.get(url);
        if (file != null) {
            String urlString = file.toURI().toURL().toExternalForm();
            this.browser.setURL(urlString);
            this.filenameLabel.setText(file.getName());
            this.filenameLabel.setToolTipText(urlString);
            return;
        }
        this.browser.setContent(this.getContentFromReader(is.getCharacterStream()));
        this.filenameLabel.setText(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"FileNameLabelText"));
        this.filenameLabel.setToolTipText(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"FileNameLabelTooltip"));
    }

    @Override
    public JComponent getComponent() {
        if ((this.browserDisposed || this.browser == null) && EmbeddedBrowserFactory.getDefault().isEnabled()) {
            this.browser = EmbeddedBrowserFactory.getDefault().createEmbeddedBrowser();
            this.add(this.browser.getComponent(), "Center");
            this.revalidate();
            this.repaint();
            this.browserDisposed = false;
        }
        return this;
    }

    @Override
    public void dispose() {
        this.browserDisposed = true;
        this.browser.dispose();
    }

    private String getContentFromReader(Reader reader) throws IOException {
        StringBuilder strBuff = new StringBuilder();
        char[] buffer = new char[2048];
        int read = 0;
        while ((read = reader.read(buffer)) != -1) {
            strBuff.append(buffer, 0, read);
        }
        return strBuff.toString();
    }

    @Override
    public void addListener(CssPreviewComponentListener listener) {
    }

    @Override
    public void removeListener(CssPreviewComponentListener listener) {
    }

    class HTMLFileFilter
    extends FileFilter {
        HTMLFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.toString().endsWith("html") || pathname.toString().endsWith("xhtml");
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(CssWebPreviewPanel.class, (String)"WebPreviewFileFilterDesc");
        }
    }

    public static class Factory
    implements CssPreviewComponentFactory {
        PropertyChangeSupport support = new PropertyChangeSupport(this);

        public Factory() {
            EmbeddedBrowserFactory.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Factory.this.support.firePropertyChange(EmbeddedBrowserFactory.getDefault().isEnabled() ? "enabled" : "disabled", null, null);
                }
            });
        }

        @Override
        public CssPreviewComponent createCssPreviewComponent() {
            return EmbeddedBrowserFactory.getDefault().isEnabled() ? new CssWebPreviewPanel() : null;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.support.removePropertyChangeListener(l);
            this.support.addPropertyChangeListener(l);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.support.removePropertyChangeListener(l);
        }
    }
}

