/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.api.customization.model.JAXWSQName;
import org.netbeans.modules.websvc.api.customization.model.JavaMethod;
import org.netbeans.modules.websvc.api.customization.model.PortCustomization;
import org.netbeans.modules.websvc.api.customization.model.Provider;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.customization.multiview.ExternalBindingTablePanel;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PortPanel
extends SaveableSectionInnerPanel {
    private Port port;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener defaultListener;
    private ProviderActionListener providerActionListener;
    private Node node;
    private JCheckBox defaultMethodCB;
    private JLabel portAccessLabel;
    private JTextField portAccessMethodText;
    private JCheckBox providerCB;
    private JLabel serviceLabel;
    private JLabel serviceName;

    public PortPanel(SectionView sectionView, Port port, Node node) {
        super(sectionView);
        this.port = port;
        this.model = this.port.getModel();
        this.node = node;
        this.initComponents();
        this.disableEnterKey();
        this.sync();
        this.defaultListener = new DefaultItemListener();
        ItemListener itemListener = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.defaultListener, (Object)this.defaultMethodCB);
        this.defaultMethodCB.addItemListener(itemListener);
        if (!this.isClient(node)) {
            this.providerActionListener = new ProviderActionListener();
            ActionListener actionListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.providerActionListener, (Object)this.providerCB);
            this.providerCB.addActionListener(actionListener);
        } else {
            this.providerCB.setVisible(false);
        }
        this.addModifier(this.portAccessMethodText);
        this.addModifier(this.defaultMethodCB);
        this.addValidatee(this.portAccessMethodText);
    }

    private String getParentOfPort(Port port) {
        Service service = (Service)port.getParent();
        return service.getName();
    }

    private void sync() {
        List list = this.port.getExtensibilityElements(PortCustomization.class);
        if (list.size() == 1) {
            PortCustomization portCustomization = (PortCustomization)list.get(0);
            JavaMethod javaMethod = portCustomization.getJavaMethod();
            if (javaMethod != null) {
                this.setPortAccessMethod(javaMethod.getName());
            } else {
                this.defaultMethodCB.setSelected(true);
                this.portAccessMethodText.setEnabled(false);
            }
            Provider provider = portCustomization.getProvider();
            if (provider != null) {
                if (provider.isEnabled()) {
                    this.providerCB.setSelected(true);
                } else {
                    this.providerCB.setSelected(false);
                }
            } else {
                this.providerCB.setSelected(false);
            }
        } else {
            this.providerCB.setSelected(false);
            this.defaultMethodCB.setSelected(true);
            this.portAccessMethodText.setEnabled(false);
        }
    }

    public void setPortAccessMethod(String string) {
        this.portAccessMethodText.setText(string);
    }

    public String getPortAccessMethod() {
        return this.portAccessMethodText.getText();
    }

    public void setProvider(boolean bl) {
        this.providerCB.setSelected(bl);
    }

    public boolean isProvider() {
        return this.providerCB.isSelected();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List list = this.port.getExtensibilityElements(PortCustomization.class);
        if (jComponent == this.providerCB) {
            if (list.size() == 1) {
                PortCustomization portCustomization = (PortCustomization)list.get(0);
                Provider provider = portCustomization.getProvider();
                if (this.isProvider()) {
                    if (provider == null) {
                        try {
                            provider = (Provider)this.model.getFactory().create((WSDLComponent)portCustomization, JAXWSQName.PROVIDER.getQName());
                            this.model.startTransaction();
                            provider.setEnabled(true);
                            portCustomization.setProvider(provider);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                } else if (provider != null) {
                    try {
                        this.model.startTransaction();
                        portCustomization.removeProvider(provider);
                        if (portCustomization.getChildren().size() == 0) {
                            this.port.removeExtensibilityElement((ExtensibilityElement)portCustomization);
                        }
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else if (this.isProvider()) {
                WSDLComponentFactory wSDLComponentFactory = this.model.getFactory();
                PortCustomization portCustomization = (PortCustomization)wSDLComponentFactory.create((WSDLComponent)this.port, JAXWSQName.BINDINGS.getQName());
                Provider provider = (Provider)wSDLComponentFactory.create((WSDLComponent)portCustomization, JAXWSQName.PROVIDER.getQName());
                try {
                    this.model.startTransaction();
                    provider.setEnabled(true);
                    portCustomization.setProvider(provider);
                    this.port.addExtensibilityElement((ExtensibilityElement)portCustomization);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        } else if (jComponent == this.portAccessMethodText || jComponent == this.defaultMethodCB) {
            PortCustomization portCustomization;
            JavaMethod javaMethod;
            String string = this.portAccessMethodText.getText();
            if (string != null && !string.trim().equals("") && !this.defaultMethodCB.isSelected()) {
                if (!JaxWsUtils.isJavaIdentifier((String)string)) {
                    return;
                }
                if (list.size() == 1) {
                    PortCustomization portCustomization2 = (PortCustomization)list.get(0);
                    JavaMethod javaMethod2 = portCustomization2.getJavaMethod();
                    if (javaMethod2 == null) {
                        try {
                            javaMethod2 = (JavaMethod)this.model.getFactory().create((WSDLComponent)portCustomization2, JAXWSQName.METHOD.getQName());
                            this.model.startTransaction();
                            javaMethod2.setName(string);
                            portCustomization2.setJavaMethod(javaMethod2);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    } else {
                        try {
                            this.model.startTransaction();
                            javaMethod2.setName(string);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                } else {
                    WSDLComponentFactory wSDLComponentFactory = this.model.getFactory();
                    PortCustomization portCustomization3 = (PortCustomization)wSDLComponentFactory.create((WSDLComponent)this.port, JAXWSQName.BINDINGS.getQName());
                    JavaMethod javaMethod3 = (JavaMethod)wSDLComponentFactory.create((WSDLComponent)portCustomization3, JAXWSQName.METHOD.getQName());
                    try {
                        this.model.startTransaction();
                        javaMethod3.setName(string);
                        portCustomization3.setJavaMethod(javaMethod3);
                        this.port.addExtensibilityElement((ExtensibilityElement)portCustomization3);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else if (list.size() == 1 && (javaMethod = (portCustomization = (PortCustomization)list.get(0)).getJavaMethod()) != null) {
                try {
                    this.model.startTransaction();
                    portCustomization.removeJavaMethod(javaMethod);
                    if (portCustomization.getChildren().size() == 0) {
                        this.port.removeExtensibilityElement((ExtensibilityElement)portCustomization);
                    }
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        if (jTextComponent == this.portAccessMethodText && !JaxWsUtils.isJavaIdentifier((String)string)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, string, (JComponent)jTextComponent));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (jTextComponent == this.portAccessMethodText) {
            PortCustomization portCustomization;
            JavaMethod javaMethod;
            String string = "";
            List list = this.port.getExtensibilityElements(PortCustomization.class);
            if (list.size() == 1 && (javaMethod = (portCustomization = (PortCustomization)list.get(0)).getJavaMethod()) != null) {
                string = javaMethod.getName();
            }
            this.portAccessMethodText.setText(string);
        }
    }

    @Override
    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    @Override
    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.portAccessLabel = new JLabel();
        this.portAccessMethodText = new JTextField();
        this.providerCB = new JCheckBox();
        this.defaultMethodCB = new JCheckBox();
        this.serviceLabel = new JLabel();
        this.serviceName = new JLabel();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.portAccessLabel.setText(resourceBundle.getString("LBL_PORT_ACCESS_METHOD"));
        this.portAccessMethodText.setToolTipText(resourceBundle.getString("TOOLTIP_GET_PORT"));
        this.providerCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_PROVIDER").charAt(0));
        this.providerCB.setText(resourceBundle.getString("LBL_USE_PROVIDER"));
        this.providerCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.providerCB.setContentAreaFilled(false);
        this.providerCB.setMargin(new Insets(0, 0, 0, 0));
        this.defaultMethodCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultMethodCB.setText(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.defaultMethodCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultMethodCB.setContentAreaFilled(false);
        this.defaultMethodCB.setMargin(new Insets(0, 0, 0, 0));
        this.serviceLabel.setText(resourceBundle.getString("LBL_ENCLOSING_SERVICE"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serviceLabel).addComponent(this.portAccessLabel)).addGap(14, 14, 14).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.portAccessMethodText, -2, 159, -2).addGap(20, 20, 20).addComponent(this.defaultMethodCB)).addComponent(this.serviceName, -2, 182, -2))).addComponent(this.providerCB)).addContainerGap(77, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serviceLabel).addComponent(this.serviceName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 22, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portAccessLabel).addComponent(this.portAccessMethodText, -2, -1, -2).addComponent(this.defaultMethodCB)).addGap(21, 21, 21).addComponent(this.providerCB).addGap(19, 19, 19)));
        this.portAccessLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_PORT_ACCESS_METHOD"));
        this.portAccessMethodText.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_PORT_ACCESS_METHOD"));
        this.portAccessMethodText.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_PORT_ACCESS_METHOD"));
        this.providerCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_USE_PROVIDER"));
        this.providerCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_USE_PROVIDER"));
        this.defaultMethodCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.defaultMethodCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_USE_DEFAULT"));
        this.serviceLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENCLOSING_SERVICE"));
    }

    class ProviderActionListener
    implements ActionListener {
        ProviderActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == PortPanel.this.providerCB) {
                if (PortPanel.this.providerCB.isSelected()) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"WARN_PROVIDER_INTERFACE"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (confirmation.getValue() == NotifyDescriptor.NO_OPTION) {
                        PortPanel.this.providerCB.setSelected(false);
                        return;
                    }
                }
                PortPanel.this.setValue(PortPanel.this.providerCB, null);
            }
        }
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (PortPanel.this.defaultMethodCB.isSelected()) {
                PortPanel.this.portAccessMethodText.setEnabled(false);
            } else {
                PortPanel.this.portAccessMethodText.setEnabled(true);
                PortPanel.this.portAccessMethodText.requestFocus();
            }
        }
    }
}

