/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.classpath;

import java.lang.ref.SoftReference;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.classpath.ProjectClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public class J2MEClassPathProvider
implements ClassPathProvider {
    private SoftReference<ClassPath> ctcp;
    private SoftReference<ClassPath> rtcp;
    private SoftReference<ClassPath> sp;
    private SoftReference<ClassPath> bcp;
    private FileObject srcDir;
    protected final AntProjectHelper helper;

    public J2MEClassPathProvider(AntProjectHelper helpers) {
        this.helper = helpers;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        if (!this.checkSrcParent(file)) {
            return null;
        }
        if (type.equals("classpath/compile")) {
            return this.getCompileTimeClasspath();
        }
        if (type.equals("classpath/execute")) {
            return this.getRunTimeClasspath();
        }
        if (type.equals("classpath/source")) {
            return this.getSourcepath();
        }
        return null;
    }

    public boolean checkSrcParent(FileObject file) {
        String prop;
        if (!(this.srcDir != null && this.srcDir.isValid() || (prop = this.helper.getStandardPropertyEvaluator().getProperty("src.dir")) == null)) {
            this.srcDir = this.helper.resolveFileObject(prop);
        }
        return this.srcDir != null && file != null && (this.srcDir.equals(file) || FileUtil.isParentOf((FileObject)this.srcDir, (FileObject)file));
    }

    public ClassPath getCompileTimeClasspath() {
        ClassPath cp = null;
        if (this.ctcp == null || (cp = this.ctcp.get()) == null) {
            cp = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper){

                @Override
                protected String evaluatePath() {
                    String cp = J2MEProjectUtils.evaluateProperty(J2MEClassPathProvider.this.helper, "libs.classpath");
                    if (cp != null) {
                        cp = J2MEClassPathProvider.this.helper.resolvePath(cp);
                    }
                    return cp;
                }
            });
            this.ctcp = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }

    public ClassPath getRunTimeClasspath() {
        ClassPath cp = null;
        if (this.rtcp == null || (cp = this.rtcp.get()) == null) {
            cp = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper){

                @Override
                protected String evaluatePath() {
                    String cp = J2MEClassPathProvider.this.helper.getStandardPropertyEvaluator().getProperty("build.classes.dir");
                    if (cp != null) {
                        cp = J2MEClassPathProvider.this.helper.resolvePath(cp);
                    }
                    return cp;
                }
            });
            this.rtcp = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }

    public ClassPath getSourcepath() {
        ClassPath cp = null;
        if (this.sp == null || (cp = this.sp.get()) == null) {
            cp = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper){

                @Override
                protected String evaluatePath() {
                    String cp = J2MEClassPathProvider.this.helper.getStandardPropertyEvaluator().getProperty("src.dir");
                    if (cp != null) {
                        cp = J2MEClassPathProvider.this.helper.resolvePath(cp);
                    }
                    return cp;
                }
            });
            this.sp = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }

    public ClassPath getBootClassPath() {
        ClassPath cp = null;
        if (this.bcp == null || (cp = this.bcp.get()) == null) {
            cp = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectBootClassPathImplementation());
            this.bcp = new SoftReference<ClassPath>(cp);
        }
        return cp;
    }

    private class ProjectBootClassPathImplementation
    extends ProjectClassPathImplementation
    implements ChangeListener {
        public ProjectBootClassPathImplementation() {
            super(J2MEClassPathProvider.this.helper);
            PropertyProvider provider = PropertyUtils.globalPropertyProvider();
            provider.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)provider));
        }

        @Override
        protected String evaluatePath() {
            int i;
            String platform = J2MEProjectUtils.evaluateProperty(J2MEClassPathProvider.this.helper, "platform.active");
            if (platform == null) {
                return null;
            }
            platform = J2MEClassPathProvider.this.helper.getStandardPropertyEvaluator().getProperty("platforms." + platform + ".home");
            String cp = J2MEProjectUtils.evaluateProperty(J2MEClassPathProvider.this.helper, "platform.bootclasspath");
            if (platform == null || cp == null) {
                return null;
            }
            while ((i = cp.indexOf("${platform.home}")) >= 0) {
                cp = cp.substring(0, i) + platform + cp.substring(i + 16);
            }
            return cp == null ? null : J2MEClassPathProvider.this.helper.resolvePath(cp);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.propertiesChanged(null);
        }
    }
}

