/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync.download;

import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;

class FileDownloadInfo {
    public static final Object LOCK = new Object();
    private State state;
    private final File localFile;
    private final String remoteFile;
    private final ExecutionEnvironment env;
    private Future<Integer> copyTask;

    public FileDownloadInfo(File localFile, String remoteFile, ExecutionEnvironment env) {
        this.localFile = localFile;
        this.remoteFile = remoteFile;
        this.env = env;
        this.state = State.UNCONFIRMED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() {
        Object object = LOCK;
        synchronized (object) {
            this.state = State.COPYING;
            if (this.copyTask != null) {
                this.copyTask.cancel(true);
            }
            this.localFile.getParentFile().mkdirs();
            this.copyTask = CommonTasksSupport.downloadFile((String)this.remoteFile, (ExecutionEnvironment)this.env, (String)this.localFile.getAbsolutePath(), null);
        }
        try {
            int rc = this.copyTask.get();
            Object object2 = LOCK;
            synchronized (object2) {
                this.state = rc == 0 ? State.DONE : State.ERROR;
            }
        }
        catch (InterruptedException ex) {
            Object object3 = LOCK;
            synchronized (object3) {
                this.state = State.CANCELLED;
            }
        }
        catch (ExecutionException ex) {
            Object object4 = LOCK;
            synchronized (object4) {
                this.state = State.ERROR;
            }
        }
        finally {
            Object ex = LOCK;
            synchronized (ex) {
                this.copyTask = null;
            }
        }
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void cancel() {
        Future<Integer> task = this.copyTask;
        if (task != null) {
            task.cancel(true);
        }
        this.state = State.CANCELLED;
    }

    public State getState() {
        return this.state;
    }

    public void reset() {
        this.cancel();
        this.state = State.UNCONFIRMED;
    }

    public void confirm() {
        this.state = State.PENDING;
    }

    public void reject() {
        this.state = State.CANCELLED;
    }

    public String toString() {
        return this.localFile.getPath() + ' ' + (Object)((Object)this.state) + ' ' + this.env + ' ' + this.remoteFile;
    }

    public static enum State {
        UNCONFIRMED,
        CONFIRMED,
        PENDING,
        COPYING,
        CANCELLED,
        DONE,
        ERROR;

    }
}

