/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public class RemoteProjectSupport {
    private RemoteProjectSupport() {
    }

    public static ExecutionEnvironment getExecutionEnvironment(Project project) {
        MakeConfiguration mk = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        if (mk != null) {
            return mk.getDevelopmentHost().getExecutionEnvironment();
        }
        return null;
    }

    public static boolean projectExists(Project project) {
        FileObject nbprojectFO;
        FileObject projDirFO = project.getProjectDirectory();
        return projDirFO != null && projDirFO.isValid() && (nbprojectFO = projDirFO.getFileObject("nbproject")) != null && nbprojectFO.isValid();
    }

    public static File getPrivateStorage(Project project) {
        File baseDir = CndFileUtils.toFile((FileObject)project.getProjectDirectory());
        if (baseDir == null) {
            return null;
        }
        baseDir = baseDir.getAbsoluteFile();
        File privProjectStorage = CndFileUtils.createLocalFile((File)new File(baseDir, "nbproject"), (String)"private");
        return privProjectStorage;
    }

    public static File[] getProjectSourceDirs(Project project, AtomicReference<String> runDir) {
        MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        if (conf == null) {
            File baseDir = CndFileUtils.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
            return new File[]{baseDir};
        }
        return RemoteProjectSupport.getProjectSourceDirs(project, conf, runDir);
    }

    public static File[] getProjectSourceDirs(Project project, MakeConfiguration conf, AtomicReference<String> runDir) {
        MakeConfigurationDescriptor mcs;
        File baseDir = CndFileUtils.toFile((FileObject)project.getProjectDirectory());
        if (baseDir == null) {
            return new File[0];
        }
        baseDir = baseDir.getAbsoluteFile();
        if (conf == null) {
            return new File[]{baseDir};
        }
        if (runDir != null) {
            String d = conf.getMakefileConfiguration().getBuildCommandWorkingDirValue();
            FileSystem fs = conf.getBaseFSPath().getFileSystem();
            if (!CndPathUtilitities.isPathAbsolute((CharSequence)d)) {
                d = conf.getBaseFSPath().getPath() + FileSystemProvider.getFileSeparatorChar((FileSystem)fs) + d;
            }
            d = FileSystemProvider.normalizeAbsolutePath((String)d, (FileSystem)fs);
            runDir.set(d);
        }
        HashSet<File> sourceFilesAndDirs = new HashSet<File>();
        if (!conf.isMakefileConfiguration()) {
            sourceFilesAndDirs.add(baseDir);
        }
        if ((mcs = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Project)project)) == null) {
            return new File[0];
        }
        if (FileUtil.toFile((FileObject)mcs.getBaseDirFileObject()) == null) {
            return sourceFilesAndDirs.toArray(new File[sourceFilesAndDirs.size()]);
        }
        for (String soorceRoot : mcs.getSourceRoots()) {
            String path = CndPathUtilitities.toAbsolutePath((String)baseDir.getAbsolutePath(), (String)soorceRoot);
            File file = CndFileUtils.createLocalFile((String)path);
            sourceFilesAndDirs.add(file);
        }
        RemoteProjectSupport.addExtraFiles(mcs, sourceFilesAndDirs);
        ArrayList<Project> subProjects = new ArrayList<Project>(conf.getSubProjects());
        for (LibraryItem.ProjectItem requiredProject : conf.getRequiredProjectsConfiguration().getValue()) {
            Project p = requiredProject.getProject(conf.getBaseFSPath());
            if (p == null) continue;
            subProjects.add(p);
        }
        for (Project subProject : subProjects) {
            File projectDirFile = FileUtil.toFile((FileObject)subProject.getProjectDirectory());
            if (projectDirFile != null) {
                sourceFilesAndDirs.add(projectDirFile);
            }
            MakeConfigurationDescriptor subMcs = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Project)subProject);
            for (String soorceRoot : mcs.getSourceRoots()) {
                File file = CndFileUtils.createLocalFile((String)soorceRoot).getAbsoluteFile();
                sourceFilesAndDirs.add(file);
            }
            RemoteProjectSupport.addExtraFiles(subMcs, sourceFilesAndDirs);
        }
        return sourceFilesAndDirs.toArray(new File[sourceFilesAndDirs.size()]);
    }

    private static void addExtraFiles(MakeConfigurationDescriptor subMcs, Set<File> filesToSync) {
        RemoteProjectSupport.addExtraFiles(subMcs, filesToSync, subMcs.getProjectItems());
        RemoteProjectSupport.addExtraFiles(subMcs, filesToSync, subMcs.getExternalFileItemsAsArray());
    }

    private static void addExtraFiles(MakeConfigurationDescriptor subMcs, Set<File> filesToSync, Item[] items) {
        SharabilityFilter filter = new SharabilityFilter();
        for (Item item : items) {
            File normFile = item.getNormalizedFile();
            if (!filter.accept(normFile)) {
                filesToSync.add(normFile);
                continue;
            }
            if (!RemoteProjectSupport.isContained(normFile, filesToSync)) {
                filesToSync.add(normFile);
                continue;
            }
            if (normFile.exists()) continue;
            filesToSync.add(normFile);
        }
    }

    private static boolean isContained(File normFile, Set<File> files) {
        String itemAbsPath = normFile.getAbsolutePath();
        for (File dir : files) {
            String alreadyAddedPath;
            if (!dir.isDirectory() || !itemAbsPath.startsWith(alreadyAddedPath = dir.getAbsolutePath() + File.separatorChar)) continue;
            return true;
        }
        return false;
    }
}

