/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.icefaces.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.jsf.icefaces.Icefaces2Customizer;
import org.netbeans.modules.web.jsf.icefaces.Icefaces2Implementation;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Icefaces2CustomizerPanelVisual
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(Icefaces2CustomizerPanelVisual.class.getName());
    private volatile Set<Library> icefacesLibraries = new HashSet<Library>();
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton createIcefacesLibraryButton;
    private JLabel headerLabel;
    private JComboBox icefacesLibraryComboBox;
    private JLabel icefacesLibraryLabel;
    private JLabel notExistingLibraryLabel;
    private JLabel noteLabel;

    public Icefaces2CustomizerPanelVisual(ChangeListener changeListener) {
        this.initComponents();
        this.noteLabel.setPreferredSize(new Dimension(1, 1));
        this.changeSupport.addChangeListener(changeListener);
        this.initLibraries(true);
        this.icefacesLibraryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Icefaces2CustomizerPanelVisual.this.changeSupport.fireChange();
            }
        });
    }

    public final void initLibraries(final boolean bl) {
        long l = System.currentTimeMillis();
        final ArrayList arrayList = new ArrayList();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (Library library : Icefaces2Customizer.getIcefacesLibraries()) {
                    arrayList.add(library.getDisplayName());
                    Icefaces2CustomizerPanelVisual.this.icefacesLibraries.add(library);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Icefaces2CustomizerPanelVisual.this.setLibrariesComboBox(Icefaces2CustomizerPanelVisual.this.icefacesLibraryComboBox, arrayList);
                        if (bl && !Icefaces2CustomizerPanelVisual.this.icefacesLibraries.isEmpty()) {
                            Icefaces2CustomizerPanelVisual.this.setDefaultComboBoxValues();
                        } else {
                            Icefaces2CustomizerPanelVisual.this.changeSupport.fireChange();
                        }
                    }
                });
            }
        });
        LOGGER.log(Level.FINEST, "Time spent in {0} initLibraries = {1} ms", new Object[]{this.getClass().getName(), System.currentTimeMillis() - l});
    }

    public String getIcefacesLibrary() {
        if (this.icefacesLibraryComboBox.getSelectedItem() != null) {
            return (String)this.icefacesLibraryComboBox.getSelectedItem();
        }
        return null;
    }

    public String getErrorMessage() {
        if (this.icefacesLibraries == null || this.icefacesLibraries.isEmpty()) {
            return NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"LBL_MissingIcefacesLibraries");
        }
        return null;
    }

    public String getWarningMessage() {
        return null;
    }

    private void setDefaultComboBoxValues() {
        Preferences preferences = Icefaces2Implementation.getIcefacesPreferences();
        this.icefacesLibraryComboBox.setSelectedItem(preferences.get("preffered-library", ""));
    }

    private void setLibrariesComboBox(JComboBox jComboBox, List<String> list) {
        jComboBox.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        jComboBox.setEnabled(!list.isEmpty());
    }

    private void initComponents() {
        this.headerLabel = new JLabel();
        this.icefacesLibraryLabel = new JLabel();
        this.icefacesLibraryComboBox = new JComboBox();
        this.notExistingLibraryLabel = new JLabel();
        this.createIcefacesLibraryButton = new JButton();
        this.noteLabel = new JLabel();
        this.headerLabel.setText(NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"Icefaces2CustomizerPanelVisual.headerLabel.text"));
        this.icefacesLibraryLabel.setText(NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"Icefaces2CustomizerPanelVisual.icefacesLibraryLabel.text"));
        this.icefacesLibraryComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Search ICEfaces Libraries..."}));
        this.notExistingLibraryLabel.setText(NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"Icefaces2CustomizerPanelVisual.notExistingLibraryLabel.text"));
        this.createIcefacesLibraryButton.setText(NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"Icefaces2CustomizerPanelVisual.createIcefacesLibraryButton.text"));
        this.createIcefacesLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Icefaces2CustomizerPanelVisual.this.createIcefacesLibraryButtonActionPerformed(actionEvent);
            }
        });
        this.noteLabel.setText(NbBundle.getMessage(Icefaces2CustomizerPanelVisual.class, (String)"Icefaces2CustomizerPanelVisual.noteLabel.text"));
        this.noteLabel.setVerticalAlignment(1);
        this.noteLabel.setVerticalTextPosition(1);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerLabel).addGroup(groupLayout.createSequentialGroup().addComponent(this.icefacesLibraryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.icefacesLibraryComboBox, 0, 336, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.notExistingLibraryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createIcefacesLibraryButton)).addComponent(this.noteLabel, -2, 501, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.headerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.icefacesLibraryLabel).addComponent(this.icefacesLibraryComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.notExistingLibraryLabel).addComponent(this.createIcefacesLibraryButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.noteLabel).addContainerGap()));
    }

    private void createIcefacesLibraryButtonActionPerformed(ActionEvent actionEvent) {
        LibrariesCustomizer.showCreateNewLibraryCustomizer((LibraryManager)LibraryManager.getDefault());
        this.initLibraries(false);
    }
}

