/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.jps.JpsProxy;
import org.netbeans.lib.profiler.jps.RunningVM;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class PIDSelectPanel
extends JPanel
implements ActionListener {
    private static final String REFRESH_BUTTON_NAME = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_RefreshButtonName");
    private static final String PID_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_PidLabelText");
    private static final String MAIN_CLASS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_MainClassLabelText");
    private static final String ARGUMENTS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ArgumentsLabelText");
    private static final String VM_ARGUMENTS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_VmArgumentsLabelText");
    private static final String VM_FLAGS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_VmFlagsLabelText");
    private static final String VM_COMBO_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_VmComboItemText");
    private static final String PROCESSES_LIST_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ProcessesListItemText");
    private static final String ERROR_GETTING_PROCESSES_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ErrorGettingProcessesItemText");
    private static final String NO_PROCESSES_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_NoProcessesItemText");
    private static final String SELECT_PROCESS_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_SelectProcessItemText");
    private static final String OK_BUTTON_NAME = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_OkButtonName");
    private static final String SELECT_PROCESS_DIALOG_CAPTION = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_SelectProcessDialogCaption");
    private static final String COMBO_ACCESS_NAME = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ComboAccessDescr");
    private static final String BUTTON_ACCESS_DESCR = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ButtonAccessDescr");
    private static final String PROCESS_DETAILS_ACCESS_NAME = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_SelectedProcessAccessName");
    private static final int MAX_WIDTH = 500;
    private JButton button;
    private JButton okButton;
    private JComboBox combo;
    private HTMLTextArea detailsArea;

    public PIDSelectPanel(JButton okButton) {
        this.okButton = okButton;
        this.combo = new JComboBox();
        this.button = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.button, (String)REFRESH_BUTTON_NAME);
        JPanel infoPanel = new JPanel(new BorderLayout());
        this.detailsArea = new HTMLTextArea();
        this.detailsArea.getAccessibleContext().setAccessibleName(PROCESS_DETAILS_ACCESS_NAME);
        this.detailsArea.setEditable(false);
        this.detailsArea.setOpaque(true);
        this.detailsArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.detailsArea.setPreferredSize(new Dimension(1, 1));
        JScrollPane detailsAreaScroll = new JScrollPane((Component)this.detailsArea, 20, 30);
        detailsAreaScroll.setBorder(BorderFactory.createEmptyBorder());
        detailsAreaScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        detailsAreaScroll.setPreferredSize(new Dimension(250, 200));
        infoPanel.add((Component)detailsAreaScroll, "Center");
        this.combo.setRenderer(new PIDComboRenderer());
        this.combo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
        this.combo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
        this.button.getAccessibleContext().setAccessibleDescription(BUTTON_ACCESS_DESCR);
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout(0, 10));
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout(5, 0));
        northPanel.add((Component)this.combo, "Center");
        northPanel.add((Component)this.button, "East");
        this.add((Component)northPanel, "North");
        this.add((Component)infoPanel, "Center");
        okButton.setEnabled(false);
        this.refreshCombo();
        this.button.addActionListener(this);
        this.combo.addActionListener(this);
    }

    public int getPID() {
        Object sel = this.combo.getSelectedItem();
        if (sel != null && sel instanceof RunningVM) {
            return ((RunningVM)sel).getPid();
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(Math.max(d.width, 500), d.height);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            this.refreshCombo();
        } else if (e.getSource() == this.combo) {
            this.okButton.setEnabled(this.combo.getSelectedItem() instanceof RunningVM);
            this.updateInfo();
        }
    }

    public static int selectPID() {
        JButton okButton = new JButton(OK_BUTTON_NAME);
        PIDSelectPanel pidSelect = new PIDSelectPanel(okButton);
        DialogDescriptor dd = new DialogDescriptor((Object)pidSelect, SELECT_PROCESS_DIALOG_CAPTION, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        if (dd.getValue() == okButton) {
            return pidSelect.getPID();
        }
        return -1;
    }

    private void refreshCombo() {
        this.okButton.setEnabled(false);
        this.combo.setEnabled(false);
        this.combo.setModel(new DefaultComboBoxModel<Object>(new Object[]{PROCESSES_LIST_ITEM_TEXT}));
        new SwingWorker<Object[], Object>(){

            @Override
            protected Object[] doInBackground() throws Exception {
                RunningVM[] vms = JpsProxy.getRunningVMs();
                Object[] ar = new Object[(vms == null ? 0 : vms.length) + 1];
                if (vms == null) {
                    ar[0] = ERROR_GETTING_PROCESSES_ITEM_TEXT;
                } else if (vms.length == 0) {
                    ar[0] = NO_PROCESSES_ITEM_TEXT;
                } else {
                    ar[0] = SELECT_PROCESS_ITEM_TEXT;
                    System.arraycopy(vms, 0, ar, 1, vms.length);
                }
                return ar;
            }

            @Override
            protected void done() {
                try {
                    PIDSelectPanel.this.combo.setEnabled(true);
                    PIDSelectPanel.this.combo.setModel(new DefaultComboBoxModel<Object>((Object[])this.get()));
                    PIDSelectPanel.this.updateInfo();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }.execute();
    }

    private void updateInfo() {
        String pid = "";
        String mainClass = "";
        String arguments = "";
        String vmArguments = "";
        String vmFlags = "";
        Object sel = this.combo.getSelectedItem();
        if (sel != null && sel instanceof RunningVM) {
            RunningVM vm = (RunningVM)sel;
            pid = "" + vm.getPid();
            mainClass = vm.getMainClass();
            arguments = vm.getMainArgs();
            vmArguments = vm.getVMArgs();
            vmFlags = vm.getVMFlags();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table cellspacing=\"3\" cellpadding=\"0\">");
        buffer.append("<tr>");
        buffer.append("<td><nobr><b>");
        buffer.append(PID_LABEL_TEXT);
        buffer.append("</b>&nbsp;&nbsp;</nobr></td>");
        buffer.append("<td>");
        buffer.append(pid);
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("<tr>");
        buffer.append("<td><nobr><b>");
        buffer.append(MAIN_CLASS_LABEL_TEXT);
        buffer.append("</b>&nbsp;&nbsp;</nobr></td>");
        buffer.append("<td>");
        buffer.append(mainClass);
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("<tr>");
        buffer.append("<td><nobr><b>");
        buffer.append(ARGUMENTS_LABEL_TEXT);
        buffer.append("</b>&nbsp;&nbsp;</nobr></td>");
        buffer.append("<td>");
        buffer.append(arguments);
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("<tr>");
        buffer.append("<td><nobr><b>");
        buffer.append(VM_ARGUMENTS_LABEL_TEXT);
        buffer.append("</b>&nbsp;&nbsp;</nobr></td>");
        buffer.append("<td>");
        buffer.append(vmArguments);
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("<tr>");
        buffer.append("<td><nobr><b>");
        buffer.append(VM_FLAGS_LABEL_TEXT);
        buffer.append("</b>&nbsp;&nbsp;</nobr></td>");
        buffer.append("<td>");
        buffer.append(vmFlags);
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("</table>");
        this.detailsArea.setText(buffer.toString());
        this.detailsArea.setCaretPosition(0);
    }

    private static class PIDComboRenderer
    extends DefaultListCellRenderer {
        private PIDComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof RunningVM) {
                RunningVM vm = (RunningVM)value;
                String args = vm.getMainArgs();
                args = args == null ? "" : " " + args;
                String text = MessageFormat.format(VM_COMBO_ITEM_TEXT, vm.getMainClass(), "" + vm.getPid());
                return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

