/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public final class GetCmdLineArgumentsAction
extends AbstractAction
implements ProfilingStateListener {
    private static final String TARGET_JVM_INACTIVE_MSG = NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"GetCmdLineArgumentsAction_TargetJvmInactiveMsg");
    private static final String JVM_ARGUMENTS_STRING = NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"GetCmdLineArgumentsAction_JvmArgumentsString");
    private static final String MAIN_CLASS_AND_ARGS_STRING = NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"GetCmdLineArgumentsAction_MainClassAndArgsString");

    public GetCmdLineArgumentsAction() {
        this.putValue("Name", NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"LBL_GetCmdLineArgumentsAction"));
        this.putValue("ShortDescription", NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"HINT_GetCmdLineArgumentsAction"));
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.updateEnabledState();
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            String javaCommand;
            String jvmArgs;
            TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
            ProfilerClient profilerClient = runner.getProfilerClient();
            ProfilingSessionStatus status = runner.getProfilingSessionStatus();
            ProfilerEngineSettings settings = runner.getProfilerEngineSettings();
            if (!profilerClient.targetJVMIsAlive()) {
                throw new ClientUtils.TargetAppOrVMTerminated(1, TARGET_JVM_INACTIVE_MSG);
            }
            if (status.runningInAttachedMode) {
                jvmArgs = status.jvmArguments;
                javaCommand = status.javaCommand;
            } else {
                jvmArgs = settings.getJVMArgsAsSingleString();
                javaCommand = settings.getMainClassName() + " " + settings.getMainArgsAsSingleString();
            }
            StringBuffer s = new StringBuffer();
            s.append("<b>");
            s.append(JVM_ARGUMENTS_STRING);
            s.append("</b><br>");
            s.append(jvmArgs);
            s.append("<br><br>");
            s.append("<b>");
            s.append(MAIN_CLASS_AND_ARGS_STRING);
            s.append("</b><br>");
            s.append(javaCommand);
            HTMLTextArea textArea = new HTMLTextArea(s.toString());
            textArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"CAPTION_JVMandMainClassCommandLineArguments"));
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            p.add((Component)new JScrollPane((Component)textArea), "Center");
            p.setPreferredSize(new Dimension(600, 200));
            DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)p, NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"CAPTION_JVMandMainClassCommandLineArguments"), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null)).setVisible(true);
        }
        catch (ClientUtils.TargetAppOrVMTerminated e) {
            ProfilerDialogs.displayWarning((String)MessageFormat.format(NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"MSG_NotAvailableNow"), e.getMessage()));
        }
    }

    public void profilingStateChanged(ProfilingStateEvent e) {
        this.updateEnabledState();
    }

    public void threadsMonitoringChanged() {
    }

    public void instrumentationChanged(int oldInstrType, int currentInstrType) {
    }

    private void updateEnabledState() {
        this.setEnabled(Profiler.getDefault().getProfilingState() == 4);
    }
}

