/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.util.ArrayList;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.panels.ClassSelectRootMethodsPanel;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public abstract class BaseSelectRootMethodsAction
extends NodeAction {
    private static final String NO_CLASS_FOUND_MSG = NbBundle.getMessage(BaseSelectRootMethodsAction.class, (String)"SelectRootMethodsAction_NoClassFoundMsg");

    public BaseSelectRootMethodsAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(BaseSelectRootMethodsAction.class, (String)"LBL_SelectRootMethodsAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodes) {
        return true;
    }

    protected void performAction(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        final DataObject dobj = (DataObject)nodes[0].getLookup().lookup(DataObject.class);
        if (dobj == null) {
            return;
        }
        new NBSwingWorker(){
            String className = null;

            protected void doInBackground() {
                this.className = BaseSelectRootMethodsAction.this.getFileClassName(JavaProfilerSource.createFrom((FileObject)dobj.getPrimaryFile()));
            }

            protected void done() {
                if (this.className != null) {
                    Lookup.Provider project = ProjectUtilities.getProject((FileObject)dobj.getPrimaryFile());
                    ProfilingSettings[] projectSettings = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)project).getProfilingSettings();
                    ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings settings : projectSettings) {
                        if (!ProfilingSettings.isCPUSettings((int)settings.getProfilingType())) continue;
                        cpuSettings.add(settings);
                    }
                    ProfilingSettings settings = IDEUtils.selectSettings(16, cpuSettings.toArray(new ProfilingSettings[cpuSettings.size()]), null);
                    if (settings == null) {
                        return;
                    }
                    ClientUtils.SourceCodeSelection[] rootMethodsSelection = ClassSelectRootMethodsPanel.getDefault().getRootMethods(dobj.getPrimaryFile(), settings.getInstrumentationRootMethods());
                    if (rootMethodsSelection == null) {
                        return;
                    }
                    settings.addRootMethods(rootMethodsSelection);
                    if (cpuSettings.contains(settings)) {
                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])projectSettings, (ProfilingSettings)settings, (Lookup.Provider)project);
                    } else {
                        ProfilingSettings[] newProjectSettings = new ProfilingSettings[projectSettings.length + 1];
                        System.arraycopy(projectSettings, 0, newProjectSettings, 0, projectSettings.length);
                        newProjectSettings[projectSettings.length] = settings;
                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])newProjectSettings, (ProfilingSettings)settings, (Lookup.Provider)project);
                    }
                } else {
                    ProfilerDialogs.displayError((String)NO_CLASS_FOUND_MSG);
                }
            }
        }.execute();
    }

    protected abstract String getFileClassName(JavaProfilerSource var1);
}

